/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.huaweicloud.common.disovery.ServiceCenterUtils;
import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.common.transport.ServiceCombRBACProperties;
import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.service.center.client.OperationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.model.RbacTokenRequest;
import org.apache.servicecomb.service.center.client.model.RbacTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACRequestAuthHeaderProvider
implements AuthHeaderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RBACRequestAuthHeaderProvider.class);
    public static final String INVALID_TOKEN = "invalid";
    private static final String UN_AUTHORIZED_CODE_HALF_OPEN = "401302";
    public static final String CACHE_KEY = "token";
    public static final String AUTH_HEADER = "Authorization";
    private static final long TOKEN_REFRESH_TIME_IN_SECONDS = 1200000L;
    private final DiscoveryBootstrapProperties discoveryProperties;
    private final ServiceCombSSLProperties serviceCombSSLProperties;
    private final ServiceCombRBACProperties serviceCombRBACProperties;
    private ExecutorService executorService;
    private LoadingCache<String, String> cache;
    private String lastErrorCode = "401302";
    private int lastStatusCode = 401;

    public RBACRequestAuthHeaderProvider(DiscoveryBootstrapProperties discoveryProperties, ServiceCombSSLProperties serviceCombSSLProperties, ServiceCombRBACProperties serviceCombRBACProperties) {
        this.discoveryProperties = discoveryProperties;
        this.serviceCombSSLProperties = serviceCombSSLProperties;
        this.serviceCombRBACProperties = serviceCombRBACProperties;
        EventManager.getEventBus().register((Object)this);
        if (this.enabled()) {
            this.executorService = Executors.newFixedThreadPool(1, t -> new Thread(t, "rbac-executor"));
            this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(this.refreshTime(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, String>(){

                public String load(String key) {
                    return RBACRequestAuthHeaderProvider.this.createHeaders();
                }

                public ListenableFuture<String> reload(String key, String oldValue) {
                    return Futures.submit(() -> RBACRequestAuthHeaderProvider.this.createHeaders(), (Executor)RBACRequestAuthHeaderProvider.this.executorService);
                }
            });
        }
    }

    @Subscribe
    public void onNotPermittedEvent(OperationEvents.UnAuthorizedOperationEvent event) {
        this.executorService.submit(this::retryRefresh);
    }

    protected String createHeaders() {
        LOGGER.info("start to create RBAC headers");
        RbacTokenResponse rbacTokenResponse = this.callCreateHeaders();
        this.lastErrorCode = rbacTokenResponse.getErrorCode();
        this.lastStatusCode = rbacTokenResponse.getStatusCode();
        if (Response.Status.UNAUTHORIZED.getStatusCode() == rbacTokenResponse.getStatusCode() || Response.Status.FORBIDDEN.getStatusCode() == rbacTokenResponse.getStatusCode()) {
            LOGGER.warn("username or password may be wrong, stop trying to query tokens.");
            return INVALID_TOKEN;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == rbacTokenResponse.getStatusCode()) {
            LOGGER.warn("service center do not support RBAC token, you should not config account info");
            return INVALID_TOKEN;
        }
        LOGGER.info("refresh token successfully {}", (Object)rbacTokenResponse.getStatusCode());
        return rbacTokenResponse.getToken();
    }

    protected RbacTokenResponse callCreateHeaders() {
        ServiceCenterClient serviceCenterClient = ServiceCenterUtils.serviceCenterClient(this.discoveryProperties, this.serviceCombSSLProperties, Collections.emptyList());
        RbacTokenRequest request = new RbacTokenRequest();
        request.setName(this.serviceCombRBACProperties.getName());
        request.setPassword(this.serviceCombRBACProperties.getPassword());
        return serviceCenterClient.queryToken(request);
    }

    protected long refreshTime() {
        return 1200000L;
    }

    public Map<String, String> authHeaders() {
        if (!this.enabled()) {
            return Collections.emptyMap();
        }
        try {
            String header = (String)this.cache.get((Object)CACHE_KEY);
            if (!StringUtils.isEmpty((CharSequence)header)) {
                HashMap<String, String> tokens = new HashMap<String, String>(1);
                tokens.put(AUTH_HEADER, "Bearer " + header);
                return tokens;
            }
        }
        catch (Exception e) {
            LOGGER.error("Get auth headers failed", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private boolean enabled() {
        return !StringUtils.isEmpty((CharSequence)this.serviceCombRBACProperties.getName()) && !StringUtils.isEmpty((CharSequence)this.serviceCombRBACProperties.getPassword());
    }

    private void retryRefresh() {
        if (Response.Status.UNAUTHORIZED.getStatusCode() == this.lastStatusCode && UN_AUTHORIZED_CODE_HALF_OPEN.equals(this.lastErrorCode)) {
            this.cache.refresh((Object)this.discoveryProperties.getServiceName());
        }
    }
}

