/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.util;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);

    public static String getLocalHost() {
        return NetUtils.getHostName();
    }

    public static Integer getPort(String url) {
        URIBuilder endpointURIBuilder = null;
        try {
            endpointURIBuilder = new URIBuilder(url);
            Integer port = endpointURIBuilder.build().getPort();
            return port;
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getHost(String url) {
        URIBuilder endpointURIBuilder = null;
        String host = null;
        try {
            endpointURIBuilder = new URIBuilder(url);
            host = endpointURIBuilder.build().getHost();
            return host;
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return host;
        }
    }
}

