/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class URLUtil {
    private static final String SCHEMA_SEPRATOR = "://";
    private static final String IPPORT_SEPRATOR = ":";
    private static final String SYSTEM_KEY_BOTH = "PAAS_CSE_ENDPOINT";
    private static final String SYSTEM_KEY_SERVICE_CENTER = "PAAS_CSE_SC_ENDPOINT";
    private static final String SYSTEM_KEY_CONFIG_CENTER = "PAAS_CSE_CC_ENDPOINT";

    public static String[] splitIpPort(String url) {
        String[] res = new String[]{url.substring(url.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length(), url.lastIndexOf(IPPORT_SEPRATOR)), url.substring(url.lastIndexOf(IPPORT_SEPRATOR) + 1)};
        if (res[1].contains("/")) {
            res[1] = res[1].substring(0, res[1].indexOf("/"));
        } else if (res[1].contains("?")) {
            res[1] = res[1].substring(0, res[1].indexOf("?"));
        }
        return res;
    }

    public static String transform(String restUrl) {
        if (restUrl == null) {
            return null;
        }
        String scheme = "http";
        if (URLUtil.isSSLEnable(restUrl)) {
            scheme = "https";
        }
        if (restUrl.contains("?")) {
            return scheme + SCHEMA_SEPRATOR + restUrl.substring(restUrl.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length(), restUrl.indexOf("?"));
        }
        return scheme + SCHEMA_SEPRATOR + restUrl.substring(restUrl.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length());
    }

    private static boolean isSSLEnable(String url) {
        String[] params;
        int index = url.indexOf("?");
        if (index == -1) {
            return false;
        }
        String param = url.substring(index + 1);
        for (String item : params = param.split("&")) {
            String[] kv = item.split("=");
            if (!"sslEnabled".equals(kv[0]) || !"true".equals(kv[1])) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquals(String url1, String url2) {
        if (StringUtils.isEmpty((CharSequence)url1) || StringUtils.isEmpty((CharSequence)url2)) {
            return false;
        }
        String url1ComparePart = url1.substring(url1.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length());
        String url2ComparePart = url2.substring(url2.indexOf(SCHEMA_SEPRATOR) + SCHEMA_SEPRATOR.length());
        return URLUtil.removeSlash(url1ComparePart).equals(URLUtil.removeSlash(url2ComparePart));
    }

    private static String removeSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static List<String> dealMultiUrl(String urls) {
        ArrayList<String> urlList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)urls)) {
            return urlList;
        }
        if (urls.indexOf(",") > 0) {
            Arrays.stream(urls.split(",")).filter(url -> !StringUtils.isEmpty((CharSequence)url)).forEach(urlList::add);
        } else {
            urlList.add(urls);
        }
        return urlList;
    }

    public static List<String> getEnvConfigUrl() {
        return URLUtil.getEnvURL(SYSTEM_KEY_CONFIG_CENTER);
    }

    public static List<String> getEnvServerURL() {
        return URLUtil.getEnvURL(SYSTEM_KEY_SERVICE_CENTER);
    }

    private static List<String> getEnvURL(String systemServer) {
        SystemConfiguration sysConfig = new SystemConfiguration();
        List result = sysConfig.getList(systemServer);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            return URLUtil.toStringList(result);
        }
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        result = envConfig.getList(systemServer);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            return URLUtil.toStringList(result);
        }
        result = sysConfig.getList(SYSTEM_KEY_BOTH);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            return URLUtil.toStringList(result);
        }
        result = envConfig.getList(SYSTEM_KEY_BOTH);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            return URLUtil.toStringList(result);
        }
        return Collections.emptyList();
    }

    private static List<String> toStringList(List<Object> list) {
        return list.stream().map(obj -> Objects.toString(obj, null)).collect(Collectors.toList());
    }
}

