/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.governance;

import com.huaweicloud.governance.SpringCloudInvocationContext;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.retry.Retry;
import io.vavr.CheckedFunction0;
import java.io.IOException;
import java.io.Serializable;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.handler.ext.ClientRecoverPolicy;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class GovernanceClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @Autowired
    private RetryHandler retryHandler;
    @Autowired(required=false)
    private ClientRecoverPolicy<Object> clientRecoverPolicy;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        GovernanceRequest governanceRequest = this.convert(request);
        CheckedFunction0 & Serializable next = (CheckedFunction0 & Serializable)() -> execution.execute(request, body);
        Decorators.DecorateCheckedSupplier dcs = Decorators.ofCheckedSupplier((CheckedFunction0)next);
        try {
            SpringCloudInvocationContext.setInvocationContext();
            this.addRetry((Decorators.DecorateCheckedSupplier<ClientHttpResponse>)dcs, governanceRequest);
            ClientHttpResponse clientHttpResponse = (ClientHttpResponse)dcs.get();
            return clientHttpResponse;
        }
        catch (Throwable e) {
            if (this.clientRecoverPolicy != null) {
                ClientHttpResponse clientHttpResponse = (ClientHttpResponse)this.clientRecoverPolicy.apply(e);
                return clientHttpResponse;
            }
            throw new RuntimeException(e);
        }
        finally {
            SpringCloudInvocationContext.removeInvocationContext();
        }
    }

    private GovernanceRequest convert(HttpRequest request) {
        GovernanceRequest governanceRequest = new GovernanceRequest();
        governanceRequest.setUri(request.getURI().getPath());
        governanceRequest.setMethod(request.getMethod().name());
        governanceRequest.setHeaders(request.getHeaders().toSingleValueMap());
        return governanceRequest;
    }

    private void addRetry(Decorators.DecorateCheckedSupplier<ClientHttpResponse> dcs, GovernanceRequest request) {
        Retry retry = (Retry)this.retryHandler.getActuator(request);
        if (retry != null) {
            dcs.withRetry(retry);
        }
    }
}

