/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.governance;

import com.huaweicloud.common.event.ConfigRefreshEvent;
import com.huaweicloud.governance.GovernanceClientHttpRequestInterceptor;
import com.huaweicloud.governance.GovernanceFeignClient;
import com.huaweicloud.governance.GovernanceRequestMappingHandlerAdapter;
import com.huaweicloud.governance.SpringCloudInvocationContext;
import com.huaweicloud.governance.SpringCloudMicroserviceMeta;
import com.huaweicloud.governance.SpringCloudRetryExtension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.servicecomb.governance.InvocationContext;
import org.apache.servicecomb.governance.MicroserviceMeta;
import org.apache.servicecomb.governance.event.ConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.EventManager;
import org.apache.servicecomb.governance.handler.ext.RetryExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ComponentScan(basePackages={"org.apache.servicecomb.governance"})
public class GovernanceConfiguration {
    @Bean
    @ConditionalOnClass(name={"org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter"})
    public GovernanceRequestMappingHandlerAdapter governanceRequestMappingHandlerAdapter() {
        return new GovernanceRequestMappingHandlerAdapter();
    }

    @Bean
    public ApplicationListener<ConfigRefreshEvent> governanceApplicationListener() {
        return configRefreshEvent -> EventManager.post((Object)new ConfigurationChangedEvent(new HashSet(configRefreshEvent.getChange())));
    }

    @Bean
    @ConditionalOnClass(value={RestTemplate.class})
    public GovernanceClientHttpRequestInterceptor governanceClientHttpRequestInterceptor(@Autowired(required=false) @LoadBalanced List<RestTemplate> restTemplates) {
        return new GovernanceClientHttpRequestInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public RestTemplateCustomizer governanceRestTemplateCustomizer(GovernanceClientHttpRequestInterceptor governanceClientHttpRequestInterceptor, LoadBalancerInterceptor loadBalancerInterceptor) {
        return restTemplate -> {
            ArrayList<Object> list = new ArrayList<Object>(restTemplate.getInterceptors());
            list.add(loadBalancerInterceptor);
            list.add(governanceClientHttpRequestInterceptor);
            restTemplate.setInterceptors(list);
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient"})
    public GovernanceFeignClient governanceFeignClient() {
        return new GovernanceFeignClient();
    }

    @Bean
    public MicroserviceMeta governanceMicroserviceMeta() {
        return new SpringCloudMicroserviceMeta();
    }

    @Bean
    public InvocationContext governanceInvocationContext() {
        return new SpringCloudInvocationContext();
    }

    @Bean
    public RetryExtension governanceRetryExtension() {
        return new SpringCloudRetryExtension();
    }
}

