/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.governance;

import com.huaweicloud.governance.SpringCloudInvocationContext;
import feign.Request;
import feign.Response;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.retry.Retry;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.handler.ext.ClientRecoverPolicy;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class GovernanceFeignClient {
    @Autowired
    private RetryHandler retryHandler;
    @Autowired(required=false)
    private ClientRecoverPolicy<Object> clientRecoverPolicy;

    @Pointcut(value="execution(* org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient.execute(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object aroundInvoke(ProceedingJoinPoint pjp) throws Throwable {
        Request request = (Request)pjp.getArgs()[0];
        GovernanceRequest governanceRequest = this.convert(request);
        CheckedFunction0 & Serializable next = () -> ((ProceedingJoinPoint)pjp).proceed();
        Decorators.DecorateCheckedSupplier dcs = Decorators.ofCheckedSupplier((CheckedFunction0)next);
        try {
            SpringCloudInvocationContext.setInvocationContext();
            this.addRetry((Decorators.DecorateCheckedSupplier<Object>)dcs, governanceRequest);
            Object object = dcs.get();
            return object;
        }
        catch (Throwable e) {
            if (this.clientRecoverPolicy != null) {
                Response response = (Response)this.clientRecoverPolicy.apply(e);
                return response;
            }
            throw new RuntimeException(e);
        }
        finally {
            SpringCloudInvocationContext.removeInvocationContext();
        }
    }

    private GovernanceRequest convert(Request request) {
        GovernanceRequest governanceRequest = new GovernanceRequest();
        try {
            URL url = new URL(request.url());
            governanceRequest.setUri(url.getPath());
            governanceRequest.setMethod(request.method());
            HashMap headers = new HashMap(request.headers().size());
            request.headers().forEach((k, v) -> {
                String cfr_ignored_0 = (String)headers.put(k, v.iterator().next());
            });
            governanceRequest.setHeaders(headers);
            return governanceRequest;
        }
        catch (MalformedURLException e) {
            return governanceRequest;
        }
    }

    private void addRetry(Decorators.DecorateCheckedSupplier<Object> dcs, GovernanceRequest request) {
        Retry retry = (Retry)this.retryHandler.getActuator(request);
        if (retry != null) {
            dcs.withRetry(retry);
        }
    }
}

