/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.governance;

import com.huaweicloud.common.util.HeaderUtil;
import com.huaweicloud.governance.SpringCloudInvocationContext;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.governance.handler.BulkheadHandler;
import org.apache.servicecomb.governance.handler.CircuitBreakerHandler;
import org.apache.servicecomb.governance.handler.RateLimitingHandler;
import org.apache.servicecomb.governance.handler.ext.ServerRecoverPolicy;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class GovernanceRequestMappingHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GovernanceRequestMappingHandlerAdapter.class);
    @Autowired
    private RateLimitingHandler rateLimitingHandler;
    @Autowired
    private CircuitBreakerHandler circuitBreakerHandler;
    @Autowired
    private BulkheadHandler bulkheadHandler;
    @Autowired(required=false)
    private ServerRecoverPolicy<Object> serverRecoverPolicy;

    @Pointcut(value="execution(* org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.handleInternal(..))")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut()")
    public Object aroundInvoke(ProceedingJoinPoint pjp) throws Throwable {
        block10: {
            HttpServletRequest request = (HttpServletRequest)pjp.getArgs()[0];
            HttpServletResponse response = (HttpServletResponse)pjp.getArgs()[1];
            GovernanceRequest governanceRequest = this.convert(request);
            CheckedFunction0 & Serializable next = () -> ((ProceedingJoinPoint)pjp).proceed();
            Decorators.DecorateCheckedSupplier dcs = Decorators.ofCheckedSupplier((CheckedFunction0)next);
            try {
                SpringCloudInvocationContext.setInvocationContext();
                this.addRateLimiting((Decorators.DecorateCheckedSupplier<Object>)dcs, governanceRequest);
                this.addBulkhead((Decorators.DecorateCheckedSupplier<Object>)dcs, governanceRequest);
                this.addCircuitBreaker((Decorators.DecorateCheckedSupplier<Object>)dcs, governanceRequest);
                Object object = dcs.get();
                return object;
            }
            catch (Throwable th) {
                if (th instanceof RequestNotPermitted) {
                    response.setStatus(429);
                    response.getWriter().print("rate limited.");
                    LOGGER.warn("the request is rate limit by policy : {}", (Object)th.getMessage());
                    break block10;
                }
                if (th instanceof CallNotPermittedException) {
                    response.setStatus(429);
                    response.getWriter().print("circuitBreaker is open.");
                    LOGGER.warn("circuitBreaker is open by policy : {}", (Object)th.getMessage());
                    break block10;
                }
                if (th instanceof BulkheadFullException) {
                    response.setStatus(429);
                    response.getWriter().print("bulkhead is full and does not permit further calls.");
                    LOGGER.warn("bulkhead is full and does not permit further calls by policy : {}", (Object)th.getMessage());
                    break block10;
                }
                if (this.serverRecoverPolicy != null) {
                    Object object = this.serverRecoverPolicy.apply(th);
                    return object;
                }
                throw th;
            }
            finally {
                SpringCloudInvocationContext.removeInvocationContext();
            }
        }
        return null;
    }

    private GovernanceRequest convert(HttpServletRequest request) {
        GovernanceRequest govHttpRequest = new GovernanceRequest();
        govHttpRequest.setHeaders(HeaderUtil.getHeaders((HttpServletRequest)request));
        govHttpRequest.setMethod(request.getMethod());
        govHttpRequest.setUri(request.getRequestURI());
        return govHttpRequest;
    }

    private void addBulkhead(Decorators.DecorateCheckedSupplier<Object> dcs, GovernanceRequest request) {
        Bulkhead bulkhead = (Bulkhead)this.bulkheadHandler.getActuator(request);
        if (bulkhead != null) {
            dcs.withBulkhead(bulkhead);
        }
    }

    private void addCircuitBreaker(Decorators.DecorateCheckedSupplier<Object> dcs, GovernanceRequest request) {
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerHandler.getActuator(request);
        if (circuitBreaker != null) {
            dcs.withCircuitBreaker(circuitBreaker);
        }
    }

    private void addRateLimiting(Decorators.DecorateCheckedSupplier<Object> dcs, GovernanceRequest request) {
        RateLimiter rateLimiter = (RateLimiter)this.rateLimitingHandler.getActuator(request);
        if (rateLimiter != null) {
            dcs.withRateLimiter(rateLimiter);
        }
    }
}

