/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.governance;

import feign.Response;
import java.io.IOException;
import java.util.List;
import org.apache.servicecomb.governance.handler.ext.RetryExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpServerErrorException;

public class SpringCloudRetryExtension
implements RetryExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudRetryExtension.class);

    public boolean isRetry(List<Integer> statusList, Object response) {
        int status = 0;
        if (response instanceof ClientHttpResponse) {
            try {
                status = ((ClientHttpResponse)response).getStatusCode().value();
            }
            catch (IOException e) {
                LOGGER.error("unexpected exception", (Throwable)e);
            }
        }
        if (response instanceof Response) {
            status = ((Response)response).status();
        }
        return statusList.contains(status);
    }

    public Class<? extends Throwable>[] retryExceptions() {
        return new Class[]{HttpServerErrorException.class};
    }
}

