/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.fn;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.beetl.core.Context;
import org.beetl.core.Function;

public class TruncFunction2
implements Function {
    public Object call(Object[] paras, Context ctx) {
        Object obj = paras[0];
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return this.truncateDate((Date)obj, (String)(paras.length == 1 ? null : paras[1]));
        }
        if (obj instanceof Number) {
            return this.truncateNumber((Number)obj, (Number)(paras.length == 1 ? null : paras[1]));
        }
        throw new UnsupportedOperationException("truncate :" + obj.getClass().getName());
    }

    protected String truncateNumber(Number data, Number pos) {
        String str = data.toString();
        int index = str.indexOf(".");
        if (index == -1) {
            return str;
        }
        if (pos == null) {
            return str.substring(0, index);
        }
        int p = pos.intValue();
        if (p == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a0");
        }
        int dig = str.length() - index - 1;
        return dig >= p ? str.substring(0, index + p + 1) : str;
    }

    protected String truncateDate(Date d, String format) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static void main(String[] args) {
        TruncFunction2 f = new TruncFunction2();
        System.out.println(f.truncateNumber(116.136, 2));
        System.out.println(f.truncateDate(new Date(), "MM"));
    }
}

