/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.format;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Format;

public class DateFormat
implements Format {
    private static final String DEFAULT_KEY = "default";
    private ThreadLocal<Map<String, SimpleDateFormat>> threadlocal = new ThreadLocal();

    public Object format(Object data, String pattern) {
        if (data == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(data.getClass())) {
            SimpleDateFormat sdf = pattern == null ? this.getDateFormat(DEFAULT_KEY) : this.getDateFormat(pattern);
            return sdf.format((Date)data);
        }
        if (data.getClass() == Long.class) {
            Date date = new Date((Long)data);
            SimpleDateFormat sdf = pattern == null ? this.getDateFormat(DEFAULT_KEY) : this.getDateFormat(pattern);
            return sdf.format(date);
        }
        if (data instanceof LocalDateTime) {
            if (pattern == null || pattern.length() == 0) {
                return data;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            return ((LocalDateTime)data).format(formatter);
        }
        throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u8f93\u5165\u4e3a\u65e5\u671f\u6216\u8005Long:" + data.getClass());
    }

    private SimpleDateFormat getDateFormat(String pattern) {
        SimpleDateFormat format;
        Map<String, SimpleDateFormat> map = null;
        map = this.threadlocal.get();
        if (map == null) {
            map = new HashMap<String, SimpleDateFormat>(4, 0.65f);
            this.threadlocal.set(map);
        }
        if ((format = map.get(pattern)) == null) {
            format = DEFAULT_KEY.equals(pattern) ? new SimpleDateFormat() : new SimpleDateFormat(pattern);
            map.put(pattern, format);
        }
        return format;
    }
}

