/*
 * Decompiled with CFR 0.152.
 */
package com.ibeetl.starter;

import com.ibeetl.starter.BeetlSqlProperties;
import com.ibeetl.starter.BeetlSqlStarterClassPathScanner;
import java.util.Properties;
import org.beetl.core.om.ObjectUtil;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.ext.spring4.BeetlSqlDataSource;
import org.beetl.sql.ext.spring4.SqlManagerFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class BeetlMapperMutipleScannerRegister
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    Environment env;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String[] sources;
        this.readyBeetlSqlSource(registry);
        this.readySqlManager(registry);
        BeetlSqlStarterClassPathScanner scanner = new BeetlSqlStarterClassPathScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        String sourceConfig = this.env.getProperty("beetlsql.mutiple.datasource");
        String[] stringArray = sources = sourceConfig.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String dbSource;
            String masterSource = dbSource = stringArray[i];
            BeetlSqlProperties ps = new BeetlSqlProperties(this.env, masterSource);
            scanner.setSqlManagerFactoryBeanName(masterSource + "SqlManagerFactoryBean");
            scanner.setSuffix(ps.getDaoSuffix());
            scanner.registerFilters();
            scanner.doScan(ps.getBasePackage().split(","));
        }
    }

    protected void readyBeetlSqlSource(BeanDefinitionRegistry registry) {
        String[] sources;
        String sourceConfig = this.env.getProperty("beetlsql.mutiple.datasource");
        String[] stringArray = sources = sourceConfig.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String dbSource;
            String masterSource = dbSource = stringArray[i];
            BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(BeetlSqlDataSource.class);
            bdb.addPropertyValue("masterSource", (Object)new RuntimeBeanReference(masterSource));
            registry.registerBeanDefinition(masterSource + "BeetlSqlDataSourceBean", (BeanDefinition)bdb.getBeanDefinition());
        }
    }

    protected void readySqlManager(BeanDefinitionRegistry registry) {
        String[] sources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String sourceConfig = this.env.getProperty("beetlsql.mutiple.datasource");
        String[] stringArray = sources = sourceConfig.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Interceptor[] interceptorArray;
            String dbSource;
            String masterSource = dbSource = stringArray[i];
            BeetlSqlProperties beetlSqlProperties = new BeetlSqlProperties(this.env, masterSource);
            ClasspathLoader loader = new ClasspathLoader(beetlSqlProperties.getSqlPath());
            Properties ps = new Properties();
            ps.put("PRODUCT_MODE", beetlSqlProperties.dev != false ? "false" : "true");
            BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition(SqlManagerFactoryBean.class);
            bdb.addPropertyValue("cs", (Object)new RuntimeBeanReference(masterSource + "BeetlSqlDataSourceBean"));
            bdb.addPropertyValue("dbStyle", (Object)((DBStyle)ObjectUtil.tryInstance((String)beetlSqlProperties.getDbStyle(), (ClassLoader)classLoader)));
            if (beetlSqlProperties.dev.booleanValue()) {
                Interceptor[] interceptorArray2 = new Interceptor[1];
                interceptorArray = interceptorArray2;
                interceptorArray2[0] = new DebugInterceptor();
            } else {
                interceptorArray = new Interceptor[]{};
            }
            bdb.addPropertyValue("interceptors", (Object)interceptorArray);
            bdb.addPropertyValue("sqlLoader", (Object)loader);
            bdb.addPropertyValue("nc", (Object)((NameConversion)ObjectUtil.tryInstance((String)beetlSqlProperties.getNameConversion(), (ClassLoader)classLoader)));
            bdb.addPropertyValue("extProperties", (Object)ps);
            registry.registerBeanDefinition(masterSource + "SqlManagerFactoryBean", (BeanDefinition)bdb.getBeanDefinition());
        }
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }
}

