/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import java.util.Collections;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.web.context.ServletContextAware;

public class AccessUrlIfFunction
implements Function,
ServletContextAware {
    private ServletContext servletContext = null;
    @Autowired
    private WebInvocationPrivilegeEvaluator privilegeEvaluator = null;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Boolean call(Object[] paras, Context ctx) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return true;
        }
        Authentication authentication = this.getAuthentication(securityContext);
        if (paras.length == 0 || paras[0] == null || !(paras[0] instanceof String)) {
            return true;
        }
        String url = (String)paras[0];
        String method = "GET";
        if (paras.length > 1 && paras[1] != null && paras[1] instanceof String) {
            method = (String)paras[1];
        }
        return this.privilegeEvaluator.isAllowed(this.servletContext.getContextPath(), url, method, authentication);
    }

    private Authentication getAuthentication(SecurityContext securityContext) {
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            authentication = new AnonymousAuthenticationToken(UUID.randomUUID().toString(), (Object)"anonymous", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ANONYMOUS")));
        }
        return authentication;
    }
}

