/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.core.remote.ClientConnectionEventListener;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ClientConnectionEventListenerRegistry {
    final List<ClientConnectionEventListener> clientConnectionEventListeners = new ArrayList<ClientConnectionEventListener>();

    public void notifyClientConnected(Connection connection) {
        for (ClientConnectionEventListener clientConnectionEventListener : this.clientConnectionEventListeners) {
            try {
                clientConnectionEventListener.clientConnected(connection);
            }
            catch (Throwable throwable) {
                Loggers.REMOTE.info("[NotifyClientConnected] failed for listener {}", (Object)clientConnectionEventListener.getName(), (Object)throwable);
            }
        }
    }

    public void notifyClientDisConnected(Connection connection) {
        for (ClientConnectionEventListener clientConnectionEventListener : this.clientConnectionEventListeners) {
            try {
                clientConnectionEventListener.clientDisConnected(connection);
            }
            catch (Throwable throwable) {
                Loggers.REMOTE.info("[NotifyClientDisConnected] failed for listener {}", (Object)clientConnectionEventListener.getName(), (Object)throwable);
            }
        }
    }

    public void registerClientConnectionEventListener(ClientConnectionEventListener listener) {
        Loggers.REMOTE.info("[ClientConnectionEventListenerRegistry] registry listener - " + listener.getClass().getSimpleName());
        this.clientConnectionEventListeners.add(listener);
    }
}

