/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.core.remote.RequestFilters;
import com.alibaba.nacos.core.utils.Loggers;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RequestHandler<T extends Request, S extends Response> {
    @Autowired
    private RequestFilters requestFilters;

    public Response handleRequest(T request, RequestMeta meta) throws NacosException {
        for (AbstractRequestFilter filter : this.requestFilters.filters) {
            try {
                Response filterResult = filter.filter((Request)request, meta, this.getClass());
                if (filterResult == null || filterResult.isSuccess()) continue;
                return filterResult;
            }
            catch (Throwable throwable) {
                Loggers.REMOTE.error("filter error", throwable);
            }
        }
        return this.handle(request, meta);
    }

    public abstract S handle(T var1, RequestMeta var2) throws NacosException;
}

