/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.storage.kv;

import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.exception.KvStorageException;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alipay.sofa.jraft.util.BytesUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

public class MemoryKvStorage
implements KvStorage {
    private final Map<Key, byte[]> storage = new ConcurrentSkipListMap<Key, byte[]>();

    @Override
    public byte[] get(byte[] key) throws KvStorageException {
        return this.storage.get(new Key(key));
    }

    @Override
    public Map<byte[], byte[]> batchGet(List<byte[]> keys) throws KvStorageException {
        HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>(keys.size());
        for (byte[] key : keys) {
            byte[] val = this.storage.get(new Key(key));
            if (val == null) continue;
            result.put(key, val);
        }
        return result;
    }

    @Override
    public void put(byte[] key, byte[] value) throws KvStorageException {
        this.storage.put(new Key(key), value);
    }

    @Override
    public void batchPut(List<byte[]> keys, List<byte[]> values) throws KvStorageException {
        if (keys.size() != values.size()) {
            throw new KvStorageException(ErrorCode.KVStorageBatchWriteError.getCode(), "key's size must be equal to value's size");
        }
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            this.storage.put(new Key(keys.get(i)), values.get(i));
        }
    }

    @Override
    public void delete(byte[] key) throws KvStorageException {
        this.storage.remove(new Key(key));
    }

    @Override
    public void batchDelete(List<byte[]> keys) throws KvStorageException {
        for (byte[] key : keys) {
            this.storage.remove(new Key(key));
        }
    }

    @Override
    public void doSnapshot(String backupPath) throws KvStorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void snapshotLoad(String path) throws KvStorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> allKeys() throws KvStorageException {
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        for (Key each : this.storage.keySet()) {
            result.add(each.origin);
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.storage.clear();
    }

    private static class Key
    implements Comparable<Key> {
        private final byte[] origin;

        private Key(byte[] origin) {
            this.origin = origin;
        }

        @Override
        public int compareTo(Key o) {
            return BytesUtil.compare((byte[])this.origin, (byte[])o.origin);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.origin, key.origin);
        }

        public int hashCode() {
            return Arrays.hashCode(this.origin);
        }
    }
}

