/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.RootLayoutArea;
import com.itextpdf.layout.renderer.RootRenderer;
import java.util.ArrayList;
import java.util.List;

class RootRendererAreaStateHandler {
    private RootLayoutArea storedPreviousArea;
    private RootLayoutArea storedNextArea;
    private List<Rectangle> storedPreviousFloatRenderAreas = null;
    private List<Rectangle> storedNextFloatRenderAreas = null;

    RootRendererAreaStateHandler() {
    }

    public boolean attemptGoBackToStoredPreviousStateAndStoreNextState(RootRenderer rootRenderer) {
        boolean result = false;
        if (this.storedPreviousArea != null) {
            this.storedNextArea = rootRenderer.currentArea;
            rootRenderer.currentArea = this.storedPreviousArea;
            this.storedNextFloatRenderAreas = new ArrayList<Rectangle>(rootRenderer.floatRendererAreas);
            rootRenderer.floatRendererAreas = this.storedPreviousFloatRenderAreas;
            this.storedPreviousFloatRenderAreas = null;
            this.storedPreviousArea = null;
            result = true;
        }
        return result;
    }

    public boolean attemptGoForwardToStoredNextState(RootRenderer rootRenderer) {
        if (this.storedNextArea != null) {
            rootRenderer.currentArea = this.storedNextArea;
            rootRenderer.floatRendererAreas = this.storedNextFloatRenderAreas;
            this.storedNextArea = null;
            this.storedNextFloatRenderAreas = null;
            return true;
        }
        return false;
    }

    public RootRendererAreaStateHandler storePreviousState(RootRenderer rootRenderer) {
        this.storedPreviousArea = rootRenderer.currentArea;
        this.storedPreviousFloatRenderAreas = new ArrayList<Rectangle>(rootRenderer.floatRendererAreas);
        return this;
    }
}

