/*
 * Decompiled with CFR 0.152.
 */
package com.liando.invoice.domain.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum InvoiceApplicationStatusEnum {
    INVOICE_AUDITING(0, "\u5f00\u7968\u5ba1\u6838\u4e2d"),
    INVOICE_IN_PROCESS(1, "\u5f00\u7968\u4e2d"),
    PARTIALLY_INVOICED(2, "\u90e8\u5206\u5df2\u5f00\u7968"),
    INVOICED(3, "\u5df2\u5f00\u7968"),
    INVOICE_FAILED(4, "\u5f00\u7968\u5931\u8d25");

    private Integer code;
    private String desc;

    private InvoiceApplicationStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static InvoiceApplicationStatusEnum getByCode(Integer code) {
        for (InvoiceApplicationStatusEnum status : InvoiceApplicationStatusEnum.values()) {
            if (!status.getCode().equals(code)) continue;
            return status;
        }
        return null;
    }

    public static Map<Integer, String> getAllStatus() {
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        for (InvoiceApplicationStatusEnum tmp : InvoiceApplicationStatusEnum.values()) {
            resultMap.put(tmp.code, tmp.desc);
        }
        return resultMap;
    }

    public static Map<Integer, String> getUserStatus() {
        HashMap<Integer, String> resultMap = new HashMap<Integer, String>();
        for (InvoiceApplicationStatusEnum tmp : InvoiceApplicationStatusEnum.values()) {
            Integer userCode = tmp.code;
            if (Objects.equals(userCode, INVOICE_FAILED.getCode())) continue;
            resultMap.put(tmp.code, tmp.desc);
        }
        return resultMap;
    }
}

