/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzJr;
import com.aspose.words.internal.zzME;
import com.aspose.words.internal.zzTc;
import com.aspose.words.internal.zzVYb;
import com.aspose.words.internal.zzWVX;
import com.aspose.words.internal.zzWuq;
import com.aspose.words.internal.zzX9t;
import com.aspose.words.internal.zzXYS;
import com.aspose.words.internal.zzY9U;
import com.aspose.words.internal.zzYTv;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.internal.zzZxJ;
import com.aspose.words.zzWPh;
import com.aspose.words.zzWXh;
import com.aspose.words.zzWff;
import com.aspose.words.zzXuR;
import com.aspose.words.zzYSE;
import com.aspose.words.zzYpK;
import com.aspose.words.zzZG4;
import com.aspose.words.zzZIS;
import com.aspose.words.zzgM;
import com.aspose.words.zzlo;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzWuo(zzME zzME2, zzME zzME3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZ0T.zzXou((Object)zzME2, "srcStream");
        zzZ0T.zzXou((Object)zzME3, "dstStream");
        zzZ0T.zzXou((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzXou(zzME2, zzME3, certificateHolder, signOptions);
        zzME3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzWuo(zzME.zzXou(srcStream), (zzME)zzME.zzWg7(dstStream), certHolder, signOptions);
    }

    private static void zzXou(zzME zzME2, zzME zzME3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWg7(digitalSignature);
        }
        if (zzgM.zzXNq(zzME2)) {
            DigitalSignatureUtil.zzWuo(zzME2, zzME3, digitalSignature, true);
            return;
        }
        zzgM zzgM2 = new zzgM();
        zzME zzME4 = zzME2;
        zzgM zzgM3 = zzgM2;
        FileFormatInfo fileFormatInfo = zzgM2.zzXou(zzME4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzTc zzTc2 = new zzTc(zzME2);
                int n = fileFormatInfo.zzZJM() == 1 ? 1 : 2;
                zzlo.zzWuo(zzTc2, digitalSignature, n);
                zzME3.zzWo8(0L);
                zzTc2.zzXgf(zzME3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzWuo(fileFormatInfo.zz4J(), zzME3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzWuo(zzME2, zzME3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzWuo(zzME2, zzME3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZ0T.zzWuo(srcFileName, "srcFileName");
        zzZ0T.zzWuo(dstFileName, "dstFileName");
        try (zzVYb zzVYb2 = zzZ0T.zzXou(srcFileName, 3, 1);){
            try (zzVYb zzVYb3 = zzZ0T.zzXou(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWuo((zzME)zzVYb2, (zzME)zzVYb3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzX9t zzX9t2 = zzME.zzWg7(dstStream);
        zzME zzME2 = zzME.zzXou(srcStream);
        DigitalSignatureUtil.zzWuo(zzME2, (zzME)zzX9t2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzVYb zzVYb2 = zzZ0T.zzXou(srcFileName, 3, 1);){
            try (zzVYb zzVYb3 = zzZ0T.zzXou(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYnz(zzVYb2, zzVYb3);
            }
            return;
        }
    }

    private static void zzYnz(zzME zzME2, zzME zzME3) throws Exception {
        zzgM zzgM2 = new zzgM();
        zzME zzME4 = zzME2;
        zzgM zzgM3 = zzgM2;
        FileFormatInfo fileFormatInfo = zzgM2.zzXou(zzME4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzTc zzTc2 = new zzTc(zzME2);
                zzTc2.zzYb8().zzZrO("_xmlsignatures");
                zzTc2.zzYb8().zzZrO("_signatures");
                zzME3.zzW1j(0L);
                zzTc2.zzXgf(zzME3);
                zzME zzME5 = zzME3;
                zzME5.zzWo8(zzME5.zzXNi());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzJr zzJr2 = new zzJr(zzME2);
                zzXYS zzXYS2 = zzJr2.zzWuo(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXYS2 != null) {
                    for (zzYTv zzYTv2 : zzXYS2.zzYVJ()) {
                        String string = zzXYS2.zzWuo(zzYTv2);
                        zzJr2.zzWA5().remove(string);
                    }
                    zzJr2.zzWA5().remove(zzXYS2.getName());
                    zzYTv zzYTv3 = zzJr2.zzYVJ().zzW5S("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzJr2.zzYVJ().remove(zzYTv3.getId());
                    zzJr2.zzXLe();
                }
                zzME3.zzW1j(0L);
                zzJr2.zzXgf(zzME3);
                zzME zzME6 = zzME3;
                zzME6.zzWo8(zzME6.zzXNi());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYnz(zzME.zzXou(srcStream), zzME.zzWg7(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzVYb zzVYb2 = zzZ0T.zzXou(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXsE(zzVYb2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXsE(zzME zzME2) throws Exception {
        if (zzgM.zzXNq(zzME2)) {
            return DigitalSignatureUtil.zzXJE(zzME2);
        }
        zzgM zzgM2 = new zzgM();
        zzME zzME3 = zzME2;
        zzgM zzgM3 = zzgM2;
        FileFormatInfo fileFormatInfo = zzgM2.zzXou(zzME3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzME2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXsE(zzME.zzXou(stream));
    }

    static zzY9U zzWuo(zzTc zzTc2, String string) throws Exception {
        zzXuR zzXuR2 = new zzXuR(zzTc2);
        if (zzXuR2.zzew()) {
            zzY9U zzY9U2 = zzXuR2.zzqe(string);
            return zzY9U2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzWhO(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzWuq.zzXou("Unexpected digest algorithm: {0}.", n));
    }

    static String zzVSO(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzWhO(n);
    }

    private static void zzWuo(zzME zzME2, zzME zzME3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzJr zzJr2 = new zzJr(zzME2);
        zzWXh zzWXh2 = bl ? new zzWff(zzJr2) : new zzZIS(zzJr2);
        zzWXh2.zzXou(digitalSignature);
        zzME3.zzWo8(0L);
        zzJr2.zzXgf(zzME3);
    }

    private static void zzWuo(zzME zzME2, zzME zzME3, DigitalSignature digitalSignature) throws Exception {
        zzYSE zzYSE2 = new zzYSE(zzME2);
        zzWPh zzWPh2 = new zzWPh(zzYSE2);
        zzWPh2.zzXou(digitalSignature);
        zzME3.zzWo8(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzME zzME4 = zzME3;
        zzYSE zzYSE3 = zzYSE2;
        zzYSE3.zzWuo(zzME4, string, null);
    }

    private static void zzWuo(zzTc zzTc2, zzME zzME2, DigitalSignature digitalSignature, String string) throws Exception {
        zzY9U zzY9U2 = DigitalSignatureUtil.zzWuo(zzTc2, string);
        zzY9U zzY9U3 = new zzY9U();
        DigitalSignatureUtil.zzWuo((zzME)zzY9U2, (zzME)zzY9U3, digitalSignature, false);
        zzTc zzTc3 = zzXuR.zzWg7(zzY9U3, string);
        zzTc3.zzXgf(zzME2);
    }

    private static DigitalSignatureCollection zzXJE(zzME zzME2) throws Exception {
        zzME2.zzW1j(0L);
        zzJr zzJr2 = new zzJr(zzME2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXYS zzXYS2 = zzJr2.zzWuo(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXYS2 != null) {
            for (zzYTv zzYTv2 : zzXYS2.zzYVJ()) {
                String string = zzXYS2.zzWuo(zzYTv2);
                zzXYS zzXYS3 = zzJr2.zzXBL(string);
                zzXYS zzXYS4 = zzJr2.zzWuo(zzXYS3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWVX zzWVX2 = zzZxJ.zzwo(zzXYS4.zzWY8().zzVTb());
                zzYpK.zzWuo(zzXYS3.zzZMH(), zzWVX2, new zzZG4(zzJr2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

