/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzAM;
import com.aspose.words.internal.zzLH;
import com.aspose.words.internal.zzME;
import com.aspose.words.internal.zzW4d;
import com.aspose.words.internal.zzWQC;
import com.aspose.words.internal.zzWuq;
import com.aspose.words.internal.zzX3T;
import com.aspose.words.internal.zzXEn;
import com.aspose.words.internal.zzXHe;
import com.aspose.words.internal.zzY2k;
import com.aspose.words.internal.zzY4C;
import com.aspose.words.internal.zzY7O;
import com.aspose.words.internal.zzY9U;
import com.aspose.words.internal.zzYh4;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.internal.zzZrt;
import com.aspose.words.internal.zzuV;
import com.aspose.words.internal.zzvw;
import com.aspose.words.zz9g;
import com.aspose.words.zzDi;
import com.aspose.words.zzHC;
import com.aspose.words.zzLk;
import com.aspose.words.zzW4B;
import com.aspose.words.zzWA0;
import com.aspose.words.zzWBs;
import com.aspose.words.zzWBz;
import com.aspose.words.zzWJS;
import com.aspose.words.zzWXq;
import com.aspose.words.zzWYp;
import com.aspose.words.zzWwN;
import com.aspose.words.zzWwe;
import com.aspose.words.zzX4Y;
import com.aspose.words.zzX6C;
import com.aspose.words.zzX94;
import com.aspose.words.zzX9W;
import com.aspose.words.zzXGq;
import com.aspose.words.zzXOf;
import com.aspose.words.zzXOx;
import com.aspose.words.zzXYA;
import com.aspose.words.zzXcB;
import com.aspose.words.zzXdU;
import com.aspose.words.zzXhQ;
import com.aspose.words.zzXla;
import com.aspose.words.zzY2F;
import com.aspose.words.zzYFS;
import com.aspose.words.zzYNl;
import com.aspose.words.zzYgf;
import com.aspose.words.zzYsH;
import com.aspose.words.zzYzM;
import com.aspose.words.zzZB3;
import com.aspose.words.zzZUH;
import com.aspose.words.zzZWm;
import com.aspose.words.zzZaR;
import com.aspose.words.zzZbx;
import com.aspose.words.zzZmP;
import com.aspose.words.zzZz5;
import com.aspose.words.zzd9;
import com.aspose.words.zzp;
import com.aspose.words.zzuM;
import com.aspose.words.zzxQ;
import com.aspose.words.zzzg;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzX6C,
zzp,
zzzg {
    private Document zzZU0;
    private Node zzXEs;
    private Node zzCg;
    private zzYNl zzbs;
    private Font zzVZC;
    private zzAM<zzYNl> zzZPy;
    private zzAM<zzWBs> zzXae;
    private zzAM<zzWuo> zzXy3;
    private zzZaR zzYl2 = zzZaR.zzXuy();
    private zzWJS zzXkC = new zzWJS();
    private RowFormat zzVVT;
    private CellFormat zzWaM;
    private zzAM<zzWBz> zzYZI;
    private int zzWoZ = 0;
    private int zzYPY = -1;
    private int zzXen;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzX8D(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzX8D(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzX8D(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWuo(documentBuilder.getCurrentSection(), zzWwN.zzVRB(headerFooterType), 0, 0);
    }

    private void zzX8D(int n, int n2, int n3, int n4) {
        this.zzZU0.ensureMinimum();
        Section section = (Section)this.zzZU0.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzWuo(section, 1, n3, n4);
    }

    private void zzWuo(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzWwN.zzYlT(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZU0, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZU0));
            }
        }
        this.zzWuo(story, n2, n3);
    }

    private void zzWuo(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWuo(paragraph2, n3);
    }

    final void zzWg7(Paragraph paragraph, int n) {
        this.zzWuo(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzah().zzWMQ() ? zzW4B.zzZQl(this.zzZU0, fieldName) : zzW4B.zzXNO(this.zzah(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzWuo(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzWuo(field, isAfter, false);
    }

    private boolean zzWuo(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZWm zzZWm2 = field.getFormat().zzj1();
        Inline inline = zzZWm2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzWuo(inline.zzZVp(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzXOx.zzWuo(this.zzZU0, bookmarkName) : zzXOx.zzXou(this.zzZU0, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzY9Y() == 6) {
            this.zzXou((Paragraph)node.zzZFr(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYFS.zzJQ(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXou(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWuo(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzYA8(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzWuo(cell, characterIndex);
    }

    private void zzXou(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzY9Y() == 6) {
            this.zzZ7y(node);
        } else {
            Node node2 = node;
            if (zzYFS.zzVRC(node2.getNodeType())) {
                Paragraph paragraph = zzYFS.zzJQ(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzZ7y(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzY9Y() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzZ7y(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXen = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzY7r();
            return;
        }
        if (!this.zzWcg()) {
            this.zzY7r();
        }
    }

    private boolean zzWcg() {
        Node node = this.zzah();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzah(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzWuo(inline.zzZVp(), true);
            return true;
        }
        return false;
    }

    private void zzY7r() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzWuo(documentBuilder.getCurrentParagraph().zztM(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYA8(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzsL() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzah().zzZNW(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzfO();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzWuo(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zz0G(text, false);
    }

    public void writeln(String text) {
        this.zz0G(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zz6G();
        Paragraph paragraph = this.getCurrentParagraph();
        zzd9 zzd92 = new zzd9(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZU0, this.zzC2(), this.zzVZY());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzXou(this.zzah(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzd92.dispose();
        }
        if (this.getDocument().zzZBf()) {
            zzXhQ.zzWg7(paragraph, this.getDocument().zzYBN());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zz2z() {
        zzYNl zzYNl2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zz6G();
        Node node = this.zzah();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzYxq(false);
        } else {
            run2 = run = (Run)node.zzWlk(21);
        }
        if (run2 == null && zzZ0T.zzXPe(node, paragraph.zzZuE())) {
            run = paragraph.zzZuE();
        }
        if (run != null) {
            cloneable = run.zzZVp();
            zzYNl2 = (zzYNl)((zzYgf)cloneable).zzWqN();
        } else {
            cloneable = paragraph.zztM();
            zzYNl2 = (zzYNl)((zzYgf)cloneable).zzWqN();
        }
        zzYNl zzYNl3 = zzYNl2;
        Paragraph paragraph2 = new Paragraph(this.zzZU0, this.zzC2(), zzYNl3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzd9 zzd92 = new zzd9(this.zzZU0);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzXou(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzd92.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzDi.zzZQl(this);
    }

    public void insertBreak(int breakType) {
        this.zzJQ(breakType, true);
    }

    final void zzJQ(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzYkv(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZoM(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzZ7T())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzYkv(bl)) {
                        this.zzZoM(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzYkv(bl)) {
                        this.zzaI(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzYkv(bl)) {
                        this.zzaI(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzYkv(bl)) {
                        this.zzaI(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzYkv(bl)) {
                        this.zzaI(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzYkv(bl)) {
                        this.zzaI(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZoM(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzY7O.zzY0d(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzWuq.zzXou("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zz6G();
        return zzYFS.zzWuo(fieldType, updateField, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zz6G();
        return zzYFS.zzWuo(fieldCode, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zz6G();
        return zzYFS.zzWuo(fieldCode, fieldValue, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ0T.zzXou((Object)displayText, "displayText");
        zzZ0T.zzXou((Object)urlOrBookmark, "hrefOrBookmark");
        zzZB3 zzZB32 = this.zzXou(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZB32.zzXou(documentBuilder.zzXhS(88, true));
        return zzYFS.zzWuo(zzZB32.getStart(), zzZB32.getSeparator(), zzZB32.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzWeL(70);
        if (zzY7O.zzY0d(name)) {
            this.startBookmark(name);
        }
        this.zzYMF(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZ43(70);
        String string = zzY7O.zzY0d(fieldValue) ? fieldValue : FormField.zzZBR;
        Run run = new Run(this.zzZU0, string, this.zzVZY());
        this.insertNode(run);
        Node node = this.zzXhS(70, true);
        if (zzY7O.zzY0d(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzX2N(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXou((Paragraph)node.zzZFr(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzWeL(71);
        if (zzY7O.zzY0d(name)) {
            this.startBookmark(name);
        }
        this.zzYMF(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXhS(71, false);
        if (zzY7O.zzY0d(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX2N(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzWeL(83);
        if (zzY7O.zzY0d(name)) {
            this.startBookmark(name);
        }
        this.zzYMF(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXhS(83, false);
        if (zzY7O.zzY0d(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX2N(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZU0, footnoteType, !zzY7O.zzY0d(referenceMark), referenceMark, this.zzVZY());
        Style style = this.getDocument().getStyles().zzVVm(zzYFS.zzeH(footnoteType));
        footnote.zzZVp().set(50, style.zzWIT());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZU0);
        Style style2 = this.getDocument().getStyles().zzVVm(zzYFS.zzYTv(footnoteType));
        paragraph.zzK4().set(1000, style2.zzWIT());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZU0, '\u0002', new zzYNl()) : new Run(this.zzZU0, footnote.getReferenceMark(), new zzYNl());
        inline.zzZVp().set(50, style.zzWIT());
        paragraph.appendChild(inline);
        if (zzY7O.zzY0d(footnoteText)) {
            Node node = this.zzah();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZ7y(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zz1Z(zzME zzME2) throws Exception {
        return this.zzWuo(zzME2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zz1Z(zzME.zzXou(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzWuo(zzME zzME2, double d, double d2) throws Exception {
        return this.zzWuo(zzME2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzWuo(zzME.zzXou(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzY9U zzY9U2 = new zzY9U();){
            zzY4C.zzWuo(image, zzY9U2);
            Shape shape = this.zzWuo(zzY9U2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ0T.zzWuo(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzY2k.zzZ72(fileName);
        try {
            Shape shape = this.zzWuo((zzME)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzME)object).close();
            }
        }
    }

    private Shape zzWuo(zzME zzME2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzME2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ0T.zzZQl(zzME2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWuo(zzME.zzXou(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzWuo(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzj5(byte[] byArray) throws Exception {
        Shape shape = this.zzWuo(byArray, 2, 0.0, 2, 0.0, -1.0, -1.0, 0, true);
        return shape;
    }

    private Shape zzWuo(byte[] byArray, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object;
        Object object2;
        Shape shape;
        Object object3;
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzuV.zz8g(byArray)) {
            object3 = new zzY4C(byArray);
            bl2 = true;
            ((zzLH)object3).dispose();
        }
        object3 = null;
        boolean bl3 = this.zzZU0.getCompatibilityOptions().getMswVersion() > 12 || this.zzZU0.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZU0, 0);
            object2 = new zzXOf();
            ((zzWXq)object2).zzWuo(zzXdU.zzYPq("rect"));
            ((zzXOf)object2).zzWuo(new zzZUH());
            ((zzXOf)object2).zzYLP().zzYiY().zzYnz(this.zzZU0);
            zzWwe zzWwe2 = new zzWwe();
            object = zzWwe2;
            zzWwe2.zzXou(new zzxQ(this.zzZU0.zzXpp(), ""));
            ((zzXcB)object).zzWuo(new zzWA0());
            ((zzY2F)object2).zzWuo((zzXcB)object);
            shape.zzWP8(75);
            shape.zzXM7((zzY2F)object2);
        } else {
            shape = new Shape((DocumentBase)this.zzZU0, 75);
        }
        if (zzuV.zzZ0T(byArray)) {
            int n4 = bl3 ? 6 : 2;
            object = shape.getImageData().zzWuo(byArray, new zzWYp(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzuV.zzpc((byte[])object));
                this.zzWuo((zzXOf)shape.zzWzN(), byArray, imageSize);
            }
            byArray = object;
        }
        if (bl3 && bl2) {
            ((zzXOf)shape.zzWzN()).zzYLP().zzYiY().zzYBQ(byArray);
            object2 = zzuV.zzYiJ(byArray);
            object3 = new zzWYp(((zzZrt)object2).getWidthPoints(), ((zzZrt)object2).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes(byArray);
        }
        shape.zzWuo(this.zzVZY());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzuV.zzXsE(byArray)) {
            d5 = DocumentBuilder.zzWuo(shape, byArray);
        }
        shape.zzWuo(d3, d4, (zzWYp)object3, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzWuo(Shape shape, byte[] byArray) throws Exception {
        int n = zzuV.zzEu(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYFS.zz2w(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYFS.zzZgq(n);
        return d;
    }

    private void zzWuo(zzXOf zzXOf2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXOf2.zzYLP().zzYiY().getExtensions();
        try (zzY9U zzY9U2 = new zzY9U(byArray);){
            object = zzYFS.zzWuo(zzY9U2, this.zzZU0);
            ((zzZbx)object).zzW6E(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzZbx)object).zzZkH();
            byArray2 = ((zzZbx)object).zzW7v(true);
        }
        zzXOf2.zzYLP().zzYiY().setExtensions(new zzXHe<zzYsH>());
        object = zzYsH.zzWuo(byArray2, this.zzZU0);
        zzXOf2.zzYLP().zzYiY().getExtensions().zzY0J(((zzYsH)object).getUri(), (zzYsH)object);
    }

    private Shape zzWuo(zzME zzME2, String string, boolean bl, zzME zzME3) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzAM(string);
        Shape shape = this.zzWuo(zzME3, bl, zzX4Y2, null);
        zz9g zz9g2 = zzHC.zzWuo(zzME2, string, bl);
        return DocumentBuilder.zzWuo(null, false, shape, zzX4Y2.zzWuR, zz9g2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWuo(zzME.zzXou(stream), progId, asIcon, zzME.zzXou(presentation));
    }

    private Shape zzWuo(String string, boolean bl, boolean bl2, zzME zzME2) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzWKc(zzWQC.zzZ3P(string));
        return this.zzWuo(string, bl, bl2, zzME2, zzX4Y2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWuo(fileName, isLinked, asIcon, zzME.zzXou(presentation));
    }

    private Shape zzWuo(String string, String string2, boolean bl, boolean bl2, zzME zzME2) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzAM(string2);
        return this.zzWuo(string, bl, bl2, zzME2, zzX4Y2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzWuo(fileName, progId, isLinked, asIcon, zzME.zzXou(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzWKc(zzWQC.zzZ3P(fileName));
        return this.zzWuo(fileName, isLinked, iconFile, iconCaption, zzX4Y2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzAM(progId);
        return this.zzWuo(fileName, isLinked, iconFile, iconCaption, zzX4Y2);
    }

    private Shape zzWuo(zzME zzME2, String string, String string2, String string3) throws Exception {
        zzX4Y zzX4Y2 = zzX4Y.zzAM(string);
        Shape shape = this.zzWuo(string2, string3, zzX4Y2);
        zz9g zz9g2 = zzHC.zzWuo(zzME2, string, true);
        return DocumentBuilder.zzWuo(null, false, shape, zzX4Y2.zzWuR, zz9g2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWuo(zzME.zzXou(stream), progId, iconFile, iconCaption);
    }

    final Shape zzWuo(zzZz5 zzZz52, zzME zzME2) throws Exception {
        Shape shape = this.zzWO5(zzME2);
        shape.zzWP8(201);
        shape.getOleFormat().zzXou(zzZz52.zzW1M());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zz6G();
        if (this.zzhr()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZ12(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZmP zzZmP2 = zzYFS.zzWuo(html, options, this);
        zzZmP2.zzXM6();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zz6G();
        return zzYFS.zzWuo(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zz6G();
        return zzYFS.zzWuo(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzX94 zzX942 = new zzX94();
        return zzX942.zzWuo(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXla(this).zzWuo(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXla(this).zzWuo(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZU0, 75);
        shape.zzWuo(this.zzVZY());
        shape.zzwg(true);
        shape.getSignatureLine().zzWuo(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYAe(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZHn(this.zzZU0);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzhr() {
        boolean bl = false;
        if (this.zzah().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzah().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZ12(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zz6G();
        if (this.zzsL() == null) {
            this.startTable();
        }
        if (this.zzsL().zzZSF() == 1) {
            this.zzsL().zzZUF();
        }
        if (this.zzsL().zzZSF() == 3) {
            this.zzsL().zzX5S();
        }
        return this.zzsL().zzJd();
    }

    public Table startTable() {
        this.zzYZI.push(new zzWBz(this));
        return this.zzsL().startTable();
    }

    public Table endTable() {
        if (this.zzsL() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzsL().endTable();
        this.zzYZI.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzsL() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzsL().endRow();
        if (this.zzVZC != null && this.zzVZC.getHidden()) {
            row.zzDn().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZU0, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZU0, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzx0();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZU0, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzWSh();
        bookmarkStart.zzZ2m(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzx0();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzWSh();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZU0, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zz42(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZU0);
        this.zzYPY = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzYPY == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZU0, this.zzYPY);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZU0, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZ0T.zzXou((Object)importFormatOptions, "ImportFormatOptions");
        this.zz6G();
        return zzYzM.zzWuo(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZU0;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZU0) {
            return;
        }
        this.zzZU0 = value;
        this.zzZ7y(null);
        this.zzbs = new zzYNl();
        this.zzZPy = null;
        this.zzXae = null;
        this.zzVZC = null;
        this.zzYZI = new zzAM();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzVZC == null) {
            DocumentBuilder documentBuilder = this;
            this.zzVZC = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzVZC;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzVVT == null) {
            this.zzVVT = new RowFormat(this);
        }
        return this.zzVVT;
    }

    public CellFormat getCellFormat() {
        if (this.zzWaM == null) {
            this.zzWaM = new CellFormat(this);
        }
        return this.zzWaM;
    }

    final void zzXSX(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzYNl zzYNl2 = this.getCurrentParagraph().zztM();
        this.zzYLU().push(new zzWuo(this.zzVZY(), (zzYNl)zzYNl2.zzWqN()));
    }

    public void popFont() {
        zzAM<zzWuo> zzAM2 = this.zzYLU();
        if (zzAM2.size() > 0) {
            zzWuo zzWuo2 = (zzWuo)this.zzYLU().pop();
            this.zzWuo(zzWuo2.zzZVp(), false);
            this.getCurrentParagraph().zzWsB(zzWuo2.zzP2());
        }
    }

    final void zzZqI() {
        this.zzXGJ().push(this.zzVZY());
    }

    final void zzWJs() {
        zzAM<zzYNl> zzAM2 = this.zzXGJ();
        if (zzAM2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzWuo((zzYNl)documentBuilder.zzXGJ().pop(), false);
        }
    }

    final void zzX3A() {
        this.zzYVp().push(this.zzC2());
    }

    final void zzWw4() {
        zzAM<zzWBs> zzAM2 = this.zzYVp();
        if (zzAM2.size() > 0) {
            this.getCurrentParagraph().zzWuo((zzWBs)this.zzYVp().pop());
        }
    }

    final zzZB3 zzXou(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzWeL(88);
        zzLk zzLk2 = new zzLk();
        zzLk2.setTarget(string2);
        zzLk2.setScreenTip(string3);
        if (bl) {
            zzLk2.setSubAddress(string);
        } else {
            zzLk2.setAddress(zzXEn.zzMG(string));
            zzLk2.setSubAddress(zzXEn.zzZgi(string));
        }
        this.zzYMF(zzLk2.toString());
        FieldSeparator fieldSeparator = this.zzZ43(88);
        return new zzZB3(fieldStart, fieldSeparator, null);
    }

    final zzZB3 zzX8D(String string, String string2, String string3) {
        boolean bl = zzXEn.zzXrD(string);
        String string4 = bl ? zzXEn.zzZgi(string) : string;
        return this.zzXou(string4, bl, string2, string3);
    }

    final FieldEnd zzZNa() {
        return this.zzXhS(88, true);
    }

    final zzYNl zzVZY() {
        zzYNl zzYNl2 = this.zzbs;
        return (zzYNl)zzYNl2.zzWqN();
    }

    final zzWBs zzC2() {
        zzWBs zzWBs2 = this.getCurrentParagraph().zzK4();
        return (zzWBs)zzWBs2.zzWqN();
    }

    final zzZaR zzXVO() {
        zzZaR zzZaR2 = this.zzDn();
        return (zzZaR)zzZaR2.zzWqN();
    }

    final zzWJS zzZMd() {
        zzWJS zzWJS2 = this.zzr7();
        return (zzWJS)zzWJS2.zzWqN();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzah(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzah().getNodeType() == 8;
    }

    private void zz0G(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzWwN.zzVUv(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzbz(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWoZ) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZoM(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzbz(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zz6G();
        if (this.zzsL() != null && this.zzsL().zzZSF() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzah().getParentNode().insertBefore(node, this.zzah());
    }

    final void zzWoJ(int n) {
        this.zzYkv(true);
        this.zzaI(n);
    }

    private void zzaI(int n) {
        this.insertParagraph();
        zzd9 zzd92 = new zzd9(this.getDocument());
        try {
            zzXYA zzXYA2 = this.getCurrentSection().zzZZj();
            zzXYA zzXYA3 = (zzXYA)zzXYA2.zzWqN();
            Section section = new Section(this.zzZU0, zzXYA3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZU0));
            this.zzZU0.insertAfter(section, this.getCurrentSection());
            section.getBody().zzXou(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzd92.dispose();
        }
    }

    final FieldStart zzWeL(int n) {
        this.zz6G();
        return zzYFS.zzWuo(n, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzYMF(String string) {
        return zzYFS.zzXou(string, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzXhS(int n, boolean bl) {
        return zzYFS.zzXou(n, bl, this.zzVZY(), this.zzah(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzZ43(int n) {
        return zzYFS.zzXou(n, this.zzVZY(), this.zzah(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzX2N(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZU0, new zzuM(), this.zzVZY());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzYkv(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzsL() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYA8(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzbz(String string) {
        if (this.zzYD8(string)) {
            zzYh4 zzYh42 = new zzYh4(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzvw zzvw2 : zzYh42.zzZ44(this.getParagraphFormat().getBidi())) {
                zzX9W zzX9W2 = zzX9W.zzW2f(zzvw2.zzY6N());
                zzYNl zzYNl2 = this.zzVZY();
                zzYNl2.zzX8D(265, zzX9W2);
                if (zzvw2.zzSD()) {
                    zzYNl2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZU0, zzvw2.getText(), zzYNl2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZoM(string);
    }

    private boolean zzYD8(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzW4d.zzZKg(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzWuo(zzYNl zzYNl2, boolean bl) {
        zzYNl zzYNl3;
        if (bl) {
            zzYNl zzYNl4 = zzYNl2;
            zzYNl3 = (zzYNl)zzYNl4.zzWqN();
        } else {
            zzYNl3 = zzYNl2;
        }
        this.zzbs = zzYNl3;
    }

    final void zzW2L() {
        this.zzbs.clear();
    }

    final void zzvY() {
        if (this.zzx0() != null) {
            zzWJS zzWJS2;
            zzWJS zzWJS3 = zzWJS2 = this.zzx0().zzr7();
            this.zzXkC = (zzWJS)zzWJS3.zzWqN();
            zzWJS2.zzXou(this.zzXkC);
        }
    }

    private Shape zzWuo(String string, boolean bl, boolean bl2, zzME zzME2, zzX4Y zzX4Y2) throws Exception {
        if (zzX4Y2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzWuo(zzME2, bl2, zzX4Y2, string);
        zz9g zz9g2 = zzHC.zzWuo(string, bl, bl2, zzX4Y2);
        return DocumentBuilder.zzWuo(string, bl, shape, zzX4Y2.zzWuR, zz9g2);
    }

    private Shape zzWuo(String string, boolean bl, String string2, String string3, zzX4Y zzX4Y2) throws Exception {
        if (zzX4Y2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzWQC.zzWBN(string);
        }
        Shape shape = string2 != null ? this.zzRM(string2, string3) : this.zzWuo(null, string3, zzX4Y2);
        zz9g zz9g2 = zzHC.zzWuo(string, bl, true, zzX4Y2);
        return DocumentBuilder.zzWuo(string, bl, shape, zzX4Y2.zzWuR, zz9g2);
    }

    private static Shape zzWuo(String string, boolean bl, Shape shape, String string2, zz9g zz9g2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzWP8(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzXou(zz9g2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzWuo(zzME zzME2, boolean bl, zzX4Y zzX4Y2, String string) throws Exception {
        if (zzX4Y2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzME2 != null) {
            return this.zzWO5(zzME2);
        }
        if (!bl) {
            return this.zzYXF(zzHC.zzWBW().get("normal"));
        }
        String string2 = string != null ? zzWQC.zzWBN(string) : zzHC.zzZop(zzX4Y2.zzZ2);
        return this.zzWuo(zzX4Y2, string2);
    }

    private Shape zzWuo(String string, String string2, zzX4Y zzX4Y2) throws Exception {
        if (zzX4Y2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzHC.zzZop(zzX4Y2.zzZ2);
        }
        if (string != null) {
            return this.zzRM(string, string2);
        }
        return this.zzWuo(zzX4Y2, string2);
    }

    private Shape zzWuo(zzX4Y zzX4Y2, String string) throws Exception {
        if (zzX4Y2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzHC.zzYK8(zzX4Y2.zzZ2);
        zzX3T zzX3T2 = new zzX3T(byArray, null, string, this.getDocument().zzKo());
        return this.zzYXF(zzX3T2.zzZ9X());
    }

    private Shape zzRM(String string, String string2) throws Exception {
        zzX3T zzX3T2 = new zzX3T(string, string2, this.getDocument().zzKo());
        return this.zzYXF(zzX3T2.zzZ9X());
    }

    private Shape zzWO5(zzME zzME2) throws Exception {
        byte[] byArray = zzZ0T.zzZQl(zzME2);
        return this.zzYXF(byArray);
    }

    private Shape zzYXF(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZU0, 1);
        shape.zzWP8(75);
        shape.zzWuo(this.zzVZY());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYAe(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzWuo(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzXou(compositeNode, n);
            return;
        }
        this.zzWg7(compositeNode, n);
    }

    private void zzXou(CompositeNode compositeNode, int n) {
        zzXGq zzXGq2 = zzXGq.zzqC(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzXGq2.zzWuo(null, true, true, true, false, true);
            node = zzXGq2.getNode();
            if (zzXGq2.zzZr7() && (!node.isComposite() || node.zzY9Y() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzWko().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzXou(null, node);
            this.zzXen = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzWg7(CompositeNode compositeNode, int n) {
        zzXGq zzXGq2 = zzXGq.zzpc(compositeNode);
        while (zzXGq2.getNode() != compositeNode || !zzXGq2.zzZr7()) {
            int n2;
            Node node = zzXGq2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzWko().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXou(null, node);
                this.zzXen = n;
                return;
            }
            while (zzXGq2.zzWuo(null, false, true, true, false, true) && zzXGq2.zzZr7() && zzXGq2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zz6G() {
        int n = this.zzXen;
        if (n == 0) {
            return;
        }
        this.zzXen = 0;
        Run run = zzZ0T.zzWuo((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzWWe(n);
        }
    }

    private Run zzZoM(String string) {
        Run run = new Run(this.zzZU0, string, this.zzVZY());
        this.insertNode(run);
        return run;
    }

    final boolean zzYaL() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzXQv() {
        return this.zzWoZ;
    }

    final void zzW21(int n) {
        this.zzWoZ = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzah();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzah();
        }
        return (Paragraph)this.zzah().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWBz zzsL() {
        zzAM<zzWBz> zzAM2 = this.zzYZI;
        if (zzAM2.size() > 0) {
            return (zzWBz)this.zzYZI.peek();
        }
        return null;
    }

    private Cell zzx0() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZJU();
    }

    private zzAM<zzYNl> zzXGJ() {
        if (this.zzZPy == null) {
            this.zzZPy = new zzAM();
        }
        return this.zzZPy;
    }

    private zzAM<zzWBs> zzYVp() {
        if (this.zzXae == null) {
            this.zzXae = new zzAM();
        }
        return this.zzXae;
    }

    private zzAM<zzWuo> zzYLU() {
        if (this.zzXy3 == null) {
            this.zzXy3 = new zzAM();
        }
        return this.zzXy3;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzbs.zzZK2(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzjw(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzjw(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzbs.zzX8D(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYP4()) {
            this.getCurrentParagraph().zztM().zzX8D(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzbs.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzbs.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYP4()) {
            this.getCurrentParagraph().zztM().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzDn().zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzDn().zzwg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzDn().zzZd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzDn().zzX8D(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzDn().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzDn().clear();
        zzZaR.zzXuy().zzXou(this.zzDn());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzr7().zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzr7().zzwg(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzr7().zzZd(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ0T.zzWuo(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzx0() != null ? this.zzx0().getCellFormat() : this.getCellFormat();
            border.zzWuo(cellFormat);
        }
        this.zzr7().zzX8D(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzr7().clear();
    }

    private Node zzah() {
        Node node = this.zzXEs != null && this.zzXEs.getParentNode() == null ? this.zzCg : this.zzXEs;
        if (node != null && node.zzY9Y() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZ7y(Node node) {
        this.zzXEs = node;
        if (this.zzXEs != null) {
            this.zzCg = this.zzXEs.getParentNode();
        }
    }

    private zzZaR zzDn() {
        if (this.zzsL() != null && this.zzsL().zzZSF() == 1) {
            return this.zzYl2;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzDn();
        }
        return this.zzYl2;
    }

    private zzWJS zzr7() {
        if (this.zzsL() != null && this.zzsL().zzZSF() != 3) {
            return this.zzXkC;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZJU().zzr7();
        }
        return this.zzXkC;
    }

    static final class zzWuo {
        private zzYNl zzbs;
        private zzYNl zzX2x;

        public zzWuo(zzYNl zzYNl2, zzYNl zzYNl3) {
            this.zzbs = zzYNl2;
            this.zzX2x = zzYNl3;
        }

        public final zzYNl zzZVp() {
            return this.zzbs;
        }

        public final zzYNl zzP2() {
            return this.zzX2x;
        }
    }
}

