/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzEu;
import com.aspose.words.internal.zzME;
import com.aspose.words.internal.zzVYb;
import com.aspose.words.internal.zzY7O;
import com.aspose.words.internal.zzYk5;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzgM;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzX0N = new HashMap();
    private static HashMap<Integer, Integer> zzZEK = new HashMap();
    private static HashMap<Integer, Integer> zzZ14 = new HashMap();
    private static HashMap<Integer, Integer> zzWF0 = new HashMap();
    private static HashMap<Integer, Integer> zzgQ = new HashMap();
    private static HashMap<Integer, Integer> zzZnJ = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ0T.zzWuo(fileName, "fileName");
        try (zzVYb zzVYb2 = zzZ0T.zzYzK(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzRM(zzVYb2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzRM(zzEu.zzWuo(stream));
    }

    static FileFormatInfo zzRM(zzME zzME2) throws Exception {
        if (zzME2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzgM zzgM2 = new zzgM();
            zzME zzME3 = zzME2;
            zzgM zzgM3 = zzgM2;
            return zzgM2.zzXou(zzME3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWg7(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZuo(zzYk5.zzYjD(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYIO(zzYk5.zzYjD(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzY7O.zzY0d(string = zzYk5.zzXQS(FileFormatUtil.zzWV6(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZuo(FileFormatUtil.zzZHR(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYIO(FileFormatUtil.zzWV6(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYk5.zzXQS(FileFormatUtil.zzZHR(saveFormat));
        if (zzY7O.zzY0d(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzYIO(zzYk5.zzZku(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYk5.zzXQS(FileFormatUtil.zzZk5(imageType));
    }

    static Exception zzWg7(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzY8c(int n) {
        return zzYk5.toString(FileFormatUtil.zzZHR(n));
    }

    static int zzYIO(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ0T.zzWuo(zzgQ, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZTc(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZ0T.zzWuo(zzZnJ, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzW7K(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWV6(int n) {
        return zzZ0T.zzWuo(zzX0N, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZHR(int n) {
        return zzZ0T.zzWuo(zzZEK, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZk5(int n) {
        return zzZ0T.zzWuo(zzZ14, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZuo(int n) {
        return zzZ0T.zzWuo(zzWF0, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZDH(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZ0T.zzXou(zzgQ, Integer.valueOf(n), Integer.valueOf(n2));
            zzZ0T.zzXou(zzZEK, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWF0.containsKey(n)) {
                zzZ0T.zzXou(zzWF0, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZ0T.zzXou(zzX0N, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZ0T.zzXou(zzZnJ, Integer.valueOf(n), Integer.valueOf(n4));
            zzZ0T.zzXou(zzZ14, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZDH(11, 10, 10, 1);
        FileFormatUtil.zzZDH(11, 0, 0, 1);
        FileFormatUtil.zzZDH(12, 11, 11, 1);
        FileFormatUtil.zzZDH(13, 20, 20, 1);
        FileFormatUtil.zzZDH(13, 0, 254, 1);
        FileFormatUtil.zzZDH(14, 21, 21, 1);
        FileFormatUtil.zzZDH(15, 22, 22, 1);
        FileFormatUtil.zzZDH(16, 23, 23, 1);
        FileFormatUtil.zzZDH(18, 24, 24, 1);
        FileFormatUtil.zzZDH(19, 25, 25, 1);
        FileFormatUtil.zzZDH(20, 26, 26, 1);
        FileFormatUtil.zzZDH(21, 27, 27, 1);
        FileFormatUtil.zzZDH(24, 30, 30, 1);
        FileFormatUtil.zzZDH(17, 31, 31, 1);
        FileFormatUtil.zzZDH(25, 50, 50, 1);
        FileFormatUtil.zzZDH(26, 45, 255, 1);
        FileFormatUtil.zzZDH(27, 51, 51, 1);
        FileFormatUtil.zzZDH(28, 0, 52, 1);
        FileFormatUtil.zzZDH(29, 0, 53, 1);
        FileFormatUtil.zzZDH(22, 60, 60, 1);
        FileFormatUtil.zzZDH(23, 61, 61, 1);
        FileFormatUtil.zzZDH(33, 40, 64, 1);
        FileFormatUtil.zzZDH(40, 47, 255, 1);
        FileFormatUtil.zzZDH(41, 48, 255, 1);
        FileFormatUtil.zzZDH(34, 41, 255, 1);
        FileFormatUtil.zzZDH(35, 46, 255, 1);
        FileFormatUtil.zzZDH(37, 42, 255, 1);
        FileFormatUtil.zzZDH(36, 44, 255, 1);
        FileFormatUtil.zzZDH(30, 52, 255, 1);
        FileFormatUtil.zzZDH(31, 70, 62, 1);
        FileFormatUtil.zzZDH(32, 73, 63, 1);
        FileFormatUtil.zzZDH(38, 71, 255, 1);
        FileFormatUtil.zzZDH(8, 100, 255, 1);
        FileFormatUtil.zzZDH(9, 105, 255, 1);
        FileFormatUtil.zzZDH(6, 101, 255, 6);
        FileFormatUtil.zzZDH(7, 102, 255, 7);
        FileFormatUtil.zzZDH(5, 104, 255, 5);
        FileFormatUtil.zzZDH(4, 0, 255, 4);
        FileFormatUtil.zzZDH(3, 0, 255, 3);
        FileFormatUtil.zzZDH(39, 72, 255, 1);
        FileFormatUtil.zzZDH(2, 103, 255, 2);
    }
}

