/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.zzWwV;
import com.aspose.words.zzXHJ;
import com.aspose.words.zzXLk;
import com.aspose.words.zzXNV;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzXLk,
Iterable<T> {
    private Node zzXnM;
    private CompositeNode zzWVB;
    private DocumentBase zzZiF;
    private boolean zzYfH;
    private int zzZg5;
    private int zzZS;
    private Node zzYtr;
    private int zzVUG;
    private zzWwV zzZvk;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzXHJ.zzWtK(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzXHJ(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWwV matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzWVB = container;
        this.zzZiF = container.getDocument();
        this.zzZvk = matcher;
        this.zzYfH = isDeep;
        this.zzZBi();
    }

    public Node get(int index) {
        try {
            this.zzWOR();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZS == index) {
                return this.zzYtr;
            }
            int n = index - this.zzZS;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzW97(nodeCollection.zzYtr, n);
            if (node != null) {
                this.zzZS = index;
                this.zzYtr = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYfH) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWVB.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYfH) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWVB.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZK1();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXNV(this);
    }

    final <TNode extends Node> zzXNV<TNode> zzZcZ() {
        return new zzXNV(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzZK1() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZ0T.zzWuo(arrayList, node);
        }
        return arrayList;
    }

    private Node zzW97(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzWBx(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzWDm(curNode, true);
    }

    private Node zzWDm(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzXnM = node;
        do {
            node2 = this.zzXnM;
            Node node3 = this.zzYfH ? this.zzWuo(true, this.zzXnM) : (this.zzXnM = this.zzZvk.zzYLD() ? this.zzWg7(true, this.zzXnM) : this.zzXou(true, this.zzXnM));
        } while (this.zzXnM != null && !this.zzZvk.zzW97(this.zzXnM));
        return node2;
    }

    private Node zzWBx(Node node, boolean bl) throws Exception {
        while ((this.zzYfH ? this.zzWuo(bl, node) : (node = this.zzZvk.zzYLD() ? this.zzWg7(bl, node) : this.zzXou(bl, node))) != null && !this.zzZvk.zzW97(node)) {
        }
        return node;
    }

    private Node zzWuo(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWVB);
        }
        return node.previousPreOrder(this.zzWVB);
    }

    private Node zzXou(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWVB) {
                return this.zzWVB.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWVB) {
            return this.zzWVB.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWg7(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWVB ? this.zzWVB.zzY1s() : node.zzXtg();
        } else {
            Node node3 = node2 = node == this.zzWVB ? this.zzWVB.zzW7V() : node.zzXkL();
        }
        if (node2 == this.zzWVB.getNextSibling() || node2 == this.zzWVB.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzWOR() {
        if (this.zzZg5 != this.zzh1()) {
            this.zzZBi();
        }
    }

    private void zzZBi() {
        this.zzZg5 = this.zzh1();
        this.zzZS = -1;
        this.zzYtr = this.zzWVB;
        this.zzVUG = -1;
    }

    private int zzh1() {
        if (this.zzZiF != null) {
            return this.zzZiF.zzWon();
        }
        return 0;
    }

    public int getCount() {
        this.zzWOR();
        if (this.zzVUG == -1) {
            this.zzVUG = zzXNV.zzWuo(this);
        }
        return this.zzVUG;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzXnM;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWVB;
    }
}

