/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Field;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FrameFormat;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.List;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zzWuq;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.ref.RefBoolean;
import com.aspose.words.ref.RefDouble;
import com.aspose.words.zzE6;
import com.aspose.words.zzVQ4;
import com.aspose.words.zzWBs;
import com.aspose.words.zzX6C;
import com.aspose.words.zzXSL;
import com.aspose.words.zzYF7;
import com.aspose.words.zzYFS;
import com.aspose.words.zzYNl;
import com.aspose.words.zzYgf;
import com.aspose.words.zzYy0;
import com.aspose.words.zzZB6;
import com.aspose.words.zzZJV;
import com.aspose.words.zzZif;
import com.aspose.words.zzzC;
import java.util.Iterator;

public class Paragraph
extends CompositeNode<Node>
implements zzE6,
zzX6C,
zzXSL {
    private zzWBs zzY5p;
    private zzYNl zzyN;
    private ParagraphFormat zzWV8;
    private FrameFormat zzYSR;
    private ListFormat zzGI;
    private ListLabel zzZDO;
    private RunCollection zzVOr;
    private int zzZlD;
    private int zzXSB;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzWBs(), new zzYNl());
    }

    Paragraph(DocumentBase doc, zzWBs paraPr, zzYNl runPr) {
        super(doc);
        this.zzY5p = paraPr;
        this.zzyN = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzZFr() instanceof Cell;
    }

    final boolean zzYPy() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zzYFS.zzVVG(compositeNode)) {
            if (this.isInCell()) {
                Paragraph paragraph = this;
                if (paragraph.zzZNW(paragraph.zzZFr().getFirstChild())) {
                    return true;
                }
            }
            return false;
        }
        return this.isInCell() && this == compositeNode.zzyq();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzZFr();
        return compositeNode instanceof Cell && compositeNode.zzZoS() == this;
    }

    public boolean getBreakIsStyleSeparator() {
        return zzYFS.zzYnz(this.zzyN, 130) && zzYFS.zzYnz(this.zzyN, 10);
    }

    final boolean zzVT6() {
        return this.isEndOfCell() && this.zzZJU().isLastCell();
    }

    final Cell zzZJU() {
        return zzZ0T.zzWuo((Object)this.zzZFr(), Cell.class);
    }

    final Row getParentRow() {
        if (this.zzZJU() != null) {
            return this.zzZJU().getParentRow();
        }
        return null;
    }

    final Table getParentTable() {
        if (this.getParentRow() != null) {
            return this.getParentRow().getParentTable();
        }
        return null;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zzZoS();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zzZoS() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    final boolean zzD() {
        if (this.zzY0U() != null) {
            return false;
        }
        if (this.getParentNode().getNodeType() != 3) {
            return false;
        }
        return !this.getParentSection().zzXVH();
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzWV8 == null) {
            Paragraph paragraph = this;
            this.zzWV8 = new ParagraphFormat(paragraph, paragraph.getDocument().getStyles());
        }
        return this.zzWV8;
    }

    public ListFormat getListFormat() {
        if (this.zzGI == null) {
            Paragraph paragraph = this;
            this.zzGI = new ListFormat(paragraph, paragraph, this.getDocument().getLists());
        }
        return this.zzGI;
    }

    public FrameFormat getFrameFormat() {
        if (this.zzYSR == null) {
            this.zzYSR = new FrameFormat(this);
        }
        return this.zzYSR;
    }

    public ListLabel getListLabel() {
        if (this.zzZDO == null) {
            this.zzZDO = new ListLabel(this);
        }
        return this.zzZDO;
    }

    public RunCollection getRuns() {
        if (this.zzVOr == null) {
            this.zzVOr = new RunCollection(this);
        }
        return this.zzVOr;
    }

    public Font getParagraphBreakFont() {
        Paragraph paragraph = this;
        return new Font(paragraph, paragraph.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzyN.zzWu4();
    }

    public boolean isDeleteRevision() {
        return this.zzyN.zzXGm();
    }

    public boolean isMoveFromRevision() {
        return this.zzyN.zzX9x();
    }

    public boolean isMoveToRevision() {
        return this.zzyN.zzrE();
    }

    public boolean isFormatRevision() {
        return this.zzY5p.zzYXp();
    }

    final Style zzXdV() {
        return this.zzXOF(0);
    }

    final Style zzXOF(int n) {
        Object object = this.zzY5p.zzue(1000, n);
        int n2 = object != null ? (Integer)object : 0;
        return this.getDocument().getStyles().zzXzg(n2, 0);
    }

    private Style zzZla() {
        return this.getDocument().getStyles().zzXzg(this.zzyN.zzWIT(), 10);
    }

    final zzWBs zzK4() {
        return this.zzY5p;
    }

    final void zzWuo(zzWBs zzWBs2) {
        this.zzY5p = zzWBs2;
    }

    final void zzWIa(Paragraph paragraph) {
        if (paragraph.getListLabel().zzWdk() != null && paragraph.getListLabel().zzZdN() != null) {
            this.getListLabel().zzWuo(paragraph.getListLabel().zzWdk(), paragraph.getListLabel().zzY6y(), paragraph.getListLabel().zzZdN().zzWGk(), 0);
        }
        if (paragraph.getListLabel().zzX3P() != null && paragraph.getListLabel().zzXkT() != null) {
            this.getListLabel().zzWuo(paragraph.getListLabel().zzX3P(), paragraph.getListLabel().zzWDX(), paragraph.getListLabel().zzXkT().zzWGk(), 1);
        }
    }

    final void zzZwI(int n) {
        if (this.zzZDO != null) {
            this.zzZDO.zzWuo(null, null, null, n);
        }
    }

    final zzYNl zztM() {
        return this.zzyN;
    }

    final void zzWsB(zzYNl zzYNl2) {
        this.zzyN = zzYNl2;
    }

    @Override
    final Node zzWuo(boolean bl, zzZJV zzZJV2) {
        zzYNl zzYNl2;
        zzWBs zzWBs2;
        Paragraph paragraph = (Paragraph)super.zzWuo(bl, zzZJV2);
        WordAttrCollection wordAttrCollection = this.zzY5p;
        paragraph.zzY5p = zzWBs2 = (zzWBs)wordAttrCollection.zzWqN();
        wordAttrCollection = this.zzyN;
        paragraph.zzyN = zzYNl2 = (zzYNl)wordAttrCollection.zzWqN();
        paragraph.zzWV8 = null;
        paragraph.zzYSR = null;
        paragraph.zzGI = null;
        paragraph.zzZDO = null;
        paragraph.zzVOr = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWuo(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    final int zzXou(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    final zzWBs zzXOt(int n) {
        zzWBs zzWBs2 = new zzWBs();
        this.zzXou(zzWBs2, n);
        return zzWBs2;
    }

    final void zzXou(zzWBs zzWBs2, int n) {
        TableStyle tableStyle;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        boolean bl = (n & 0x40) != 0;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 0x80) == 0;
        n &= 0xFFFFFF7F;
        if (bl2) {
            this.getDocument().getStyles().zzYkL().zzWuo((zzYgf)zzWBs2, bl);
        }
        if ((n & 4) != 0 && (cloneable3 = this.zzZJU()) != null && (cloneable2 = ((Cell)(cloneable = cloneable3)).getParentRow().getParentTable()) != null && (tableStyle = zzZ0T.zzWuo((Object)((Table)cloneable2).getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWuo((Cell)cloneable3, zzWBs2);
        }
        cloneable3 = this.zzY5p.zzWPt(n);
        if ((n & 0x10) != 0 && this.zzY5p.zzYXp()) {
            zzWBs2.zzWuo((zzYy0)this.zzY5p.zzZCk().deepCloneComplexAttr());
        }
        cloneable2 = this.getDocument().getStyles().zzXzg(((zzWBs)cloneable3).zzWIT(), 0);
        int n2 = bl2 ? n & 0xFFFFFFFE : n;
        n2 = bl ? n2 & 0xFFFFFFBF : n2;
        ((Style)cloneable2).zzXou(zzWBs2, n2);
        if (zzWBs2.getListId() != ((zzWBs)cloneable3).getListId() || zzWBs2.zzW81() != ((zzWBs)cloneable3).zzW81()) {
            Cloneable cloneable4 = cloneable3;
            if (!((zzYgf)cloneable3).zzXYZ(1110) && zzWBs2.zzXYZ(1110)) {
                cloneable = cloneable3;
                cloneable4 = (zzWBs)((zzYgf)cloneable).zzWqN();
                ((zzYgf)cloneable4).zzX8D(1110, zzWBs2.get(1110));
            }
            this.getDocument().getLists().zzWuo((zzWBs)cloneable4, zzWBs2);
        }
        if ((n & 8) != 0 && this.zzY5p.zzXYZ(1585)) {
            this.getDocument().zzWjy().zzWuo(this.zzY5p, zzWBs2, this.getParentTable() == null);
        }
        if (bl3) {
            ((zzYgf)cloneable3).zzXou(zzWBs2);
        }
        ((zzWBs)cloneable3).zzZDH(zzWBs2);
        if (((zzWBs)cloneable3).zzY55()) {
            if (!((zzYgf)cloneable3).zzXYZ(1170)) {
                zzWBs2.zzYpR(0);
            }
            if (!((zzYgf)cloneable3).zzXYZ(1160)) {
                zzWBs2.zzZXR(0);
            }
            if (!((zzYgf)cloneable3).zzXYZ(1165)) {
                if (bl) {
                    zzWBs2.set(1165, 0);
                } else {
                    zzWBs2.remove(1165);
                }
            }
            if (!((zzYgf)cloneable3).zzXYZ(1175)) {
                if (bl) {
                    zzWBs2.set(1175, 0);
                } else {
                    zzWBs2.remove(1175);
                }
            }
        }
        if (((Node)(cloneable = this)).zzZFr() instanceof Shape) {
            zzWBs2.zzYnr();
        }
        if ((n & 2) != 0) {
            zzWBs2.zzWsu();
        }
    }

    final zzYNl zzWwR(int n) {
        zzYNl zzYNl2 = new zzYNl();
        int n2 = n;
        zzYNl zzYNl3 = zzYNl2;
        Paragraph paragraph = this;
        zzYFS.zzWuo(paragraph, zzYNl3, n2);
        return zzYNl2;
    }

    final void zzXgf(zzWBs zzWBs2) {
        for (int i = 0; i < zzWBs2.getCount(); ++i) {
            Object object;
            int n = zzWBs2.zzX2m(i);
            Object object2 = zzWBs2.zzXBe(i);
            if (object2.equals(object = this.fetchInheritedParaAttr(n))) {
                this.zzY5p.remove(n);
                continue;
            }
            this.zzY5p.zzX8D(n, object2);
        }
    }

    final boolean zzYJ() {
        CompositeNode compositeNode = this.zzZFr();
        return compositeNode instanceof Comment && this == compositeNode.zzZoS();
    }

    final boolean zzWEy() {
        CompositeNode compositeNode = this.zzZFr();
        return compositeNode instanceof Footnote && this == compositeNode.zzZoS();
    }

    final boolean zz7N() {
        CompositeNode compositeNode = this.zzZFr();
        return compositeNode instanceof zzZif && this == compositeNode.zzZoS();
    }

    final boolean zzZYf() {
        CompositeNode compositeNode = this.zzZFr();
        return compositeNode instanceof Shape && compositeNode.zzZoS() == this;
    }

    final void zzWuo(RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        refDouble.set(2.147483647E9);
        refDouble2.set(0.0);
        refBoolean.set(false);
        for (Node node = this.zzY1s(); node != null; node = node.zzXtg()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzWuo((Inline)node, refDouble, refDouble2, refBoolean);
        }
        if (refDouble2.get() == 0.0) {
            Paragraph.zzWuo(this, refDouble, refDouble2, refBoolean);
        }
    }

    private static void zzWuo(zzX6C zzX6C2, RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        Object object = zzX6C2.getDirectRunAttr(190);
        int n = (Integer)(object != null ? object : zzX6C2.fetchInheritedRunAttr(190));
        double d = (double)n / 2.0;
        refDouble.set(Math.min(d, refDouble.get()));
        refDouble2.set(Math.max(d, refDouble2.get()));
        if (!refBoolean.get()) {
            refBoolean.set(object != null);
            if (!refBoolean.get()) {
                Object object2 = zzX6C2.getDirectRunAttr(50);
                refBoolean.set(object2 != null && (Integer)object2 != 10);
            }
        }
    }

    @Override
    final String zzWko() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    final boolean zzZQl(Node node) {
        Shape shape;
        if (node.getNodeType() == 18 && ((Shape)node).zzZtR() && (shape = (Shape)this.getAncestor(18)) != null && shape.zzZtR()) {
            return false;
        }
        return zzYFS.zzWMV(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzY5p.zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzY5p.zzue(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        return this.zzB8(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        return this.zzW5e(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        this.zzY5p.zzX8D(key, value);
        switch (key) {
            case 1155: 
            case 1165: 
            case 1175: 
            case 1205: 
            case 1225: {
                this.zzZj6();
            }
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzY5p.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzY5p.clear();
    }

    private Object zzB8(int n, int n2) {
        Object object;
        Object object2;
        Paragraph paragraph = this;
        ListLevel listLevel = this.getDocument().getLists().zzWuo(paragraph.zzY5p, n2);
        if (listLevel != null) {
            object2 = listLevel.zzK4().zzZK2(n);
            if (object2 != null) {
                return object2;
            }
        } else {
            object = this.zzY5p.zzue(1120, n2);
            if (object != null && (Integer)object == 0 && zzWBs.zzYrv(n)) {
                return 0;
            }
        }
        if ((object2 = this.zzXOF(n2).zzZqY(n, n2)) != null) {
            return object2;
        }
        if (this.zzXuw() && (object2 = ((TableStyle)(object = (TableStyle)this.getParentTable().getStyle())).zzWg7(n, this.zzZJU())) != null) {
            return object2;
        }
        return this.getDocument().getStyles().zzYkL().zzwg(n);
    }

    private boolean zzXuw() {
        Cell cell = this.zzZJU();
        if (cell == null) {
            return false;
        }
        Row row = cell.getParentRow();
        if (row == null) {
            return false;
        }
        Table table = row.getParentTable();
        if (table == null) {
            return false;
        }
        TableStyle tableStyle = zzZ0T.zzWuo((Object)this.getDocument().getStyles().zz1m(this.getParentTable().zzWIT(), false), TableStyle.class);
        if (tableStyle == null) {
            return false;
        }
        return tableStyle.getStyleIdentifier() != 105;
    }

    final Object zzW5e(int n, int n2) {
        Object object = this.zzY5p.zzue(n, n2);
        if (object != null) {
            return object;
        }
        return this.zzB8(n, n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key) {
        return this.zzyN.zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int key) {
        Object object = this.zzZla().zzjw(key, false);
        if (object != null) {
            return object;
        }
        Paragraph paragraph = this;
        return paragraph.zzXOF(0).zzjw(key, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int key, Object value) {
        this.zzyN.zzX8D(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzyN.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzyN.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzzC getInsertRevision() {
        Paragraph paragraph = this;
        return paragraph.zzyN.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzzC value) {
        Cloneable cloneable = this;
        zzzC zzzC2 = value;
        cloneable = cloneable.zzyN;
        ((zzYgf)cloneable).zzX8D(14, zzzC2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzzC getDeleteRevision() {
        Paragraph paragraph = this;
        return paragraph.zzyN.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzzC value) {
        Cloneable cloneable = this;
        zzzC zzzC2 = value;
        cloneable = cloneable.zzyN;
        ((zzYgf)cloneable).zzX8D(12, zzzC2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYF7 getMoveFromRevision() {
        Paragraph paragraph = this;
        return paragraph.zzyN.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYF7 value) {
        Cloneable cloneable = this;
        zzYF7 zzYF72 = value;
        cloneable = cloneable.zzyN;
        ((zzYgf)cloneable).zzX8D(13, zzYF72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYF7 getMoveToRevision() {
        Paragraph paragraph = this;
        return paragraph.zzyN.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYF7 value) {
        Cloneable cloneable = this;
        zzYF7 zzYF72 = value;
        cloneable = cloneable.zzyN;
        ((zzYgf)cloneable).zzX8D(15, zzYF72);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Paragraph paragraph = this;
        paragraph.zzyN.remove(13);
        paragraph = this;
        paragraph.zzyN.remove(15);
    }

    final boolean zzC6() throws Exception {
        double d;
        CompositeNode compositeNode = this.zzfO();
        if (!(compositeNode instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)compositeNode;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        Paragraph paragraph2 = paragraph;
        Paragraph paragraph3 = paragraph2;
        paragraph3 = this;
        if (paragraph2.zzY5p.zzZQX() != paragraph3.zzY5p.zzZQX()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).equals(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).equals(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).equals(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).equals(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzZJh(paragraph);
    }

    private boolean zzZJh(Paragraph paragraph) {
        Paragraph paragraph2 = paragraph;
        return this.zzY5p.zzX8D(paragraph2.zzY5p);
    }

    final Run zzZuE() {
        return (Run)this.getChild(21, 0, false);
    }

    final Run zzYxq(boolean bl) {
        Run run = null;
        for (Node node = this.zzY1s(); node != null; node = node.zzXtg()) {
            if (node.getNodeType() != 21 || bl && zzWuq.zzWSg(node.getText())) continue;
            run = (Run)node;
        }
        return run;
    }

    final boolean zzXoE() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() {
        return this.zzY5l();
    }

    public TabStop[] getEffectiveTabStops() {
        zzWBs zzWBs2 = this.zzXOt(0);
        int n = zzWBs2.zzXYZ(1140) ? zzWBs2.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzWBs2.getTabStops().get(i).zzZzo();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() {
        StringBuilder stringBuilder = new StringBuilder();
        Paragraph paragraph = this;
        return Paragraph.zzWuo(paragraph, stringBuilder);
    }

    final boolean zzXDs() {
        return this.zzY5l() && this.getListLabel().zzX3J();
    }

    final boolean zz48() {
        return this.zzZcO() && this.getListLabel().zzXmu();
    }

    final boolean hasRevisions() {
        block3: {
            block2: {
                Paragraph paragraph = this;
                if (paragraph.zzyN.hasRevisions()) break block2;
                paragraph = this;
                if (paragraph.zzY5p.hasRevisions()) break block2;
                paragraph = this;
                if (!paragraph.zzY5p.zznK()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXVS() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zzYFS.zzkt(node)) continue;
            return true;
        }
        return false;
    }

    final boolean zzYP4() {
        Iterator iterator = this.getChildNodes().iterator();
        while (iterator.hasNext()) {
            Node node;
            Node node2 = node = (Node)iterator.next();
            if (zzYFS.zzVRC(node.getNodeType())) continue;
            return false;
        }
        return true;
    }

    final int zzZNC(StringBuilder stringBuilder) {
        return Paragraph.zzWuo(this, stringBuilder);
    }

    private static int zzWuo(CompositeNode compositeNode, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.length();
        }
        int n = 0;
        Run run = null;
        zzYNl zzYNl2 = null;
        for (Node node = compositeNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            if (node.getNodeType() == 21) {
                node2 = (Run)node;
                if (run != null) {
                    int n2 = 33;
                    Run run2 = node2;
                    zzYNl zzYNl3 = zzYFS.zzWuo((zzVQ4)run2, n2);
                    if (zzYNl2 == null) {
                        n2 = 33;
                        run2 = run;
                        zzYNl2 = zzYFS.zzWuo((zzVQ4)run2, n2);
                    }
                    if (zzYNl.zzYnz(zzYNl3, zzYNl2)) {
                        if (stringBuilder.length() == 0) {
                            zzZ0T.zzXou(stringBuilder, run.getText());
                        }
                        zzZ0T.zzXou(stringBuilder, ((Run)node2).getText());
                        ++n;
                        compositeNode.removeChild(run);
                    } else {
                        Paragraph.zzWuo(run, stringBuilder);
                        zzYNl2 = null;
                    }
                }
                run = node2;
            } else {
                Paragraph.zzWuo(run, stringBuilder);
                run = null;
                zzYNl2 = null;
            }
            if (node.getNodeType() != 28) continue;
            node2 = (StructuredDocumentTag)node;
            Paragraph.zzWuo((CompositeNode)node2, stringBuilder);
        }
        Paragraph.zzWuo(run, stringBuilder);
        stringBuilder.length();
        return n;
    }

    private static void zzWuo(Run run, StringBuilder stringBuilder) {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    public Field appendField(int fieldType, boolean updateField) throws Exception {
        return this.insertField(fieldType, updateField, null, true);
    }

    public Field appendField(String fieldCode) throws Exception {
        return this.insertField(fieldCode, null, true);
    }

    public Field appendField(String fieldCode, String fieldValue) {
        return this.insertField(fieldCode, fieldValue, null, true);
    }

    public Field insertField(int fieldType, boolean updateField, Node refNode, boolean isAfter) throws Exception {
        return zzYFS.zzWuo(fieldType, updateField, this.zzW0U(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, Node refNode, boolean isAfter) throws Exception {
        return zzYFS.zzWuo(fieldCode, this.zzW0U(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, String fieldValue, Node refNode, boolean isAfter) {
        return zzYFS.zzWuo(fieldCode, fieldValue, this.zzW0U(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    final boolean zzY5l() {
        return (Integer)this.zzW5e(1120, 0) != 0;
    }

    final boolean zzZcO() {
        return (Integer)this.zzW5e(1120, 1) != 0;
    }

    final List zzZ6E(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzW5e(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzWu9(n2);
        return list;
    }

    final ListLevel zzX2k(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzW5e(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzWu9(n2);
        int n3 = (Integer)this.zzW5e(1110, n);
        ListLevel listLevel = list.zzVWR(n3);
        return listLevel;
    }

    final int zzGp() {
        return this.zzZlD;
    }

    final void zzZa5(int n) {
        this.zzZlD = n;
    }

    final int zzdF() {
        return this.zzXSB;
    }

    final void zzX3L(int n) {
        this.zzXSB = n;
    }

    private zzYNl zzW0U(Node node) {
        if (node == null) {
            if (this.getRuns().getCount() > 0) {
                return this.getRuns().get(this.getRuns().getCount() - 1).zzZVp();
            }
        } else if (node instanceof Run && node.getParentNode() == this) {
            return ((Run)node).zzZVp();
        }
        Paragraph paragraph = this;
        return paragraph.zzyN;
    }

    private void zzZj6() {
        if (this.getDocument() == null || this.getParentSection() == null || this.getDocument().getNodeType() != 1) {
            return;
        }
        zzZB6 zzZB62 = new zzZB6();
        zzZB62.visitDocumentStart((Document)this.getDocument());
        zzZB62.visitSectionStart(this.getParentSection());
        zzZB62.visitParagraphStart(this);
    }
}

