/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWQC;
import com.aspose.words.internal.zzYk5;

public abstract class SaveOptions {
    private boolean zzZvS;
    private boolean zzZfw = true;
    private boolean zzYEc = false;
    private boolean zzWrW = true;
    private boolean zzYTP;
    private String zzYBD;
    private boolean zzXNI;
    private boolean zzY0q = false;
    private boolean zzXHh = true;
    private int zzY3f = 1;
    private int zzYyz = 1;
    private int zzXQW = 0;
    private String zzWaW = "";
    private boolean zzZno = true;
    private boolean zzoq = true;
    private boolean zz7t;
    private boolean zzZdU;
    private int zzW8v = 0;
    private boolean zzIW = true;
    private boolean zzNg = false;
    private boolean zzYgZ = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZL3() {
        return false;
    }

    boolean zzgG() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWrW;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWrW = value;
    }

    public String getTempFolder() {
        return this.zzYBD;
    }

    public void setTempFolder(String value) {
        this.zzYBD = value;
    }

    public boolean getPrettyFormat() {
        return this.zzYTP;
    }

    public void setPrettyFormat(boolean value) {
        this.zzYTP = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXNI;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXNI = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzY0q;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzY0q = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzXHh;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzXHh = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY3f;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY3f = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXQW;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXQW = value;
    }

    public int getImlRenderingMode() {
        return this.zzYyz;
    }

    public void setImlRenderingMode(int value) {
        this.zzYyz = value;
    }

    public String getDefaultTemplate() {
        return this.zzWaW;
    }

    public void setDefaultTemplate(String value) {
        this.zzWaW = value;
    }

    public boolean getUpdateFields() {
        return this.zzZno;
    }

    public void setUpdateFields(boolean value) {
        this.zzZno = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zz7t;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zz7t = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZdU;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZdU = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzNg;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzNg = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYEc;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYEc = value;
    }

    final boolean zzY2e() {
        return this.zzoq;
    }

    final boolean zzWdi() {
        return this.zzIW;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYIO(zzYk5.zzZku(zzWQC.zzZ3P(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzW8v;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzW8v = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZvS;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZvS = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzYgZ;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzYgZ = value;
    }

    final boolean zzsZ() {
        return this.zzZfw;
    }
}

