/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZ0T;
import com.aspose.words.zzXR9;
import com.aspose.words.zzXYA;
import com.aspose.words.zzZJV;

public final class Section
extends CompositeNode<Node>
implements zzXR9 {
    private zzXYA zzXaI;
    private PageSetup zzXri;
    private HeaderFooterCollection zzY1j;

    public Section(DocumentBase doc) {
        this(doc, new zzXYA());
    }

    Section(DocumentBase doc, zzXYA sectPr) {
        super(doc);
        this.zzXaI = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzY1j == null) {
            this.zzY1j = new HeaderFooterCollection(this);
        }
        return this.zzY1j;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXri == null) {
            Section section = this;
            this.zzXri = new PageSetup(section, section.getDocument().zzQy(), this.getDocument().getStyles(), new zzWuo(this));
        }
        return this.zzXri;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYjB();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzYfR(!value);
    }

    final zzXYA zzZZj() {
        return this.zzXaI;
    }

    final void zzWg7(zzXYA zzXYA2) {
        this.zzXaI = zzXYA2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzWuo(boolean bl, zzZJV zzZJV2) {
        zzXYA zzXYA2;
        Section section = (Section)super.zzWuo(bl, zzZJV2);
        zzXYA zzXYA3 = this.zzXaI;
        section.zzXaI = zzXYA2 = (zzXYA)zzXYA3.zzWqN();
        section.zzXri = null;
        section.zzY1j = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzWuo(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzXou(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzYnz(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzYnz(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzZwm(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZQl(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZwm(n) == null;
            }
        }
        return false;
    }

    final void zzWg7(Shape shape, boolean bl) {
        this.zzWuo(shape, 4, bl);
        this.zzWuo(shape, 0, bl);
        this.zzWuo(shape, 1, bl);
    }

    private void zzWuo(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzW6s() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZzR()) {
                if (!shape.zzFQ()) continue;
                shape.remove();
            }
        }
    }

    private void zzYnz(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzXou(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXaI.zzZK2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzQy().zzWSZ.zzwg(key);
        }
        return zzXYA.zzXRb(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXaI.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzQy().zzWSZ.zzX8D(key, value);
            return;
        }
        this.zzXaI.zzX8D(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXaI.clear();
    }

    final boolean zzZh7() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXv7() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzWuo
    implements zzXR9 {
        private Section zzZfk;

        zzWuo(Section section) {
            this.zzZfk = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZ7t().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZ7t().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZ7t().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzXR9 zzZ7t() {
            Document document = zzZ0T.zzWuo((Object)this.zzZfk.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZfk;
        }
    }
}

