/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzEu;
import com.aspose.words.internal.zzWuq;
import com.aspose.words.internal.zzZIH;
import com.aspose.words.internal.zzZuf;
import com.aspose.words.internal.zzur;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzXou;
import com.aspose.words.net.System.Data.zzYnz;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzXCX;
    private Object[] zzY6m;
    private int zzcW = 1;
    private int zzSB;
    private String zzZdw;
    private Map<String, Object> zzZ4L = new HashMap<String, Object>();
    private Map<String, String> zzm6 = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzXCX = table;
        this.zzY6m = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzY6m, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzXou.zzWg7(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzXCX.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzXCX.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzXCX;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzXCX.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzXCX.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzXCX.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzXCX.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzXCX.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzXCX.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzXCX) {
            throw new IllegalStateException(zzWuq.zzXou("Table {0} is not the child table in the relation {1}", this.zzXCX.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzWuo(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzpc(columnIndex, value);
        this.zzXCX.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzXCX.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzcW;
    }

    public void setRowState(int state) {
        this.zzcW = state;
    }

    public void delete() {
        zzYnz.zzXou(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzZ4L.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzZ4L.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzY6m.length];
        System.arraycopy(this.zzY6m, 0, objectArray, 0, this.zzY6m.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzY6m.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzY6m.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzpc(i, array[i]);
        }
        this.zzXCX.onDataRowChanged(this);
    }

    final int zzX38() {
        return this.zzSB;
    }

    final void zzXb(String string, String string2) {
        this.zzm6.put(string, string2);
    }

    final void zzW5S(String string, String string2) {
        this.zzZdw = zzWuq.zzXou(string, string2);
    }

    final String zzVRA() {
        return this.zzZdw;
    }

    final void zzby(int n) {
        this.zzSB = n;
    }

    final Object[] zzZrC() {
        return this.zzY6m;
    }

    static boolean zzWuo(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzXIe(index)) {
            return null;
        }
        return this.zzY6m[index];
    }

    private void zzpc(int n, Object object) {
        if (!this.zzXIe(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzWuo((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzWuo((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzWuo(clazz, object)))));
        this.zzY6m[n] = object2;
    }

    private static Object zzWuo(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzur.class) {
                return zzur.zzWuo(string, zzZIH.zziQ(), 128).zzWAx();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzZuf.zzWg7(exception);
        }
        return object;
    }

    private boolean zzXIe(int n) {
        this.zzWKr();
        return this.zzY6m != null && n >= 0 && n < this.zzY6m.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzXCX.getColumns().getCount();
        if (this.zzY6m.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzY6m.length - 1];
        System.arraycopy(this.zzY6m, 0, objectArray, 0, index);
        System.arraycopy(this.zzY6m, index + 1, objectArray, index, this.zzY6m.length - index - 1);
        this.zzY6m = objectArray;
    }

    private void zzWKr() {
        if (this.zzXCX == null || this.zzXCX.getColumns() == null || this.zzY6m == null) {
            return;
        }
        int n = this.zzXCX.getColumns().getCount();
        if (this.zzY6m.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzY6m.length];
        System.arraycopy(this.zzY6m, 0, objectArray, 0, this.zzY6m.length);
        this.zzY6m = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzY6m.length);
        System.arraycopy(objectArray, 0, this.zzY6m, 0, n2);
        for (int i = n2; i < this.zzY6m.length; ++i) {
            this.zzY6m[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzWuo(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzEu.zzWuo(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzZuf.zzWg7(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzZuf.zzWg7(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzZuf.zzWg7(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzZuf.zzWg7(iOException);
            }
            return byArray;
        }
    }

    private static String zzWuo(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzZuf.zzWg7(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzZuf.zzWg7(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.getTable().getTableName() == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzY6m;
        int n = dataRow.zzY6m.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

