/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZuf;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW9K;
import com.aspose.words.net.System.Data.zzWg7;
import com.aspose.words.net.System.Data.zzXM7;
import com.aspose.words.net.System.Data.zzXou;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZeD;
    private final DataColumnCollection zzYY5;
    private final ConstraintCollection zzXAp;
    private final zzW9K zzZ4K;
    private ResultSet zzXE3;
    private String zzXpm;
    private DataSet zzWK0;
    private String zzZ8p;
    private UniqueConstraint zzYtz;
    private boolean zzXjS;
    private final List<DataTableEventListener> zzXOO;
    private final Set<DataRow> zzXj7;
    private DataRelationCollection zzXkQ;

    public DataTable() {
        this.zzZeD = new DataRowCollection(this);
        this.zzYY5 = new DataColumnCollection(this);
        this.zzXAp = new ConstraintCollection(this);
        this.zzZ4K = new zzW9K(this);
        this.zzZ8p = "";
        this.zzXjS = true;
        this.zzXOO = new ArrayList<DataTableEventListener>();
        this.zzXj7 = new HashSet<DataRow>();
        this.zzXkQ = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZeD = new DataRowCollection(this);
        this.zzYY5 = new DataColumnCollection(this);
        this.zzXAp = new ConstraintCollection(this);
        this.zzZ4K = new zzW9K(this);
        this.zzZ8p = "";
        this.zzXjS = true;
        this.zzXOO = new ArrayList<DataTableEventListener>();
        this.zzXj7 = new HashSet<DataRow>();
        this.zzXkQ = new DataRelationCollection();
        this.zzXpm = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzXou.zzWuo(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZeD = new DataRowCollection(this);
        this.zzYY5 = new DataColumnCollection(this);
        this.zzXAp = new ConstraintCollection(this);
        this.zzZ4K = new zzW9K(this);
        this.zzZ8p = "";
        this.zzXjS = true;
        this.zzXOO = new ArrayList<DataTableEventListener>();
        this.zzXj7 = new HashSet<DataRow>();
        this.zzXkQ = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXE3 = resultSet;
        this.zzXpm = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXE3 != null) {
            if (this.zzXE3.getStatement() != null) {
                this.zzXE3.getStatement().getConnection().close();
            }
            this.zzXE3 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXpm;
    }

    public void setTableName(String tableName) {
        this.zzXpm = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYY5.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYY5.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXE3;
    }

    public DataSet getDataSet() {
        return this.zzWK0;
    }

    final void zzYnz(DataSet dataSet) {
        this.zzWK0 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzWK0.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzXkQ.add(dataRelation);
        }
        return this.zzXkQ;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzWK0.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZeD;
    }

    public DataColumnCollection getColumns() {
        return this.zzYY5;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXAp;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYtz == null) {
            return new DataColumn[0];
        }
        return this.zzYtz.getColumns();
    }

    final void zzW9K(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYtz != null) {
                this.zzYtz.zzY3r(false);
                this.getConstraints().remove(this.zzYtz);
                this.zzYtz = null;
            }
            return;
        }
        if (this.zzYtz != null && DataColumn.areColumnSetsTheSame(value, this.zzYtz.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWuo(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYtz != null) {
            this.zzYtz.zzY3r(false);
            this.getConstraints().remove(this.zzYtz);
            this.zzYtz = null;
        }
        UniqueConstraint.zzWuo(this.getConstraints(), uniqueConstraint);
        this.zzYtz = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZ8p;
    }

    public void setNamespace(String namespace) {
        this.zzZ8p = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXjS;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXjS = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXj7.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzXou.zzWuo(this.getResultSet(), this);
            zzXou.zzXou(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZuf.zzYnz(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzXou.zzY0J(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXOO.contains(listener)) {
            this.zzXOO.add(listener);
        }
    }

    public void removeEventListener(zzWg7 listener) {
        if (this.zzXOO.contains(listener)) {
            this.zzXOO.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXOO.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXj7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOO) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXj7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOO) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXj7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOO) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXOO) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXOO) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXM7 zzWuo(zzXou[] zzXouArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzXouArray.length];
        for (int i = 0; i < zzXouArray.length; ++i) {
            dataColumnArray[i] = zzXouArray[i].zzWEo();
        }
        DataTable dataTable = this;
        zzXM7 zzXM72 = dataTable.zzZ4K.zzYnz(dataColumnArray);
        if (zzXM72 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXM72;
    }

    final zzW9K zzZfR() {
        return this.zzZ4K;
    }

    final Set<DataRow> zzI3() {
        return this.zzXj7;
    }
}

