/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.logger;

import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.plugin.configcenter.adapter.ConfigAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigLogger.class);
    @Autowired
    private ConfigAdapter configAdapter;

    public void logSubscribeStarted(boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Subscribe {} config from {} server, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId});
    }

    public void logSubscribeFailed(Exception e, boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.error("Subscribe {} config from {} server failed, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId, e});
    }

    public void logUnsubscribeStarted(boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Unsubscribe {} config from {} server, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId});
    }

    public void logUnsubscribeFailed(Exception e, boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.error("Unsubscribe {} config from {} server failed, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId, e});
    }

    public void logFound(boolean globalConfig) {
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Found {} config from {} server", (Object)subscriptionType, (Object)configType);
    }

    public void logNotFound(boolean globalConfig) {
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Not found {} config from {} server", (Object)subscriptionType, (Object)configType);
    }

    public void logUpdatedEvent(boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Get {} config updated event from {} server, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId});
    }

    public void logClearedEvent(boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Get {} config cleared event from {} server, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId});
    }

    public void logUpdatedSame(boolean globalConfig) {
        String group = this.configAdapter.getGroup();
        String dataId = this.configAdapter.getDataId(globalConfig);
        SubscriptionType subscriptionType = this.configAdapter.getSubscriptionType(globalConfig);
        String configType = this.configAdapter.getConfigType();
        LOG.info("Updated {} config from {} server is same as current config, ignore to update, " + this.getLogKey(), new Object[]{subscriptionType, configType, group, dataId});
    }

    private String getLogKey() {
        return this.configAdapter.isConfigSingleKey() ? "key={}-{}" : "group={}, dataId={}";
    }
}

