/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.RuleEntityWrapper;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.ApplicationInfoAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.cache.PluginCache;
import com.nepxion.discovery.plugin.framework.cache.RuleCache;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.netflix.loadbalancer.Server;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;

public abstract class AbstractPluginAdapter
implements PluginAdapter {
    @Autowired
    protected Registration registration;
    @Autowired
    protected PluginCache pluginCache;
    @Autowired(required=false)
    protected PluginContextHolder pluginContextHolder;
    @Autowired
    protected RuleCache ruleCache;
    @Autowired(required=false)
    protected ApplicationInfoAdapter applicationInfoAdapter;
    @Value(value="${spring.application.group.key:group}")
    private String groupKey;
    @Value(value="${spring.application.type:unknown}")
    private String applicationType;
    protected Map<String, String> emptyMetadata = new HashMap<String, String>();

    @Override
    public String getPlugin() {
        return this.getMetadata().get("spring.application.discovery.plugin");
    }

    @Override
    public String getGroupKey() {
        return this.groupKey;
    }

    @Override
    public String getGroup() {
        String groupKey = this.getGroupKey();
        String group = this.getGroup(groupKey);
        if (StringUtils.isEmpty((CharSequence)group)) {
            group = "default";
        }
        return group;
    }

    protected String getGroup(String groupKey) {
        return this.getMetadata().get(groupKey);
    }

    @Override
    public String getServiceType() {
        return this.applicationType;
    }

    @Override
    public String getServiceId() {
        return this.registration.getServiceId().toLowerCase();
    }

    @Override
    public String getServiceAppId() {
        if (this.applicationInfoAdapter != null) {
            return this.applicationInfoAdapter.getAppId();
        }
        return null;
    }

    @Override
    public String getServiceUUId() {
        return this.getMetadata().get("spring.application.uuid");
    }

    @Override
    public String getHost() {
        return this.registration.getHost();
    }

    @Override
    public int getPort() {
        return this.registration.getPort();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.registration.getMetadata();
    }

    @Override
    public String getVersion() {
        String dynamicVersion = this.getDynamicVersion();
        if (StringUtils.isNotEmpty((CharSequence)dynamicVersion)) {
            return dynamicVersion;
        }
        return this.getLocalVersion();
    }

    @Override
    public String getLocalVersion() {
        String version = this.getMetadata().get("version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "default";
        }
        return version;
    }

    @Override
    public String getDynamicVersion() {
        return this.pluginCache.get("dynamic-version");
    }

    @Override
    public void setDynamicVersion(String version) {
        this.pluginCache.put("dynamic-version", version);
    }

    @Override
    public void clearDynamicVersion() {
        this.pluginCache.clear("dynamic-version");
    }

    @Override
    public RuleEntity getRule() {
        RuleEntity dynamicRuleEntity = this.getDynamicRule();
        if (dynamicRuleEntity != null) {
            return dynamicRuleEntity;
        }
        return this.getLocalRule();
    }

    @Override
    public RuleEntity getLocalRule() {
        return this.ruleCache.get("rule");
    }

    @Override
    public void setLocalRule(RuleEntity ruleEntity) {
        this.ruleCache.put("rule", ruleEntity);
    }

    @Override
    public RuleEntity getDynamicRule() {
        return this.ruleCache.get("dynamic-rule");
    }

    private void assembleDynamicRule() {
        RuleEntity dynamicPartialRule = this.getDynamicPartialRule();
        RuleEntity dynamicGlobalRule = this.getDynamicGlobalRule();
        RuleEntity dynamicRule = RuleEntityWrapper.assemble((RuleEntity)dynamicPartialRule, (RuleEntity)dynamicGlobalRule);
        this.ruleCache.put("dynamic-rule", dynamicRule);
    }

    @Override
    public RuleEntity getDynamicPartialRule() {
        return this.ruleCache.get("dynamic-partial-rule");
    }

    @Override
    public void setDynamicPartialRule(RuleEntity ruleEntity) {
        this.ruleCache.put("dynamic-partial-rule", ruleEntity);
        this.assembleDynamicRule();
    }

    @Override
    public void clearDynamicPartialRule() {
        this.ruleCache.clear("dynamic-partial-rule");
        this.assembleDynamicRule();
    }

    @Override
    public RuleEntity getDynamicGlobalRule() {
        return this.ruleCache.get("dynamic-global-rule");
    }

    @Override
    public void setDynamicGlobalRule(RuleEntity ruleEntity) {
        this.ruleCache.put("dynamic-global-rule", ruleEntity);
        this.assembleDynamicRule();
    }

    @Override
    public void clearDynamicGlobalRule() {
        this.ruleCache.clear("dynamic-global-rule");
        this.assembleDynamicRule();
    }

    @Override
    public String getRegion() {
        String region = this.getMetadata().get("region");
        if (StringUtils.isEmpty((CharSequence)region)) {
            region = "default";
        }
        return region;
    }

    @Override
    public String getEnvironment() {
        String environment = this.getMetadata().get("env");
        if (StringUtils.isEmpty((CharSequence)environment)) {
            environment = "default";
        }
        return environment;
    }

    @Override
    public String getZone() {
        String zone = this.getMetadata().get("zone");
        if (StringUtils.isEmpty((CharSequence)zone)) {
            zone = "default";
        }
        return zone;
    }

    @Override
    public String getContextPath() {
        return this.getMetadata().get("spring.application.context-path");
    }

    @Override
    public String getServerPlugin(Server server) {
        return this.getServerMetadata(server).get("spring.application.discovery.plugin");
    }

    @Override
    public String getServerGroupKey(Server server) {
        String groupKey = this.getServerMetadata(server).get("spring.application.group.key");
        if (StringUtils.isEmpty((CharSequence)groupKey)) {
            groupKey = "group";
        }
        return groupKey;
    }

    @Override
    public String getServerGroup(Server server) {
        String serverGroupKey = this.getServerGroupKey(server);
        String serverGroup = this.getServerMetadata(server).get(serverGroupKey);
        if (StringUtils.isEmpty((CharSequence)serverGroup)) {
            serverGroup = "default";
        }
        return serverGroup;
    }

    @Override
    public String getServerServiceType(Server server) {
        return this.getServerMetadata(server).get("spring.application.type");
    }

    @Override
    public String getServerServiceId(Server server) {
        String serviceId = this.getServerMetadata(server).get("spring.application.name");
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            serviceId = server.getMetaInfo().getAppName();
        }
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            throw new DiscoveryException("Server ServiceId is null");
        }
        return serviceId.toLowerCase();
    }

    @Override
    public String getServerServiceUUId(Server server) {
        return this.getServerMetadata(server).get("spring.application.uuid");
    }

    @Override
    public String getServerVersion(Server server) {
        String serverVersion = this.getServerMetadata(server).get("version");
        if (StringUtils.isEmpty((CharSequence)serverVersion)) {
            serverVersion = "default";
        }
        return serverVersion;
    }

    @Override
    public String getServerRegion(Server server) {
        String serverRegion = this.getServerMetadata(server).get("region");
        if (StringUtils.isEmpty((CharSequence)serverRegion)) {
            serverRegion = "default";
        }
        return serverRegion;
    }

    @Override
    public String getServerEnvironment(Server server) {
        String serverEnvironment = this.getServerMetadata(server).get("env");
        if (StringUtils.isEmpty((CharSequence)serverEnvironment)) {
            serverEnvironment = "default";
        }
        return serverEnvironment;
    }

    @Override
    public String getServerZone(Server server) {
        String serverZone = this.getServerMetadata(server).get("zone");
        if (StringUtils.isEmpty((CharSequence)serverZone)) {
            serverZone = "default";
        }
        return serverZone;
    }

    @Override
    public String getServerContextPath(Server server) {
        return this.getServerMetadata(server).get("spring.application.context-path");
    }

    @Override
    public Map<String, String> getInstanceMetadata(ServiceInstance instance) {
        return instance.getMetadata();
    }

    @Override
    public String getInstancePlugin(ServiceInstance instance) {
        return this.getInstanceMetadata(instance).get("spring.application.discovery.plugin");
    }

    @Override
    public String getInstanceGroupKey(ServiceInstance instance) {
        String groupKey = this.getInstanceMetadata(instance).get("spring.application.group.key");
        if (StringUtils.isEmpty((CharSequence)groupKey)) {
            groupKey = "group";
        }
        return groupKey;
    }

    @Override
    public String getInstanceGroup(ServiceInstance instance) {
        String instanceGroupKey = this.getInstanceGroupKey(instance);
        String instanceGroup = this.getInstanceMetadata(instance).get(instanceGroupKey);
        if (StringUtils.isEmpty((CharSequence)instanceGroup)) {
            instanceGroup = "default";
        }
        return instanceGroup;
    }

    @Override
    public String getInstanceServiceType(ServiceInstance instance) {
        return this.getInstanceMetadata(instance).get("spring.application.type");
    }

    @Override
    public String getInstanceServiceId(ServiceInstance instance) {
        return instance.getServiceId().toLowerCase();
    }

    @Override
    public String getInstanceServiceUUId(ServiceInstance instance) {
        return this.getInstanceMetadata(instance).get("spring.application.uuid");
    }

    @Override
    public String getInstanceVersion(ServiceInstance instance) {
        String instanceVersion = this.getInstanceMetadata(instance).get("version");
        if (StringUtils.isEmpty((CharSequence)instanceVersion)) {
            instanceVersion = "default";
        }
        return instanceVersion;
    }

    @Override
    public String getInstanceRegion(ServiceInstance instance) {
        String instanceRegion = this.getInstanceMetadata(instance).get("region");
        if (StringUtils.isEmpty((CharSequence)instanceRegion)) {
            instanceRegion = "default";
        }
        return instanceRegion;
    }

    @Override
    public String getInstanceEnvironment(ServiceInstance instance) {
        String instanceEnvironment = this.getInstanceMetadata(instance).get("env");
        if (StringUtils.isEmpty((CharSequence)instanceEnvironment)) {
            instanceEnvironment = "default";
        }
        return instanceEnvironment;
    }

    @Override
    public String getInstanceZone(ServiceInstance instance) {
        String instanceZone = this.getInstanceMetadata(instance).get("zone");
        if (StringUtils.isEmpty((CharSequence)instanceZone)) {
            instanceZone = "default";
        }
        return instanceZone;
    }

    @Override
    public String getInstanceContextPath(ServiceInstance instance) {
        return this.getInstanceMetadata(instance).get("spring.application.context-path");
    }

    @Override
    public String getPluginInfo(String previousPluginInfo) {
        String plugin = this.getPlugin();
        String serviceId = this.getServiceId();
        String serviceType = this.getServiceType();
        String host = this.getHost();
        int port = this.getPort();
        String version = this.getVersion();
        String region = this.getRegion();
        String environment = this.getEnvironment();
        String zone = this.getZone();
        String group = this.getGroup();
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)previousPluginInfo)) {
            stringBuilder.append(previousPluginInfo + " -> ");
        }
        stringBuilder.append("[ID=" + serviceId + "]");
        stringBuilder.append("[T=" + serviceType + "]");
        stringBuilder.append("[P=" + plugin + "]");
        stringBuilder.append("[H=" + host + ":" + port + "]");
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            stringBuilder.append("[V=" + version + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            stringBuilder.append("[R=" + region + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)environment)) {
            stringBuilder.append("[E=" + environment + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)zone)) {
            stringBuilder.append("[Z=" + zone + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            stringBuilder.append("[G=" + group + "]");
        }
        if (this.pluginContextHolder != null) {
            String spanId;
            String traceId = this.pluginContextHolder.getTraceId();
            if (StringUtils.isNotEmpty((CharSequence)traceId)) {
                stringBuilder.append("[TID=" + traceId + "]");
            }
            if (StringUtils.isNotEmpty((CharSequence)(spanId = this.pluginContextHolder.getSpanId()))) {
                stringBuilder.append("[SID=" + spanId + "]");
            }
        }
        return stringBuilder.toString();
    }
}

