/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.nepxion.discovery.common.property.DiscoveryProperties;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.decorator.DiscoveryClientDecorator;
import com.nepxion.discovery.plugin.framework.generator.GitGenerator;
import com.nepxion.discovery.plugin.framework.generator.GroupGenerator;
import com.taobao.text.Color;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public abstract class PluginApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(PluginApplicationContextInitializer.class);

    public void initialize(final ConfigurableApplicationContext applicationContext) {
        if (!(applicationContext instanceof AnnotationConfigApplicationContext)) {
            LogoBanner logoBanner = new LogoBanner(PluginApplicationContextInitializer.class, "/com/nepxion/discovery/resource/logo.txt", "Welcome to Nepxion", 9, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta, Color.red, Color.green, Color.cyan}, true);
            NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Version:", "6.5.0", 0, 1), new Description("Github:", "https://github.com/Nepxion/Discovery", 0, 1)});
            boolean servletWebServerEnabled = applicationContext.getClass().getName().endsWith("AnnotationConfigServletWebServerApplicationContext");
            System.setProperty("spring.application.servlet.web.server.enabled", Boolean.toString(servletWebServerEnabled));
            this.initializeDefaultProperties(applicationContext);
        }
        applicationContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new InstantiationAwareBeanPostProcessorAdapter(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DiscoveryClient) {
                    DiscoveryClient discoveryClient = (DiscoveryClient)bean;
                    return new DiscoveryClientDecorator(discoveryClient, applicationContext);
                }
                return PluginApplicationContextInitializer.this.afterInitialization(applicationContext, bean, beanName);
            }
        });
    }

    private void initializeDefaultProperties(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        String path = PluginContextAware.getDefaultPropertiesPath((Environment)environment);
        try {
            DiscoveryProperties properties = new DiscoveryProperties(path, "GBK", "UTF-8");
            Map propertiesMap = properties.getMap();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (environment.getProperty(key) != null || System.getProperty(key) != null || System.getenv(key.toUpperCase()) != null) continue;
                System.setProperty(key, value);
            }
            LOG.info("{} is loaded...", (Object)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getPrefixGroup(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        Boolean isGroupGeneratorEnabled = PluginContextAware.isGroupGeneratorEnabled((Environment)environment);
        if (isGroupGeneratorEnabled.booleanValue()) {
            GroupGenerator groupGenerator = (GroupGenerator)applicationContext.getBean(GroupGenerator.class);
            return groupGenerator.getGroup();
        }
        return null;
    }

    protected String getGitVersion(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        Boolean isGitGeneratorEnabled = PluginContextAware.isGitGeneratorEnabled((Environment)environment);
        if (isGitGeneratorEnabled.booleanValue()) {
            GitGenerator gitGenerator = (GitGenerator)applicationContext.getBean(GitGenerator.class);
            return gitGenerator.getVersion();
        }
        return null;
    }

    public int getOrder() {
        return -2147483647;
    }

    protected abstract Object afterInitialization(ConfigurableApplicationContext var1, Object var2, String var3) throws BeansException;
}

