/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.aop;

import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.service.context.ServiceStrategyContextHolder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractStrategyInterceptor {
    @Autowired
    protected ConfigurableEnvironment environment;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected ServiceStrategyContextHolder serviceStrategyContextHolder;
    @Value(value="${spring.application.strategy.rest.intercept.debug.enabled:false}")
    protected Boolean interceptDebugEnabled;
    protected List<String> requestHeaderList = new ArrayList<String>();

    public AbstractStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        if (StringUtils.isNotEmpty((CharSequence)contextRequestHeaders)) {
            this.requestHeaderList.addAll(StringUtil.splitToList((String)contextRequestHeaders.toLowerCase(), (String)";"));
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRequestHeaders)) {
            this.requestHeaderList.addAll(StringUtil.splitToList((String)businessRequestHeaders.toLowerCase(), (String)";"));
        }
    }

    protected void interceptInputHeader() {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        ServletRequestAttributes attributes = this.serviceStrategyContextHolder.getRestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest previousRequest = attributes.getRequest();
        Enumeration headerNames = previousRequest.getHeaderNames();
        if (headerNames == null) {
            return;
        }
        System.out.println("------- Intercept Input Header Information -------");
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            String headerValue = previousRequest.getHeader(headerName);
            System.out.println(headerName + "=" + headerValue);
        }
        System.out.println("--------------------------------------------------");
    }

    protected boolean isHeaderContains(String headerName) {
        return headerName.startsWith("n-d-") || this.requestHeaderList.contains(headerName);
    }

    protected boolean isHeaderContainsExcludeInner(String headerName) {
        return this.isHeaderContains(headerName) && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-group") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-type") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-app-id") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-id") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-address") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-version") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-region") && !StringUtils.equals((CharSequence)headerName, (CharSequence)"n-d-service-env");
    }
}

