/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.aop;

import com.nepxion.discovery.plugin.strategy.service.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilter;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignStrategyInterceptor
extends AbstractStrategyInterceptor
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FeignStrategyInterceptor.class);
    @Autowired
    private ServiceStrategyRouteFilter serviceStrategyRouteFilter;

    public FeignStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        super(contextRequestHeaders, businessRequestHeaders);
        LOG.info("----------- Feign Intercept Information ----------");
        LOG.info("Feign desires to intercept customer headers are {}", (Object)this.requestHeaderList);
        LOG.info("--------------------------------------------------");
    }

    public void apply(RequestTemplate requestTemplate) {
        this.interceptInputHeader();
        this.applyInnerHeader(requestTemplate);
        this.applyOuterHeader(requestTemplate);
        this.interceptOutputHeader(requestTemplate);
    }

    private void applyInnerHeader(RequestTemplate requestTemplate) {
        requestTemplate.header("n-d-service-group", new String[]{this.pluginAdapter.getGroup()});
        requestTemplate.header("n-d-service-type", new String[]{this.pluginAdapter.getServiceType()});
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            requestTemplate.header("n-d-service-app-id", new String[]{serviceAppId});
        }
        requestTemplate.header("n-d-service-id", new String[]{this.pluginAdapter.getServiceId()});
        requestTemplate.header("n-d-service-address", new String[]{this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()});
        requestTemplate.header("n-d-service-version", new String[]{this.pluginAdapter.getVersion()});
        requestTemplate.header("n-d-service-region", new String[]{this.pluginAdapter.getRegion()});
        requestTemplate.header("n-d-service-env", new String[]{this.pluginAdapter.getEnvironment()});
    }

    private void applyOuterHeader(RequestTemplate requestTemplate) {
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeRegion;
        String routeVersion;
        ServletRequestAttributes attributes = this.serviceStrategyContextHolder.getRestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest previousRequest = attributes.getRequest();
        Enumeration headerNames = previousRequest.getHeaderNames();
        if (headerNames == null) {
            return;
        }
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = previousRequest.getHeader(headerName);
            boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            requestTemplate.header(headerName, new String[]{headerValue});
        }
        Map headers = requestTemplate.headers();
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version"))) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.serviceStrategyRouteFilter.getRouteVersion()))) {
            requestTemplate.header("n-d-version", new String[]{routeVersion});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region"))) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.serviceStrategyRouteFilter.getRouteRegion()))) {
            requestTemplate.header("n-d-region", new String[]{routeRegion});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address"))) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.serviceStrategyRouteFilter.getRouteAddress()))) {
            requestTemplate.header("n-d-address", new String[]{routeAddress});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.serviceStrategyRouteFilter.getRouteVersionWeight()))) {
            requestTemplate.header("n-d-version-weight", new String[]{routeVersionWeight});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.serviceStrategyRouteFilter.getRouteRegionWeight()))) {
            requestTemplate.header("n-d-region-weight", new String[]{routeRegionWeight});
        }
    }

    private void interceptOutputHeader(RequestTemplate requestTemplate) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        System.out.println("------- Intercept Output Header Information ------");
        Map headers = requestTemplate.headers();
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            Collection headerValue = (Collection)entry.getValue();
            System.out.println(headerName + "=" + headerValue);
        }
        System.out.println("--------------------------------------------------");
    }
}

