/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.aop;

import com.nepxion.discovery.plugin.strategy.service.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestTemplateStrategyInterceptor
extends AbstractStrategyInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RestTemplateStrategyInterceptor.class);
    @Autowired
    private ServiceStrategyRouteFilter serviceStrategyRouteFilter;

    public RestTemplateStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        super(contextRequestHeaders, businessRequestHeaders);
        LOG.info("------- RestTemplate Intercept Information -------");
        LOG.info("RestTemplate desires to intercept customer headers are {}", (Object)this.requestHeaderList);
        LOG.info("--------------------------------------------------");
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.interceptInputHeader();
        this.applyInnerHeader(request);
        this.applyOuterHeader(request);
        this.interceptOutputHeader(request);
        return execution.execute(request, body);
    }

    private void applyInnerHeader(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        headers.add("n-d-service-group", this.pluginAdapter.getGroup());
        headers.add("n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            headers.add("n-d-service-app-id", serviceAppId);
        }
        headers.add("n-d-service-id", this.pluginAdapter.getServiceId());
        headers.add("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        headers.add("n-d-service-version", this.pluginAdapter.getVersion());
        headers.add("n-d-service-region", this.pluginAdapter.getRegion());
        headers.add("n-d-service-env", this.pluginAdapter.getEnvironment());
    }

    private void applyOuterHeader(HttpRequest request) {
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeRegion;
        String routeVersion;
        ServletRequestAttributes attributes = this.serviceStrategyContextHolder.getRestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest previousRequest = attributes.getRequest();
        Enumeration headerNames = previousRequest.getHeaderNames();
        if (headerNames == null) {
            return;
        }
        HttpHeaders headers = request.getHeaders();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = previousRequest.getHeader(headerName);
            boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            headers.add(headerName, headerValue);
        }
        if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version")) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.serviceStrategyRouteFilter.getRouteVersion()))) {
            headers.add("n-d-version", routeVersion);
        }
        if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region")) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.serviceStrategyRouteFilter.getRouteRegion()))) {
            headers.add("n-d-region", routeRegion);
        }
        if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address")) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.serviceStrategyRouteFilter.getRouteAddress()))) {
            headers.add("n-d-address", routeAddress);
        }
        if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-weight")) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.serviceStrategyRouteFilter.getRouteVersionWeight()))) {
            headers.add("n-d-version-weight", routeVersionWeight);
        }
        if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-weight")) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.serviceStrategyRouteFilter.getRouteRegionWeight()))) {
            headers.add("n-d-region-weight", routeRegionWeight);
        }
    }

    private void interceptOutputHeader(HttpRequest request) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        System.out.println("------- Intercept Output Header Information ------");
        HttpHeaders headers = request.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            String headerName = (String)header.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            List headerValue = (List)header.getValue();
            System.out.println(headerName + "=" + headerValue);
        }
        System.out.println("--------------------------------------------------");
    }
}

