/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.configuration;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.strategy.adapter.DefaultDiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.service.aop.FeignStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.aop.RestTemplateBeanPostProcessor;
import com.nepxion.discovery.plugin.strategy.service.aop.RestTemplateStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.aop.RpcStrategyAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.aop.RpcStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.filter.DefaultServiceStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.service.isolation.ProviderIsolationStrategyAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.isolation.ProviderIsolationStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.monitor.DefaultServiceStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorInterceptor;
import com.nepxion.discovery.plugin.strategy.service.wrapper.DefaultCallableWrapper;
import com.nepxion.discovery.plugin.strategy.wrapper.CallableWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
@ConditionalOnProperty(value={"spring.application.strategy.control.enabled"}, matchIfMissing=true)
public class ServiceStrategyAutoConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rpc.intercept.enabled"}, matchIfMissing=false)
    public RpcStrategyAutoScanProxy rpcStrategyAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new RpcStrategyAutoScanProxy(scanPackages);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rpc.intercept.enabled"}, matchIfMissing=false)
    public RpcStrategyInterceptor rpcStrategyInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new RpcStrategyInterceptor();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rest.intercept.enabled"}, matchIfMissing=true)
    public FeignStrategyInterceptor feignStrategyInterceptor() {
        String contextRequestHeaders = this.environment.getProperty("spring.application.strategy.context.request.headers");
        String businessRequestHeaders = this.environment.getProperty("spring.application.strategy.business.request.headers");
        return new FeignStrategyInterceptor(contextRequestHeaders, businessRequestHeaders);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rest.intercept.enabled"}, matchIfMissing=true)
    public RestTemplateStrategyInterceptor restTemplateStrategyInterceptor() {
        String contextRequestHeaders = this.environment.getProperty("spring.application.strategy.context.request.headers");
        String businessRequestHeaders = this.environment.getProperty("spring.application.strategy.business.request.headers");
        return new RestTemplateStrategyInterceptor(contextRequestHeaders, businessRequestHeaders);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rest.intercept.enabled"}, matchIfMissing=true)
    public RestTemplateBeanPostProcessor restTemplateBeanPostProcessor() {
        return new RestTemplateBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceStrategyRouteFilter serviceStrategyRouteFilter() {
        return new DefaultServiceStrategyRouteFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitor serviceStrategyMonitor() {
        return new DefaultServiceStrategyMonitor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.rest.intercept.enabled"}, matchIfMissing=true)
    public DiscoveryEnabledAdapter discoveryEnabledAdapter() {
        return new DefaultDiscoveryEnabledAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.provider.isolation.enabled"}, matchIfMissing=false)
    public ProviderIsolationStrategyAutoScanProxy providerIsolationStrategyAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ProviderIsolationStrategyAutoScanProxy(scanPackages);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.provider.isolation.enabled"}, matchIfMissing=false)
    public ProviderIsolationStrategyInterceptor providerIsolationStrategyInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ProviderIsolationStrategyInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitorAutoScanProxy serviceStrategyMonitorAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceStrategyMonitorAutoScanProxy(scanPackages.endsWith(";") ? scanPackages + "com.nepxion.discovery.plugin.admincenter.endpoint" : scanPackages + ";" + "com.nepxion.discovery.plugin.admincenter.endpoint");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitorInterceptor serviceStrategyMonitorInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceStrategyMonitorInterceptor();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.hystrix.threadlocal.supported"}, matchIfMissing=false)
    public CallableWrapper callableWrapper() {
        return new DefaultCallableWrapper();
    }
}

