/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.decorator;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.CollectionUtils;

public class ServiceStrategyRequestDecorator
extends HttpServletRequestWrapper {
    private Map<String, List<String>> headers;

    public ServiceStrategyRequestDecorator(HttpServletRequest request) {
        super(request);
        this.headers = this.initializeHeaders(request);
    }

    private Map<String, List<String>> initializeHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName == null) continue;
            headers.put(headerName, Collections.list(request.getHeaders(headerName)));
        }
        return headers;
    }

    public String getHeader(String name) {
        List<String> headerValues = this.headers.get(name);
        return CollectionUtils.isEmpty(headerValues) ? null : headerValues.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get(name);
        return Collections.enumeration(headerValues != null ? headerValues : Collections.emptySet());
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }
}

