/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.isolation;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.matrix.proxy.aop.AbstractInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProviderIsolationStrategyInterceptor
extends AbstractInterceptor {
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    private PluginAdapter pluginAdapter;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String groupHeader = this.strategyContextHolder.getHeader("n-d-service-group");
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        if (!StringUtils.equals((CharSequence)groupHeader, (CharSequence)group)) {
            throw new DiscoveryException("Reject to invoke because of isolation with different service group for serviceId=" + serviceId);
        }
        return invocation.proceed();
    }
}

