/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.monitor;

import com.nepxion.discovery.common.util.ClassUtil;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorAdapter;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorInterceptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultServiceStrategyMonitor
extends StrategyMonitor
implements ServiceStrategyMonitor {
    @Value(value="${spring.application.strategy.tracer.enabled:false}")
    protected Boolean tracerEnabled;
    @Value(value="${spring.application.strategy.tracer.method.context.output.enabled:false}")
    protected Boolean tracerMethodContextOutputEnabled;
    @Autowired(required=false)
    private List<ServiceStrategyMonitorAdapter> serviceStrategyMonitorAdapterList;

    @Override
    public void monitor(ServiceStrategyMonitorInterceptor interceptor, MethodInvocation invocation) {
        this.spanBuild();
        this.loggerOutput();
        this.loggerDebug();
    }

    @Override
    public void monitor(ServiceStrategyMonitorInterceptor interceptor, MethodInvocation invocation, Object returnValue) {
        this.spanOutput(this.createContextMap(interceptor, invocation, returnValue));
    }

    @Override
    public void error(ServiceStrategyMonitorInterceptor interceptor, MethodInvocation invocation, Throwable e) {
        this.spanError(e);
    }

    @Override
    public void release(ServiceStrategyMonitorInterceptor interceptor, MethodInvocation invocation) {
        this.loggerClear();
        this.spanFinish();
    }

    private Map<String, String> createContextMap(ServiceStrategyMonitorInterceptor interceptor, MethodInvocation invocation, Object returnValue) {
        if (!this.tracerEnabled.booleanValue()) {
            return null;
        }
        HashMap<String, String> contextMap = new HashMap<String, String>();
        String className = interceptor.getMethod(invocation).getDeclaringClass().getName();
        String methodName = interceptor.getMethodName(invocation);
        contextMap.put("* class", className);
        contextMap.put("* method", methodName);
        if (this.tracerMethodContextOutputEnabled.booleanValue()) {
            String[] methodParameterNames = interceptor.getMethodParameterNames(invocation);
            Object[] arguments = interceptor.getArguments(invocation);
            Map parameterMap = ClassUtil.getParameterMap((String[])methodParameterNames, (Object[])arguments);
            if (CollectionUtils.isNotEmpty(this.serviceStrategyMonitorAdapterList)) {
                for (ServiceStrategyMonitorAdapter serviceStrategyMonitorAdapter : this.serviceStrategyMonitorAdapterList) {
                    Map<String, String> customizationMap = serviceStrategyMonitorAdapter.getCustomizationMap(interceptor, invocation, parameterMap, returnValue);
                    for (Map.Entry<String, String> entry : customizationMap.entrySet()) {
                        contextMap.put("* " + entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        return contextMap;
    }
}

