/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.monitor;

import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitor;
import com.nepxion.matrix.proxy.aop.AbstractInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ServiceStrategyMonitorInterceptor
extends AbstractInterceptor {
    @Value(value="${spring.application.strategy.tracer.method.context.output.enabled:false}")
    protected Boolean tracerMethodContextOutputEnabled;
    @Autowired(required=false)
    private ServiceStrategyMonitor serviceStrategyMonitor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String className = this.getMethod(invocation).getDeclaringClass().getName();
        String methodName = this.getMethodName(invocation);
        boolean isMonitored = false;
        boolean isMethodContextMonitored = false;
        try {
            if (StringUtils.equals((String)className, (String)"com.nepxion.discovery.plugin.admincenter.endpoint.InspectorEndpoint") && StringUtils.equals((String)methodName, (String)"inspect")) {
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation);
                    isMonitored = true;
                    this.serviceStrategyMonitor.monitor(this, invocation, "* ignored");
                    isMethodContextMonitored = true;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (this.serviceStrategyMonitor != null) {
                this.serviceStrategyMonitor.monitor(this, invocation);
                isMonitored = true;
            }
            Object returnValue = null;
            if (this.tracerMethodContextOutputEnabled.booleanValue()) {
                returnValue = invocation.proceed();
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation, returnValue);
                    isMethodContextMonitored = true;
                }
            } else {
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation, returnValue);
                    isMethodContextMonitored = true;
                }
                returnValue = invocation.proceed();
            }
            Object object = returnValue;
            return object;
        }
        catch (Throwable e) {
            if (this.serviceStrategyMonitor != null) {
                if (!isMonitored) {
                    this.serviceStrategyMonitor.monitor(this, invocation);
                }
                if (!isMethodContextMonitored) {
                    this.serviceStrategyMonitor.monitor(this, invocation, null);
                }
                this.serviceStrategyMonitor.error(this, invocation, e);
            }
            throw e;
        }
        finally {
            if (this.serviceStrategyMonitor != null) {
                this.serviceStrategyMonitor.release(this, invocation);
            }
        }
    }
}

