/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.wrapper;

import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracerContext;
import com.nepxion.discovery.plugin.strategy.service.context.RestStrategyContext;
import com.nepxion.discovery.plugin.strategy.service.context.RpcStrategyContext;
import com.nepxion.discovery.plugin.strategy.service.decorator.ServiceStrategyRequestDecoratorFactory;
import com.nepxion.discovery.plugin.strategy.wrapper.CallableWrapper;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class DefaultCallableWrapper
implements CallableWrapper {
    @Value(value="${spring.application.strategy.rest.request.decorator.enabled:false}")
    protected Boolean requestDecoratorEnabled;

    public <T> Callable<T> wrapCallable(final Callable<T> callable) {
        RequestAttributes originRequestAttributes = RequestContextHolder.getRequestAttributes();
        if (this.requestDecoratorEnabled.booleanValue()) {
            originRequestAttributes = ServiceStrategyRequestDecoratorFactory.decorateRequestAttributes(originRequestAttributes);
        }
        final RequestAttributes requestAttributes = originRequestAttributes;
        final Map<String, Object> attributes = RpcStrategyContext.getCurrentContext().getAttributes();
        final Object span = StrategyTracerContext.getCurrentContext().getSpan();
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    RestStrategyContext.getCurrentContext().setRequestAttributes(requestAttributes);
                    RpcStrategyContext.getCurrentContext().setAttributes(attributes);
                    StrategyTracerContext.getCurrentContext().setSpan(span);
                    Object v = callable.call();
                    return v;
                }
                finally {
                    RestStrategyContext.clearCurrentContext();
                    RpcStrategyContext.clearCurrentContext();
                    StrategyTracerContext.clearCurrentContext();
                }
            }
        };
    }
}

