/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.BlackList;

import com.oceanbase.jdbc.internal.failover.BlackList.append.AppendStrategy;
import com.oceanbase.jdbc.internal.failover.BlackList.append.NormalAppend;
import com.oceanbase.jdbc.internal.failover.BlackList.recover.RemoveStrategy;
import com.oceanbase.jdbc.internal.failover.BlackList.recover.TimeoutRecover;
import java.util.HashMap;

public class BlackListConfig {
    RemoveStrategy removeStrategy;
    AppendStrategy appendStrategy;
    HashMap<String, String> removeStrategyConfigs;
    HashMap<String, String> appendStrategyConfigs;

    public BlackListConfig() {
        this.appendStrategyConfigs = new HashMap();
        this.appendStrategyConfigs.put("NAME", "NORMAL");
        this.removeStrategyConfigs = new HashMap();
        this.removeStrategyConfigs.put("NAME", "TIMEOUT");
        this.removeStrategyConfigs.put("TIMEOUT", "50");
    }

    public BlackListConfig(boolean byDefault) {
        if (byDefault) {
            this.appendStrategy = new NormalAppend();
            this.removeStrategy = new TimeoutRecover();
        }
    }

    public String toString() {
        return "BlackListConfig{removeStrategy=" + this.removeStrategy + ", appendStrategy=" + this.appendStrategy + '}';
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("\"OBLB_BLACKLIST\":{\n");
        boolean atLeastOne = false;
        if (this.removeStrategy != null) {
            atLeastOne = true;
            json.append(this.removeStrategy.toJson());
        }
        if (this.appendStrategy != null) {
            if (atLeastOne) {
                json.append(",");
            }
            json.append(this.appendStrategy.toJson());
        }
        json.append("}");
        return json.toString();
    }

    public HashMap<String, String> getRemoveStrategyConfigs() {
        return this.removeStrategyConfigs;
    }

    public void setRemoveStrategyConfigs(HashMap<String, String> removeStrategyConfigs) {
        this.removeStrategyConfigs = removeStrategyConfigs;
    }

    public HashMap<String, String> getAppendStrategyConfigs() {
        return this.appendStrategyConfigs;
    }

    public void setAppendStrategyConfigs(HashMap<String, String> appendStrategyConfigs) {
        this.appendStrategyConfigs = appendStrategyConfigs;
    }

    public RemoveStrategy getRemoveStrategy() {
        return this.removeStrategy;
    }

    public void setRemoveStrategy(RemoveStrategy removeStrategy) {
        this.removeStrategy = removeStrategy;
    }

    public AppendStrategy getAppendStrategy() {
        return this.appendStrategy;
    }

    public void setAppendStrategy(AppendStrategy appendStrategy) {
        this.appendStrategy = appendStrategy;
    }
}

