/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.input;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.TraceObject;
import com.oceanbase.jdbc.internal.io.input.StandardPacketInputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.protocol.flt.OceanBaseProtocolV20;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.util.OceanBaseCRC16;
import com.oceanbase.jdbc.util.OceanBaseCRC32C;
import com.oceanbase.jdbc.util.Options;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Ob20PacketInputStream
extends StandardPacketInputStream {
    private static final Logger logger = LoggerFactory.getLogger(Ob20PacketInputStream.class);
    OceanBaseProtocolV20 ob20;
    private OceanBaseCRC32C crc32 = new OceanBaseCRC32C();
    private boolean isTailRead = true;
    private byte[] headerBytes = new byte[31];
    private byte[] tailBytes = new byte[4];
    private long basicRemainder;

    public Ob20PacketInputStream(InputStream in, long threadId, Options options, OceanBaseProtocolV20 ob20, TimeTrace timeTrace) {
        super(threadId, options, timeTrace);
        this.inputStream = in;
        this.ob20 = ob20;
    }

    @Override
    public Buffer getPacket(boolean reUsable) throws IOException {
        return new Buffer(this.getPacketArray(reUsable), this.lastPacketLength);
    }

    @Override
    public byte[] getPacketArray(boolean reUsable) throws IOException {
        if (this.isTailRead) {
            this.resolveOb20Packet();
        }
        return super.getPacketArray(reUsable);
    }

    @Override
    protected void readMysqlStream(byte[] rawBytes, int off, int remaining) throws IOException {
        do {
            int lengthToRead;
            if (this.basicRemainder == 0L && remaining > 0) {
                this.resolveOb20Packet();
            }
            if ((lengthToRead = (int)Math.min((long)remaining, this.basicRemainder)) <= 0) continue;
            this.readFully(rawBytes, off, lengthToRead);
            this.crc32.update(rawBytes, off, lengthToRead);
            remaining -= lengthToRead;
            off += lengthToRead;
            this.basicRemainder -= (long)lengthToRead;
            logger.trace(" ------basicRemainder = {}", (Object)this.basicRemainder);
            if (this.basicRemainder != 0L) continue;
            this.checkTailChecksum();
        } while (remaining > 0);
    }

    @Override
    protected void doTrace(int offset, int length, byte[] rawBytes) {
        if (this.traceCache != null) {
            this.traceCache.put(new TraceObject(false, 3, this.threadId, Arrays.copyOfRange(this.mysqlHeader, 0, 4), Arrays.copyOfRange(rawBytes, offset, Math.min(length, 1000))));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("read: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 4, offset, length, (byte[][])new byte[][]{this.mysqlHeader, rawBytes}));
        }
    }

    private void resolveOb20Packet() throws IOException {
        this.ob20.reset();
        this.readFully(this.headerBytes, 0L, 31L);
        this.checkHeader();
        this.basicRemainder = this.ob20.header.payloadLength;
        if (this.ob20.isExtraInfoExist()) {
            byte[] extraLength = new byte[4];
            this.readFully(extraLength, 0L, 4L);
            this.crc32.update(extraLength, 0, 4);
            this.ob20.extraInfo.extraLength = new Buffer(extraLength).readLong4BytesV1();
            this.ob20.extraInfo.extraBytes = new byte[(int)this.ob20.extraInfo.extraLength];
            this.readFully(this.ob20.extraInfo.extraBytes, 0L, this.ob20.extraInfo.extraLength);
            this.crc32.update(this.ob20.extraInfo.extraBytes, 0, (int)this.ob20.extraInfo.extraLength);
            this.ob20.analyseExtraInfoBytes();
            this.basicRemainder -= 4L + this.ob20.extraInfo.extraLength;
            this.ob20.extraInfo.reset();
        }
        logger.trace(" ------basicRemainder = {}", (Object)this.basicRemainder);
        this.isTailRead = false;
    }

    private void readFully(byte[] b, long off, long len) throws IOException {
        int n = 0;
        while ((long)n < len) {
            int count = this.inputStream.read(b, (int)(off + (long)n), (int)(len - (long)n));
            if (count < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from " + len + " (socket was closed by server)");
            }
            n += count;
        }
    }

    private void checkHeader() throws IOException {
        int localHeaderChecksum;
        Buffer headerBuffer = new Buffer(this.headerBytes);
        this.ob20.header.compressLength = headerBuffer.readInt3Bytes();
        this.ob20.header.compressSeqNo = (short)(headerBuffer.readByte() & 0xFF);
        this.ob20.header.uncompressLength = headerBuffer.readInt3Bytes();
        this.ob20.header.magicNum = headerBuffer.readShort();
        this.ob20.header.version = headerBuffer.readShort();
        this.ob20.header.connectionId = headerBuffer.readLong4BytesV1();
        this.ob20.header.requestId = headerBuffer.readInt3Bytes();
        this.ob20.header.obSeqNo = (short)(headerBuffer.readByte() & 0xFF);
        this.ob20.header.payloadLength = headerBuffer.readLong4BytesV1();
        this.ob20.header.flag = headerBuffer.readInt();
        this.ob20.header.reserved = headerBuffer.readShort();
        this.ob20.header.headerChecksum = headerBuffer.readInt2BytesV1();
        logger.debug("read: {}", (Object)this.headerToString());
        if (0 != this.ob20.header.headerChecksum && (localHeaderChecksum = OceanBaseCRC16.calculate(this.headerBytes, 29)) != this.ob20.header.headerChecksum) {
            logger.error(String.format("header checksum mismatch, expected HeaderChecksum=%d, but received headerChecksum=%d", localHeaderChecksum, this.ob20.header.headerChecksum));
            throw new IOException(String.format("header checksum mismatch, expected HeaderChecksum=%d, but received headerChecksum=%d", localHeaderChecksum, this.ob20.header.headerChecksum));
        }
        if ((long)this.ob20.header.compressLength != 24L + this.ob20.header.payloadLength + 4L) {
            logger.error(String.format("packet length mismatch, received compressLength=%d, payloadLength=%d", this.ob20.header.compressLength, this.ob20.header.payloadLength));
            throw new IOException(String.format("packet length mismatch, received compressLength=%d, payloadLength=%d", this.ob20.header.compressLength, this.ob20.header.payloadLength));
        }
        if (this.ob20.header.uncompressLength != 0) {
            logger.error(String.format("invalid uncompress length, expected uncompressedLen=0, but received uncompressLength=%d", this.ob20.header.uncompressLength));
            throw new IOException(String.format("invalid uncompress length, expected uncompressedLen=0, but received uncompressLength=%d", this.ob20.header.uncompressLength));
        }
        if (this.ob20.header.magicNum != 8363) {
            logger.error(String.format("invalid magic num, expected magicNum=%d, but received magicNum=%d", 8363, this.ob20.header.magicNum));
            throw new IOException(String.format("invalid magic num, expected magicNum=%d, but received magicNum=%d", 8363, this.ob20.header.magicNum));
        }
        if (this.ob20.header.version != 20) {
            logger.error(String.format("invalid version, expected version=%d, but received version=%d", 20, this.ob20.header.version));
            throw new IOException(String.format("invalid version, expected version=%d, but received version=%d", 20, this.ob20.header.version));
        }
        if (this.ob20.header.connectionId != this.threadId) {
            logger.error(String.format("connection Id mismatch, currConnectionId=%d, connId=%d", this.threadId, this.ob20.header.connectionId));
            throw new IOException(String.format("connection Id mismatch, currConnectionId=%d, connId=%d", this.threadId, this.ob20.header.connectionId));
        }
        if (this.ob20.header.requestId != (this.ob20.curRequestId == 0 ? 0xFFFFFF : this.ob20.curRequestId - 1)) {
            logger.error(String.format("request Id mismatch, currRequestId=%d, but received requestId=%d", this.ob20.curRequestId, this.ob20.header.requestId));
            throw new IOException(String.format("request Id mismatch, currRequestId=%d, but received requestId=%d", this.ob20.curRequestId, this.ob20.header.requestId));
        }
        if (this.ob20.header.obSeqNo != this.ob20.getObSeqNo()) {
            logger.error(String.format("packet sequence mismatch, expected obSeqNo=%d, but received obSeqNo=%d", this.ob20.curObSeqNo, this.ob20.header.obSeqNo));
            throw new IOException(String.format("packet sequence mismatch, expected obSeqNo=%d, but received obSeqNo=%d", this.ob20.curObSeqNo, this.ob20.header.obSeqNo));
        }
    }

    private void checkTailChecksum() throws IOException {
        long localTailChecksum;
        this.readFully(this.tailBytes, 0L, 4L);
        this.isTailRead = true;
        this.ob20.tailChecksum = (long)((this.tailBytes[0] & 0xFF) + ((this.tailBytes[1] & 0xFF) << 8) + ((this.tailBytes[2] & 0xFF) << 16)) + ((long)(this.tailBytes[3] & 0xFF) << 24);
        logger.debug("read: tailChecksum = {}", (Object)this.ob20.tailChecksum);
        if (0L != this.ob20.tailChecksum && (localTailChecksum = this.crc32.getValue()) != this.ob20.tailChecksum) {
            logger.error(String.format("tail checksum mismatch, expected tailChecksum=%d, but received tailChecksum=%d", localTailChecksum, this.ob20.tailChecksum));
            throw new IOException(String.format("tail checksum mismatch, expected tailChecksum=%d, but received tailChecksum=%d", localTailChecksum, this.ob20.tailChecksum));
        }
        this.ob20.header.reset();
        this.ob20.tailChecksum = 0L;
        this.crc32.reset();
    }

    private String headerToString() {
        return "connectionId = " + this.ob20.header.connectionId + ", requestId = " + this.ob20.header.requestId + ", obSeqNo = " + this.ob20.header.obSeqNo + ", payloadLength = " + this.ob20.header.payloadLength + ", headerChecksum = " + this.ob20.header.headerChecksum;
    }
}

