/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static byte[] unknownCharsMap;

    public static byte[] getBytesFromString(String s, String characterEncoding) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            String allBytesString = new String(allBytes, 0, 256, characterEncoding);
            int allBytesLen = allBytesString.length();
            byte[] charToByteMap = new byte[65536];
            System.arraycopy(unknownCharsMap, 0, charToByteMap, 0, charToByteMap.length);
            for (int i = 0; i < 256 && i < allBytesLen; ++i) {
                char c = allBytesString.charAt(i);
                charToByteMap[c] = allBytes[i];
            }
            int length = s.length();
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = charToByteMap[s.charAt(i)];
            }
            return bytes;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(uee.getMessage(), uee);
        }
    }

    static {
        int i;
        allBytes = new byte[256];
        unknownCharsMap = new byte[65536];
        for (i = -128; i <= 127; ++i) {
            StringUtils.allBytes[i - -128] = (byte)i;
        }
        for (i = 0; i < unknownCharsMap.length; ++i) {
            StringUtils.unknownCharsMap[i] = 63;
        }
    }
}

