/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.Datum;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BINARY_DOUBLE
extends Datum {
    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String className = targetClass.getName();
        return className.compareTo("java.lang.String") == 0 || className.compareTo("java.lang.Double") == 0;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Double(DataTypeUtilities.bytesToDouble(this.getBytes()));
    }

    @Override
    public String stringValue() {
        return Double.toString(DataTypeUtilities.bytesToDouble(this.getBytes()));
    }

    @Override
    public double doubleValue() throws SQLException {
        return DataTypeUtilities.bytesToDouble(this.getBytes());
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        return new Double[intVal];
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(DataTypeUtilities.bytesToDouble(this.getBytes()));
    }

    public BINARY_DOUBLE(String stringVal) throws SQLException {
        this(DataTypeUtilities.stringToDouble(stringVal));
    }

    public BINARY_DOUBLE(Double doubleVal) {
        super(DataTypeUtilities.doubleToBytes(doubleVal));
    }

    public BINARY_DOUBLE(double doubleVal) {
        super(DataTypeUtilities.doubleToBytes(doubleVal));
    }

    public BINARY_DOUBLE(Boolean booleanVal) {
        this(booleanVal != false ? 1.0 : 0.0);
    }

    public BINARY_DOUBLE(byte[] bytes) {
        super(bytes);
    }

    public BINARY_DOUBLE() {
    }
}

