/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.controller;

import com.ohaotian.abilityadmin.ability.model.bo.AbilityAddReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityDetailReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityModifyReqBO;
import com.ohaotian.abilityadmin.ability.service.AbilityDetailService;
import com.ohaotian.abilityadmin.ability.service.AbilityToVegaService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/abilityDetail"})
public class AbilityDetailController {
    private static Logger logger = LogManager.getLogger(AbilityDetailController.class);
    @Resource
    AbilityDetailService abilityDetailService;
    @Autowired
    private AbilityToVegaService abilityToVegaService;

    @RequestMapping(value={"/toVega/checkIn"})
    @BusiResponseBody
    public RspBO toVegaCheckIn(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        ValidBatchUtils.isNotEmpty((Object)abilityDetailReqBO, (String[])new String[]{"abilityId"});
        return this.abilityToVegaService.checkIn(abilityDetailReqBO.getAbilityId());
    }

    @RequestMapping(value={"/toVega/checkOut"})
    @BusiResponseBody
    public RspBO toVegaCheckOut(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        ValidBatchUtils.isNotEmpty((Object)abilityDetailReqBO, (String[])new String[]{"abilityId"});
        return this.abilityToVegaService.checkOut(abilityDetailReqBO.getAbilityId());
    }

    @RequestMapping(value={"/qryAbilityInfo"})
    @BusiResponseBody
    public RspBO qryAbilityInfo(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        ValidBatchUtils.isNotEmpty((Object)abilityDetailReqBO, (String[])new String[]{"abilityId"});
        return this.abilityDetailService.qryAbilityInfo(abilityDetailReqBO);
    }

    @RequestMapping(value={"/abilityModifyList"})
    @BusiResponseBody
    public RspBO abilityModifyList(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        ValidBatchUtils.isNotEmpty((Object)abilityDetailReqBO, (String[])new String[]{"abilityId"});
        return this.abilityDetailService.abilityModifyList(abilityDetailReqBO);
    }

    @RequestMapping(value={"/checkIn"})
    @BusiResponseBody
    public RspBO checkIn(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityDetailReqBO);
        if (StringUtils.isEmpty((Object)abilityDetailReqBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        Integer count = this.abilityDetailService.checkIn(abilityDetailReqBO.getAbilityId());
        if (count < 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25");
        }
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/checkOut"})
    @BusiResponseBody
    public RspBO checkOut(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityDetailReqBO);
        if (StringUtils.isEmpty((Object)abilityDetailReqBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        Integer count = this.abilityDetailService.checkOut(abilityDetailReqBO.getAbilityId());
        if (count < 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25");
        }
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/checkInBatch"})
    @BusiResponseBody
    public RspBO checkInBatch(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityDetailReqBO);
        if (CollectionUtils.isEmpty(abilityDetailReqBO.getAbilityIds())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        RspBO rspBO = RspBO.success((Object)this.abilityDetailService.checkInBatch(abilityDetailReqBO.getAbilityIds()));
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/checkOutBatch"})
    @BusiResponseBody
    public RspBO checkOutBatch(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityDetailReqBO);
        if (CollectionUtils.isEmpty(abilityDetailReqBO.getAbilityIds())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        RspBO rspBO = RspBO.success((Object)this.abilityDetailService.checkOutBatch(abilityDetailReqBO.getAbilityIds()));
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/delAbility"})
    @BusiResponseBody
    public RspBO delAbility(@RequestBody AbilityDetailReqBO abilityDetailReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityDetailReqBO);
        if (StringUtils.isEmpty((Object)abilityDetailReqBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u9700\u8981\u5220\u9664\u7684\u8bb0\u5f55");
        }
        this.abilityDetailService.delAbility(abilityDetailReqBO.getAbilityId());
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/addAbility"})
    @BusiResponseBody
    public RspBO addAbility(@RequestBody AbilityAddReqBO abilityAddReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityAddReqBO);
        if (abilityAddReqBO.getInputProtocal().contains("ws")) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "wsdl"});
        } else {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "reqJsonschema", "rspJsonschema"});
        }
        if (Constants.AbilityAppCodeSource.BODY.equals(abilityAddReqBO.getAppCodeSource())) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"appCodePath"});
        }
        if (Constants.AbilityType.COMBINATION.equals(abilityAddReqBO.getAbilityType())) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"logicScript", "subAbilityId"});
        }
        RspBO rspBO = this.abilityDetailService.addAbility(abilityAddReqBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/submitAbility"})
    @BusiResponseBody
    public RspBO submitAbility(@RequestBody AbilityAddReqBO abilityAddReqBO) {
        if (!StringUtils.isEmpty((Object)abilityAddReqBO.getAbilityId())) {
            return this.abilityDetailService.submitAbility(abilityAddReqBO);
        }
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityAddReqBO);
        if (abilityAddReqBO.getInputProtocal().contains("ws")) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "wsdl"});
        } else {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "reqJsonschema", "rspJsonschema"});
        }
        if (Constants.AbilityAppCodeSource.BODY.equals(abilityAddReqBO.getAppCodeSource())) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"appCodePath"});
        }
        if (Constants.AbilityType.COMBINATION.equals(abilityAddReqBO.getAbilityType())) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"logicScript", "subAbilityId"});
        }
        RspBO rspBO = this.abilityDetailService.submitAbility(abilityAddReqBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/modifyAbility"})
    @BusiResponseBody
    public RspBO modifyAbility(@RequestBody AbilityModifyReqBO abilityModifyReqBO) {
        if (abilityModifyReqBO == null || StringUtils.isEmpty((Object)abilityModifyReqBO.getAbilityId())) {
            throw new ZTBusinessException("\u83b7\u53d6\u80fd\u529bid\u5f02\u5e38\uff0c\u80fd\u529bid\u4e3a\u7a7a");
        }
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityModifyReqBO);
        if (abilityModifyReqBO.getInputProtocal().contains("ws")) {
            ValidBatchUtils.isNotEmpty((Object)abilityModifyReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "wsdl"});
        } else {
            ValidBatchUtils.isNotEmpty((Object)abilityModifyReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "outputProtocal", "outputTransProtocal", "isMessageCheck", "abilityType", "appCodeSource", "overtime", "retryTime", "appId", "reqJsonschema", "rspJsonschema"});
        }
        if (Constants.AbilityAppCodeSource.BODY.equals(abilityModifyReqBO.getAppCodeSource())) {
            ValidBatchUtils.isNotEmpty((Object)abilityModifyReqBO, (String[])new String[]{"appCodePath"});
        }
        if (Constants.AbilityType.COMBINATION.equals(abilityModifyReqBO.getAbilityType())) {
            ValidBatchUtils.isNotEmpty((Object)abilityModifyReqBO, (String[])new String[]{"logicScript", "subAbilityId"});
        }
        RspBO rspBO = this.abilityDetailService.modifyAbility(abilityModifyReqBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/qryAbilityOutputTransProtocal"})
    @BusiResponseBody
    public RspBO qryAbilityOutputTransProtocal(@RequestBody AbilityAddReqBO abilityAddReqBO) {
        ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"outputProtocal"});
        return this.abilityDetailService.qryAbilityOutputTransProtocal(abilityAddReqBO);
    }

    @RequestMapping(value={"/simpleRegister"})
    @BusiResponseBody
    public RspBO simpleRegister(@RequestBody AbilityAddReqBO abilityAddReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)abilityAddReqBO);
        ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"abilityName", "abilityEname", "abilityVersion", "inputProtocal", "outputProtocal", "outputTransProtocal", "isMessageCheck", "appId", "reqJsonschema", "rspJsonschema"});
        if (abilityAddReqBO.getAppCodeSource() != null && abilityAddReqBO.getAppCodeSource().equals(1)) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"appCodePath"});
        }
        if (abilityAddReqBO.getAbilityType() != null && Constants.AbilityType.COMBINATION.equals(abilityAddReqBO.getAbilityType())) {
            ValidBatchUtils.isNotEmpty((Object)abilityAddReqBO, (String[])new String[]{"logicScript", "subAbilityId"});
        }
        RspBO rspBO = this.abilityDetailService.simpleRegister(abilityAddReqBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @RequestMapping(value={"/checkAbility"})
    @BusiResponseBody
    public RspBO checkAbility(@RequestBody AbilityAddReqBO abilityAddReqBO) {
        RspBO rspBO = this.abilityDetailService.checkAbility(abilityAddReqBO);
        return rspBO;
    }
}

