/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityDeployReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityDetailReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityRegionReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityRegionRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.DeployCallBackBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoBasicData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoExtendData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoExtendShareData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoExtendShareFormData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.AbilityDeployInfoExtendShareInputParams;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityDeployNewRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityDeployReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.QryAbilityDeployRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.base.AbilityAppBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.base.AbilityProvideDeployBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.base.AbilityProvideDubboCustomInputBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.query.base.AbilityProvideHsfCustomInputBO;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.savedeploy.AbilityDeployClusterRegion;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.savedeploy.SaveAbilityDeployExtendData;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.savedeploy.SaveAbilityDeployInputParams;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.savedeploy.SaveAbilityDeployReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.protocal.AbilityDeployRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityDeployService;
import com.ohaotian.abilityadmin.ability.service.AbilityDetailService;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRspBO;
import com.ohaotian.abilityadmin.app.service.AppRegionService;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityModifyMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboCustomInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDubboDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfCustomInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultInputMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHsfDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideHttpDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppRegionMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityadmin.mapper.RegionAddrMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityModifyPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboCustomInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboCustomPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDubboDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfCustomInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfCustomPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultInputPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHsfDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHttpCustomPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideHttpDefaultPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppRegionPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterAbilityPO;
import com.ohaotian.abilityadmin.model.po.RegionAddrPO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.util.ExecutorProcessPool;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.AbilityOperateTypeEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncServiceBO;
import com.ohaotian.portalcommon.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityDeployServiceImpl
implements AbilityDeployService {
    private static final Logger log = LoggerFactory.getLogger(AbilityDeployServiceImpl.class);
    @Resource
    private AppRegionService appRegionService;
    @Resource
    private RegionAddrMapper regionAddrMapper;
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AbilityProvideHttpDefaultMapper abilityProvideHttpDefaultMapper;
    @Resource
    AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;
    @Resource
    AbilityProvideDubboDefaultMapper abilityProvideDubboDefaultMapper;
    @Resource
    AbilityProvideDubboCustomMapper abilityProvideDubboCustomMapper;
    @Resource
    AbilityProvideDubboDefaultInputMapper abilityProvideDubboDefaultInputMapper;
    @Resource
    AbilityProvideDubboCustomInputMapper abilityProvideDubboCustomInputMapper;
    @Resource
    AbilityProvideHsfDefaultMapper abilityProvideHsfDefaultMapper;
    @Resource
    AbilityProvideHsfCustomMapper abilityProvideHsfCustomMapper;
    @Resource
    AbilityProvideHsfDefaultInputMapper abilityProvideHsfDefaultInputMapper;
    @Resource
    AbilityProvideHsfCustomInputMapper abilityProvideHsfCustomInputMapper;
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Resource
    private AbilityModifyMapper abilityModifyMapper;
    @Autowired
    private AppRegionMapper appRegionMapper;
    @Resource
    private AbilityDetailService abilityDetailService;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;
    @Resource
    private AuthorityService authorityService;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Autowired
    private AppMapper appMapper;

    @Override
    public List<QryAbilityDeployNewRspBO> deployScope(QryAbilityDeployReqBO qryAbilityDeployReqBO) {
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setAbilityId(qryAbilityDeployReqBO.getAbilityId());
        abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
        HashMap abilityProvideDefaultPOMap = new HashMap();
        HashMap abilityProvideDefaultInputPOMap = new HashMap();
        ArrayList<QryAbilityDeployRspBO> qryAbilityDeployRspBOArrayList = new ArrayList<QryAbilityDeployRspBO>();
        switch (abilityPO.getOutputProtocal()) {
            case "json": {
                QryAbilityDeployRspBO qryAbilityDeployRspBO;
                List<AbilityProvideDeployBO> abilityProvideDeployBOList = this.abilityProvideDeployMapper.getHttpDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), null);
                for (AbilityProvideDeployBO abilityProvideDeployBO : abilityProvideDeployBOList) {
                    qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                    qryAbilityDeployRspBO.setClusterId(abilityProvideDeployBO.getClusterId());
                    qryAbilityDeployRspBOArrayList.add(qryAbilityDeployRspBO);
                    this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), qryAbilityDeployReqBO.getWhole());
                }
                break;
            }
            case "xml": {
                QryAbilityDeployRspBO qryAbilityDeployRspBO;
                List<AbilityProvideDeployBO> abilityProvideDeployBOList = this.abilityProvideDeployMapper.getHttpDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), null);
                for (AbilityProvideDeployBO abilityProvideDeployBO : abilityProvideDeployBOList) {
                    qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                    qryAbilityDeployRspBO.setClusterId(abilityProvideDeployBO.getClusterId());
                    qryAbilityDeployRspBOArrayList.add(qryAbilityDeployRspBO);
                    this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), qryAbilityDeployReqBO.getWhole());
                }
                break;
            }
            case "dubbo": {
                QryAbilityDeployRspBO qryAbilityDeployRspBO;
                List<AbilityProvideDeployBO> abilityProvideDeployBOList = this.abilityProvideDeployMapper.getDubboDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), null);
                for (AbilityProvideDeployBO abilityProvideDeployBO : abilityProvideDeployBOList) {
                    qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                    qryAbilityDeployRspBO.setClusterId(abilityProvideDeployBO.getClusterId());
                    qryAbilityDeployRspBOArrayList.add(qryAbilityDeployRspBO);
                    this.getDubboDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDefaultInputPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData());
                }
                break;
            }
            case "hsf": {
                QryAbilityDeployRspBO qryAbilityDeployRspBO;
                List<AbilityProvideDeployBO> abilityProvideDeployBOList = this.abilityProvideDeployMapper.getHsfDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), null);
                for (AbilityProvideDeployBO abilityProvideDeployBO : abilityProvideDeployBOList) {
                    qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                    qryAbilityDeployRspBO.setClusterId(abilityProvideDeployBO.getClusterId());
                    qryAbilityDeployRspBOArrayList.add(qryAbilityDeployRspBO);
                    this.getHsfDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDefaultInputPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData());
                }
                break;
            }
            case "ws": {
                QryAbilityDeployRspBO qryAbilityDeployRspBO;
                List<AbilityProvideDeployBO> abilityProvideDeployBOList = this.abilityProvideDeployMapper.getHttpDeployScope(abilityPO.getHirerId(), abilityPO.getAbilityEname(), abilityPO.getAbilityVersion(), null);
                for (AbilityProvideDeployBO abilityProvideDeployBO : abilityProvideDeployBOList) {
                    qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                    qryAbilityDeployRspBO.setClusterId(abilityProvideDeployBO.getClusterId());
                    qryAbilityDeployRspBOArrayList.add(qryAbilityDeployRspBO);
                    this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), qryAbilityDeployReqBO.getWhole());
                }
                break;
            }
        }
        ArrayList qryAbilityDeployNewRspBOList = Lists.newArrayList();
        Map<Long, List<QryAbilityDeployRspBO>> map = qryAbilityDeployRspBOArrayList.stream().collect(Collectors.groupingBy(QryAbilityDeployRspBO::getClusterId));
        for (List list : map.values()) {
            QryAbilityDeployRspBO qryAbilityDeployRspBO1 = (QryAbilityDeployRspBO)list.get(0);
            QryAbilityDeployNewRspBO qryAbilityDeployNewRspBO = new QryAbilityDeployNewRspBO();
            qryAbilityDeployNewRspBO.setClusterId(qryAbilityDeployRspBO1.getClusterId());
            qryAbilityDeployNewRspBO.setClusterFullName(qryAbilityDeployRspBO1.getClusterFullName());
            ArrayList data = Lists.newArrayList();
            for (QryAbilityDeployRspBO qryAbilityDeployRspBO : list) {
                data.add(qryAbilityDeployRspBO.getData());
            }
            qryAbilityDeployNewRspBO.setData(data);
            qryAbilityDeployNewRspBOList.add(qryAbilityDeployNewRspBO);
        }
        return qryAbilityDeployNewRspBOList;
    }

    @Override
    public QryAbilityDeployRspBO deployDetail(QryAbilityDeployReqBO qryAbilityDeployReqBO) {
        AbilityPO abilityPO = this.abilityMapper.queryByProvideDeployId(qryAbilityDeployReqBO.getProvideDeployId());
        HashMap abilityProvideDefaultPOMap = new HashMap();
        HashMap abilityProvideDefaultInputPOMap = new HashMap();
        QryAbilityDeployRspBO qryAbilityDeployRspBO = null;
        switch (abilityPO.getOutputProtocal()) {
            case "json": {
                AbilityProvideDeployBO abilityProvideDeployBO = this.abilityProvideDeployMapper.getHttpDeployScope(null, null, null, qryAbilityDeployReqBO.getProvideDeployId()).get(0);
                qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), Boolean.FALSE);
                qryAbilityDeployRspBO.getData().getExtendData().setType("http-form-area");
                break;
            }
            case "xml": {
                AbilityProvideDeployBO abilityProvideDeployBO = this.abilityProvideDeployMapper.getHttpDeployScope(null, null, null, qryAbilityDeployReqBO.getProvideDeployId()).get(0);
                qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), Boolean.FALSE);
                qryAbilityDeployRspBO.getData().getExtendData().setType("http-form-area");
                break;
            }
            case "dubbo": {
                AbilityProvideDeployBO abilityProvideDeployBO = this.abilityProvideDeployMapper.getDubboDeployScope(null, null, null, qryAbilityDeployReqBO.getProvideDeployId()).get(0);
                qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                this.getDubboDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDefaultInputPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData());
                qryAbilityDeployRspBO.getData().getExtendData().setType("dubbo-form-area");
                break;
            }
            case "hsf": {
                AbilityProvideDeployBO abilityProvideDeployBO = this.abilityProvideDeployMapper.getHsfDeployScope(null, null, null, qryAbilityDeployReqBO.getProvideDeployId()).get(0);
                qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                this.getHsfDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDefaultInputPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData());
                qryAbilityDeployRspBO.getData().getExtendData().setType("hsf-form-area");
                break;
            }
            case "ws": {
                AbilityProvideDeployBO abilityProvideDeployBO = this.abilityProvideDeployMapper.getHttpDeployScope(null, null, null, qryAbilityDeployReqBO.getProvideDeployId()).get(0);
                qryAbilityDeployRspBO = this.getAbilityProvideDeployBO(abilityProvideDeployBO);
                this.getHttpDeployScope(abilityPO, abilityProvideDefaultPOMap, abilityProvideDeployBO, qryAbilityDeployRspBO.getData().getExtendData(), Boolean.FALSE);
                qryAbilityDeployRspBO.getData().getExtendData().setType("http-form-area");
                break;
            }
            default: {
                throw new ZTBusinessException("\u534f\u8bae\u7c7b\u578b\u9519\u8bef");
            }
        }
        return qryAbilityDeployRspBO;
    }

    @Override
    public AbilityDeployRspBO deploy(AbilityDeployReqBO abilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        abilityDeployReqBO.setHirerId(tenantId);
        abilityDeployReqBO.setUserId(userId);
        if (StringUtils.isEmpty(abilityDeployReqBO.getClusterIds())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u96c6\u7fa4");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getAbilityId())) {
            throw new ZTBusinessException("abilityId\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getHirerId())) {
            throw new ZTBusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u79df\u6237id\uff0c\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u91cd\u65b0\u767b\u9646\uff01");
        }
        AbilityAppPO map = (AbilityAppPO)BeanMapper.map((Object)abilityDeployReqBO, AbilityAppPO.class);
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityDeployReqBO.getAbilityId());
        if (StringUtils.isEmpty((Object)abilityPO)) {
            throw new ZTBusinessException("\u53d1\u5e03\u80fd\u529b\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u6b64\u80fd\u529b\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        map.setAbilityEname(abilityPO.getAbilityEname());
        map.setAbilityVersion(abilityPO.getAbilityVersion());
        map.setRelationType(Constants.ProvideType.PROVIDE_TYPE_TRUE);
        AbilityAppPO abilityAppPO = this.abilityAppMapper.queryLimitOne(map);
        if (StringUtils.isEmpty((Object)abilityAppPO) || StringUtils.isEmpty((Object)abilityAppPO.getAbilityAppId())) {
            throw new ZTBusinessException("\u53d1\u5e03\u80fd\u529b\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u90e8\u7f72\u63d0\u4f9b\u5e94\u7528");
        }
        String traceId = UUIDUtil.generateUuid();
        try {
            SyncServiceBO syncServiceBO = new SyncServiceBO();
            syncServiceBO.setClusterIds(abilityDeployReqBO.getClusterIds());
            syncServiceBO.setAbilityEname(abilityPO.getAbilityEname());
            syncServiceBO.setAbilityId(abilityPO.getAbilityId());
            syncServiceBO.setDeployType(Constants.ProvideType.PROVIDE_TYPE_TRUE);
            syncServiceBO.setAbilityVersion(abilityPO.getAbilityVersion());
            syncServiceBO.setHirerId(abilityDeployReqBO.getHirerId());
            syncServiceBO.setTraceId(traceId);
            this.pubSubMsgHandler.writeRedisNode(syncServiceBO, "DEPLOY_SERVICE");
            abilityDeployReqBO.getClusterIds().stream().distinct().forEach(a -> {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId((Long)a);
                this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO).stream().forEach(b -> {
                    b.setDeployStatus(Constants.AbilityDeployStatus.DEPLOYING);
                    b.setTraceId(traceId);
                    this.abilityProvideDeployMapper.updateAbilityProvideDeployByProvideDeployId((AbilityProvideDeployPO)b);
                });
            });
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), abilityDeployReqBO.getModifyRecord(), abilityDeployReqBO.getUserId(), new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            abilityDeployReqBO.getClusterIds().stream().distinct().forEach(a -> {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId((Long)a);
                this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO).stream().forEach(b -> {
                    b.setDeployStatus(Constants.AbilityDeployStatus.FAIL);
                    this.abilityProvideDeployMapper.updateAbilityProvideDeployByProvideDeployId((AbilityProvideDeployPO)b);
                });
            });
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), e.getMessage(), abilityDeployReqBO.getUserId(), new Date());
            throw new ZTBusinessException("\u80fd\u529b\u53d1\u5e03\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return new AbilityDeployRspBO(true, "\u80fd\u529b\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public RspBO deployBatch(final AbilityDetailReqBO abilityDetailReqBO) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List<Long> abilityList;
                ArrayList<SyncServiceBO> syncServiceBOList = new ArrayList<SyncServiceBO>();
                if (!CollectionUtils.isEmpty(abilityDetailReqBO.getAbilityIds())) {
                    abilityList = abilityDetailReqBO.getAbilityIds();
                } else {
                    log.info("\u5168\u91cf\u53d1\u5e03");
                    abilityList = AbilityDeployServiceImpl.this.abilityMapper.queryByCond(new AbilityPO()).stream().map(AbilityPO::getAbilityId).collect(Collectors.toList());
                }
                for (Long abilityId : abilityList) {
                    AbilityDeployReqBO abilityDeployReqBO = new AbilityDeployReqBO();
                    abilityDeployReqBO.setAbilityId(abilityId);
                    abilityDeployReqBO.setClusterIds(new ArrayList<Long>());
                    RspBO<List<Map<String, Object>>> clusterIds = AbilityDeployServiceImpl.this.queryClustersByAbilityId(abilityId);
                    if (ObjectUtils.isEmpty((Object)clusterIds.getData())) continue;
                    List list = (List)clusterIds.getData();
                    list.forEach(map -> abilityDeployReqBO.getClusterIds().add(Long.parseLong(map.get("value").toString())));
                    try {
                        syncServiceBOList.add(AbilityDeployServiceImpl.this.deployData(abilityDeployReqBO));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        AbilityPO abilityPO = AbilityDeployServiceImpl.this.abilityMapper.queryByAbilityId(abilityId);
                        log.error("\u80fd\u529b\u6570\u636e\u5c01\u88c5\u5f02\u5e38\uff1a" + abilityPO.getAbilityEname() + "->" + abilityPO.getAbilityVersion());
                    }
                }
            }
        };
        ExecutorProcessPool.getInstance().executeByCacheThread(runnable);
        return RspBO.success((Object)"\u6279\u91cf\u53d1\u5e03\u4e2d");
    }

    private SyncServiceBO deployData(AbilityDeployReqBO abilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        abilityDeployReqBO.setHirerId(tenantId);
        abilityDeployReqBO.setUserId(userId);
        if (StringUtils.isEmpty(abilityDeployReqBO.getClusterIds())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u96c6\u7fa4");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getAbilityId())) {
            throw new ZTBusinessException("abilityId\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getHirerId())) {
            throw new ZTBusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u79df\u6237id\uff0c\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u91cd\u65b0\u767b\u9646\uff01");
        }
        AbilityAppPO map = (AbilityAppPO)BeanMapper.map((Object)abilityDeployReqBO, AbilityAppPO.class);
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityDeployReqBO.getAbilityId());
        if (StringUtils.isEmpty((Object)abilityPO)) {
            throw new ZTBusinessException("\u53d1\u5e03\u80fd\u529b\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u6b64\u80fd\u529b\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        map.setAbilityEname(abilityPO.getAbilityEname());
        map.setAbilityVersion(abilityPO.getAbilityVersion());
        map.setRelationType(Constants.ProvideType.PROVIDE_TYPE_TRUE);
        AbilityAppPO abilityAppPO = this.abilityAppMapper.queryLimitOne(map);
        if (StringUtils.isEmpty((Object)abilityAppPO) || StringUtils.isEmpty((Object)abilityAppPO.getAbilityAppId())) {
            throw new ZTBusinessException("\u53d1\u5e03\u80fd\u529b\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u90e8\u7f72\u63d0\u4f9b\u5e94\u7528");
        }
        String traceId = UUIDUtil.generateUuid();
        try {
            SyncServiceBO syncServiceBO = new SyncServiceBO();
            syncServiceBO.setClusterIds(abilityDeployReqBO.getClusterIds());
            syncServiceBO.setAbilityEname(abilityPO.getAbilityEname());
            syncServiceBO.setAbilityId(abilityPO.getAbilityId());
            syncServiceBO.setDeployType(Constants.ProvideType.PROVIDE_TYPE_TRUE);
            syncServiceBO.setAbilityVersion(abilityPO.getAbilityVersion());
            syncServiceBO.setHirerId(abilityDeployReqBO.getHirerId());
            syncServiceBO.setTraceId(traceId);
            abilityDeployReqBO.getClusterIds().stream().distinct().forEach(a -> {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId((Long)a);
                this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO).stream().forEach(b -> {
                    b.setDeployStatus(Constants.AbilityDeployStatus.DEPLOYING);
                    b.setTraceId(traceId);
                    this.abilityProvideDeployMapper.updateAbilityProvideDeployByProvideDeployId((AbilityProvideDeployPO)b);
                });
            });
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), abilityDeployReqBO.getModifyRecord(), abilityDeployReqBO.getUserId(), new Date());
            return syncServiceBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            abilityDeployReqBO.getClusterIds().stream().distinct().forEach(a -> {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId((Long)a);
                this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO).stream().forEach(b -> {
                    b.setDeployStatus(Constants.AbilityDeployStatus.FAIL);
                    this.abilityProvideDeployMapper.updateAbilityProvideDeployByProvideDeployId((AbilityProvideDeployPO)b);
                });
            });
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), e.getMessage(), abilityDeployReqBO.getUserId(), new Date());
            throw new ZTBusinessException("\u80fd\u529b\u53d1\u5e03\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public AbilityDeployRspBO cancelDeploy(AbilityDeployReqBO abilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        abilityDeployReqBO.setHirerId(tenantId);
        abilityDeployReqBO.setUserId(userId);
        if (StringUtils.isEmpty(abilityDeployReqBO.getClusterIds())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u96c6\u7fa4");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getAbilityId())) {
            throw new ZTBusinessException("abilityId\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityDeployReqBO.getHirerId())) {
            throw new ZTBusinessException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u79df\u6237id\uff0c\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u91cd\u65b0\u767b\u9646\uff01");
        }
        AbilityAppPO map = (AbilityAppPO)BeanMapper.map((Object)abilityDeployReqBO, AbilityAppPO.class);
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityDeployReqBO.getAbilityId());
        if (StringUtils.isEmpty((Object)abilityPO)) {
            throw new ZTBusinessException("\u53d1\u5e03\u80fd\u529b\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u6b64\u80fd\u529b\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        map.setAbilityEname(abilityPO.getAbilityEname());
        map.setAbilityVersion(abilityPO.getAbilityVersion());
        map.setRelationType(Constants.ProvideType.PROVIDE_TYPE_TRUE);
        AbilityAppPO abilityAppPO = this.abilityAppMapper.queryLimitOne(map);
        if (StringUtils.isEmpty((Object)abilityAppPO) || StringUtils.isEmpty((Object)abilityAppPO.getAbilityAppId())) {
            throw new ZTBusinessException("\u80fd\u529b\u53d1\u5e03\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u90e8\u7f72\u63d0\u4f9b\u5e94\u7528");
        }
        try {
            SyncServiceBO syncServiceBO = new SyncServiceBO();
            syncServiceBO.setAbilityEname(abilityPO.getAbilityEname());
            syncServiceBO.setAbilityId(abilityPO.getAbilityId());
            syncServiceBO.setDeployType(Constants.ProvideType.PROVIDE_TYPE_FALSE);
            syncServiceBO.setAbilityVersion(abilityPO.getAbilityVersion());
            syncServiceBO.setHirerId(abilityDeployReqBO.getHirerId());
            syncServiceBO.setClusterIds(abilityDeployReqBO.getClusterIds());
            this.pubSubMsgHandler.writeRedisNode(syncServiceBO, "DEPLOY_SERVICE");
            abilityDeployReqBO.getClusterIds().stream().distinct().forEach(a -> {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId((Long)a);
                this.abilityProvideDeployMapper.queryByCond(abilityProvideDeployPO).stream().forEach(b -> {
                    b.setDeployStatus(Constants.AbilityDeployStatus.WAIT0);
                    this.abilityProvideDeployMapper.updateAbilityProvideDeployByProvideDeployId((AbilityProvideDeployPO)b);
                });
            });
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), abilityDeployReqBO.getModifyRecord(), abilityDeployReqBO.getUserId(), new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.abilityDetailService.abilityChangeRecord(abilityDeployReqBO.getAbilityId(), AbilityOperateTypeEnum.DEPLOYSCOPE_RELESAE.getValue(), e.getMessage(), abilityDeployReqBO.getUserId(), new Date());
            throw new ZTBusinessException("\u80fd\u529b\u53d6\u6d88\u53d1\u5e03\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return new AbilityDeployRspBO(true, "\u80fd\u529b\u53d6\u6d88\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public RspBO AbilityUnbindRegion(List<AbilityRegionReqBO> abilityRegionReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        if (ObjectUtils.isEmpty(abilityRegionReqBO)) {
            throw new ZTBusinessException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u7ed1\u5b9a");
        }
        for (AbilityRegionReqBO abilityRegionReqBos : abilityRegionReqBO) {
            for (Long clusterId : abilityRegionReqBos.getClusterId()) {
                Date date = new Date();
                AbilityRegionRspBO abilityRegionRspBo = new AbilityRegionRspBO();
                abilityRegionRspBo.setAbilityId(abilityRegionReqBos.getAbilityId());
                abilityRegionRspBo.setRegionId(abilityRegionReqBos.getRegionId());
                AbilityAppPO abilityAppPO = this.regionMapper.queryList(abilityRegionRspBo);
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppPO.getAbilityAppId());
                abilityProvideDeployPO.setClusterId(clusterId);
                RegionPO regionPO = this.regionMapper.queryByRegionId(abilityRegionReqBos.getRegionId());
                abilityProvideDeployPO.setRegionCode(regionPO.getRegionCode());
                if (this.abilityProvideDeployMapper.queryLimitOne(abilityProvideDeployPO) != null) {
                    throw new ZTBusinessException("\u80fd\u529b\u5728\u5206\u533a" + regionPO.getRegionName() + "\u5df2\u7ecf\u521b\u5efa\uff0c\u7981\u6b62\u91cd\u65b0\u521b\u5efa");
                }
                abilityProvideDeployPO.setDeployStatus(0);
                abilityProvideDeployPO.setCreateUserId(userId);
                abilityProvideDeployPO.setCreateTime(date);
                this.abilityProvideDeployMapper.insertSelective(abilityProvideDeployPO);
                AppRegionPO appRegionPO = new AppRegionPO();
                AppPO appPO = this.appMapper.queryByAppId(abilityRegionReqBos.getAppId());
                appRegionPO.setAppCode(appPO.getAppCode());
                appRegionPO.setHirerId(appPO.getHirerId());
                appRegionPO.setRegionCode(regionPO.getRegionCode());
                appRegionPO.setClusterId(clusterId);
                AppRegionPO appRegionPos = this.appRegionMapper.queryLimitOne(appRegionPO);
                if (ObjectUtils.isEmpty((Object)appRegionPos)) {
                    this.appRegionMapper.insertSelective(appRegionPO);
                }
                SaveAbilityDeployReqBO saveAbilityDeployReqBO = new SaveAbilityDeployReqBO();
                saveAbilityDeployReqBO.setProvideDeployId(abilityProvideDeployPO.getProvideDeployId());
                SaveAbilityDeployExtendData saveAbilityDeployExtendData = new SaveAbilityDeployExtendData();
                saveAbilityDeployExtendData.setEprPath(abilityRegionReqBos.getPath());
                saveAbilityDeployReqBO.setExtendData(saveAbilityDeployExtendData);
                this.saveAbilityProvideHttpCustom(saveAbilityDeployReqBO);
            }
        }
        return RspBO.success((Object)true);
    }

    @Override
    @Transactional
    public void addAbilityDeploy(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(saveAbilityDeployReqBO.getAbilityId());
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setHirerId(abilityPO.getHirerId());
        abilityAppPO.setAbilityEname(abilityPO.getAbilityEname());
        abilityAppPO.setAbilityVersion(abilityPO.getAbilityVersion());
        abilityAppPO.setRelationType(1);
        Long abilityAppId = this.abilityAppMapper.queryLimitOne(abilityAppPO).getAbilityAppId();
        Date date = new Date();
        List<AbilityDeployClusterRegion> saveAbilityDeploys = saveAbilityDeployReqBO.getSaveAbilityDeploys();
        for (AbilityDeployClusterRegion abilityDeployClusterRegion : saveAbilityDeploys) {
            List<Long> regionIds = abilityDeployClusterRegion.getRegionIds();
            for (Long regionId : regionIds) {
                AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
                abilityProvideDeployPO.setAbilityAppId(abilityAppId);
                abilityProvideDeployPO.setClusterId(abilityDeployClusterRegion.getClusterId());
                RegionPO regionPO = this.regionMapper.queryByRegionId(regionId);
                abilityProvideDeployPO.setRegionCode(regionPO.getRegionCode());
                if (this.abilityProvideDeployMapper.queryLimitOne(abilityProvideDeployPO) != null) {
                    throw new ZTBusinessException("\u80fd\u529b\u5728\u5206\u533a" + regionPO.getRegionName() + "\u5df2\u7ecf\u53d1\u5e03\uff0c\u7981\u6b62\u91cd\u65b0\u53d1\u5e03");
                }
                abilityProvideDeployPO.setDeployStatus(0);
                abilityProvideDeployPO.setCreateUserId(userId);
                abilityProvideDeployPO.setCreateTime(date);
                this.abilityProvideDeployMapper.insertSelective(abilityProvideDeployPO);
            }
        }
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(saveAbilityDeployReqBO.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.DEPLOYSCOPE_ADD.getValue());
        abilityModifyPO.setModifyRecord(saveAbilityDeployReqBO.getModifyRecord());
        abilityModifyPO.setOperTime(date);
        abilityModifyPO.setOperId(userId);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void delAbilityDeploy(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityPO abilityPO = this.abilityMapper.queryByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        this.deleteAbilityDeployCustom(abilityPO.getOutputProtocal(), saveAbilityDeployReqBO.getProvideDeployId());
        this.abilityProvideDeployMapper.deleteAbilityProvideDeployByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        RateLimiterAbilityPO rateLimiterAbilityPO = new RateLimiterAbilityPO();
        rateLimiterAbilityPO.setAbilityId(saveAbilityDeployReqBO.getAbilityId());
        rateLimiterAbilityPO.setClusterId(saveAbilityDeployReqBO.getClusterId());
        this.rateLimiterAbilityMapper.deleteRateLimiterAbilityByRateLimiter(rateLimiterAbilityPO);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityPO.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.DEPLOYSCOPE_DEL.getValue());
        abilityModifyPO.setModifyRecord(saveAbilityDeployReqBO.getModifyRecord());
        abilityModifyPO.setOperTime(new Date());
        abilityModifyPO.setOperId(userId);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    public void resetAbilityDeploy(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityPO abilityPO = this.abilityMapper.queryByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        this.deleteAbilityDeployCustom(abilityPO.getOutputProtocal(), saveAbilityDeployReqBO.getProvideDeployId());
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityPO.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.DEPLOYSCOPE_RESET.getValue());
        abilityModifyPO.setModifyRecord(saveAbilityDeployReqBO.getModifyRecord());
        abilityModifyPO.setOperTime(new Date());
        abilityModifyPO.setOperId(userId);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modAbilityDeploy(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityPO abilityPO = this.abilityMapper.queryByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        switch (abilityPO.getOutputProtocal()) {
            case "json": {
                if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getEprPath())) {
                    throw new ZTBusinessException("\u975erpc\u534f\u8bae\u80fd\u529b\uff0c\u670d\u52a1\u8def\u52b2\u5fc5\u586b");
                }
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.saveAbilityProvideHttpCustom(saveAbilityDeployReqBO);
                break;
            }
            case "xml": {
                if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getEprPath())) {
                    throw new ZTBusinessException("\u975erpc\u534f\u8bae\u80fd\u529b\uff0c\u670d\u52a1\u8def\u52b2\u5fc5\u586b");
                }
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.saveAbilityProvideHttpCustom(saveAbilityDeployReqBO);
                break;
            }
            case "dubbo": {
                this.checkForRpc(saveAbilityDeployReqBO);
                this.abilityProvideDubboCustomMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.abilityProvideDubboCustomInputMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.saveAbilityProvideDubboCustom(saveAbilityDeployReqBO);
                break;
            }
            case "hsf": {
                this.checkForRpc(saveAbilityDeployReqBO);
                this.abilityProvideHsfCustomMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.abilityProvideHsfCustomInputMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.saveAbilityProvidHsfCustom(saveAbilityDeployReqBO);
                break;
            }
            case "ws": {
                if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getEprPath())) {
                    throw new ZTBusinessException("\u975erpc\u534f\u8bae\u80fd\u529b\uff0c\u670d\u52a1\u8def\u52b2\u5fc5\u586b");
                }
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                this.saveAbilityProvideHttpCustom(saveAbilityDeployReqBO);
                break;
            }
            default: {
                throw new ZTBusinessException("\u534f\u8bae\u7c7b\u578b\u9519\u8bef");
            }
        }
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityPO.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.DEPLOYSCOPE_MOD.getValue());
        abilityModifyPO.setModifyRecord(saveAbilityDeployReqBO.getModifyRecord());
        abilityModifyPO.setOperTime(new Date());
        abilityModifyPO.setOperId(userId);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    public void deployCallBack(DeployCallBackBO deployCallBackBO) {
        this.abilityProvideDeployMapper.updateDeployStatusByTraceId(deployCallBackBO);
    }

    @Override
    public RspBO<List<Map<String, Object>>> queryClustersByAbilityId(Long abilityId) {
        List<AbilityProvideDeployPO> abilityProvideDeployPOS = this.abilityProvideDeployMapper.queryClustersByAbilityId(abilityId);
        if (CollectionUtils.isEmpty(abilityProvideDeployPOS)) {
            return RspBO.success(null);
        }
        List<Long> clusterIds = abilityProvideDeployPOS.stream().map(po -> po.getClusterId()).collect(Collectors.toList());
        ArrayList list = Lists.newArrayList();
        List<ClusterPO> clusterPOList = this.clusterMapper.queryByClusterIds(clusterIds);
        clusterPOList.forEach(po -> {
            HashMap map = Maps.newHashMap();
            map.put("label", po.getClusterName());
            map.put("value", po.getClusterId());
            list.add(map);
        });
        return RspBO.success((Object)list);
    }

    private QryAbilityDeployRspBO getAbilityProvideDeployBO(AbilityProvideDeployBO abilityProvideDeployBO) {
        QryAbilityDeployRspBO qryAbilityDeployRspBO = new QryAbilityDeployRspBO();
        ClusterPO clusterPO = this.clusterMapper.queryByClusterId(abilityProvideDeployBO.getClusterId());
        qryAbilityDeployRspBO.setClusterFullName(clusterPO.getClusterName());
        AbilityDeployInfoData data = new AbilityDeployInfoData();
        qryAbilityDeployRspBO.setData(data);
        data.setProvideDeployId(abilityProvideDeployBO.getProvideDeployId());
        AbilityDeployInfoBasicData basicData = new AbilityDeployInfoBasicData();
        data.setBasicData(basicData);
        basicData.setRegionName(abilityProvideDeployBO.getRegionBO().getRegionName());
        basicData.setRegionCode(abilityProvideDeployBO.getRegionBO().getRegionCode());
        basicData.setDeployStatus(abilityProvideDeployBO.getDeployStatus());
        AbilityDeployInfoExtendData abilityDeployInfoExtendData = new AbilityDeployInfoExtendData();
        data.setExtendData(abilityDeployInfoExtendData);
        return qryAbilityDeployRspBO;
    }

    private void getHttpDeployScope(AbilityPO abilityPO, Map abilityProvideHttpDefaultPOMap, AbilityProvideDeployBO abilityProvideDeployBO, AbilityDeployInfoExtendData abilityDeployInfoExtendData, Boolean whole) {
        AbilityDeployInfoExtendShareData shareData = new AbilityDeployInfoExtendShareData();
        abilityDeployInfoExtendData.setShareData(shareData);
        if (abilityProvideDeployBO.getAbilityProvideHttpCustomBO() != null) {
            shareData.setEprPath(this.theFullPath(whole, abilityProvideDeployBO.getRegionBO().getRegionId(), abilityProvideDeployBO.getAbilityProvideHttpCustomBO().getEprPath()));
        } else {
            AbilityProvideHttpDefaultPO abilityProvideHttpDefaultPO = (AbilityProvideHttpDefaultPO)abilityProvideHttpDefaultPOMap.get(abilityProvideDeployBO.getAbilityAppBO().getAbilityAppId());
            if (abilityProvideHttpDefaultPO == null) {
                abilityProvideHttpDefaultPO = new AbilityProvideHttpDefaultPO();
                AbilityAppBO abilityAppBO = abilityProvideDeployBO.getAbilityAppBO();
                abilityProvideHttpDefaultPO.setAbilityId(abilityPO.getAbilityId());
                abilityProvideHttpDefaultPO = this.abilityProvideHttpDefaultMapper.queryLimitOne(abilityProvideHttpDefaultPO);
                abilityProvideHttpDefaultPOMap.put(abilityAppBO.getAbilityAppId(), abilityProvideHttpDefaultPO);
            }
            shareData.setEprPath(this.theFullPath(whole, abilityProvideDeployBO.getRegionBO().getRegionId(), abilityProvideHttpDefaultPO.getEprPath()));
        }
        abilityDeployInfoExtendData.setType("http-form-area-label");
    }

    private String theFullPath(Boolean whole, Long regionId, String erpPath) {
        if (Boolean.TRUE.equals(whole)) {
            StringBuilder stringBuilder = new StringBuilder();
            AppRegionRepBO appRegionRepBO = new AppRegionRepBO();
            appRegionRepBO.setRegionId(regionId);
            AppRegionRspBO appRegionRspBO = (AppRegionRspBO)this.appRegionService.qryRegionInfo(appRegionRepBO).getData();
            if (appRegionRspBO.getCallProtocol() != 0) {
                stringBuilder.append("https://");
            } else {
                stringBuilder.append("http://");
            }
            RegionAddrPO regionAddrPo = new RegionAddrPO();
            regionAddrPo.setRegionId(regionId);
            List<RegionAddrPO> regionAddrPOList = this.regionAddrMapper.queryByCond(regionAddrPo);
            if (!CollectionUtils.isEmpty(regionAddrPOList)) {
                stringBuilder.append(regionAddrPOList.get(0).getIp());
                if (!ObjectUtils.isEmpty((Object)regionAddrPOList.get(0).getPort())) {
                    stringBuilder.append(":");
                    stringBuilder.append(regionAddrPOList.get(0).getPort());
                }
            } else {
                stringBuilder.append("\u672a\u914d\u7f6eIP");
            }
            stringBuilder.append(erpPath);
            return stringBuilder.toString();
        }
        return erpPath;
    }

    private void getDubboDeployScope(AbilityPO abilityPO, Map abilityProvideDefaultPOMap, Map abilityProvideDefaultInputPOMap, AbilityProvideDeployBO abilityProvideDeployBO, AbilityDeployInfoExtendData abilityDeployInfoExtendData) {
        AbilityDeployInfoExtendShareData shareData = new AbilityDeployInfoExtendShareData();
        abilityDeployInfoExtendData.setShareData(shareData);
        AbilityDeployInfoExtendShareFormData abilityDeployInfoExtendShareFormData = new AbilityDeployInfoExtendShareFormData();
        shareData.setFormData(abilityDeployInfoExtendShareFormData);
        if (abilityProvideDeployBO.getAbilityProvideDubboCustomBO() != null) {
            abilityDeployInfoExtendShareFormData.setInterfaceName(abilityProvideDeployBO.getAbilityProvideDubboCustomBO().getInterfaceName());
            abilityDeployInfoExtendShareFormData.setMethodName(abilityProvideDeployBO.getAbilityProvideDubboCustomBO().getMethodName());
            abilityDeployInfoExtendShareFormData.setGroupName(abilityProvideDeployBO.getAbilityProvideDubboCustomBO().getGroupName());
            abilityDeployInfoExtendShareFormData.setVersion(abilityProvideDeployBO.getAbilityProvideDubboCustomBO().getVersion());
        } else {
            AbilityProvideDubboDefaultPO abilityProvideDubboDefaultPO = (AbilityProvideDubboDefaultPO)abilityProvideDefaultPOMap.get(abilityProvideDeployBO.getAbilityAppBO().getAbilityAppId());
            if (abilityProvideDubboDefaultPO == null) {
                abilityProvideDubboDefaultPO = new AbilityProvideDubboDefaultPO();
                AbilityAppBO abilityAppBO = abilityProvideDeployBO.getAbilityAppBO();
                abilityProvideDubboDefaultPO.setAbilityId(abilityPO.getAbilityId());
                abilityProvideDubboDefaultPO = this.abilityProvideDubboDefaultMapper.queryLimitOne(abilityProvideDubboDefaultPO);
                abilityProvideDefaultPOMap.put(abilityAppBO.getAbilityAppId(), abilityProvideDubboDefaultPO);
            }
            abilityDeployInfoExtendShareFormData.setInterfaceName(abilityProvideDubboDefaultPO.getInterfaceName());
            abilityDeployInfoExtendShareFormData.setMethodName(abilityProvideDubboDefaultPO.getMethodName());
            abilityDeployInfoExtendShareFormData.setGroupName(abilityProvideDubboDefaultPO.getGroupName());
            abilityDeployInfoExtendShareFormData.setVersion(abilityProvideDubboDefaultPO.getVersion());
        }
        ArrayList<AbilityDeployInfoExtendShareInputParams> abilityDeployInfoExtendShareInputParamsList = new ArrayList<AbilityDeployInfoExtendShareInputParams>();
        shareData.setInputParams(abilityDeployInfoExtendShareInputParamsList);
        List<AbilityProvideDubboCustomInputBO> abilityProvideDubboCustomInputBOList = abilityProvideDeployBO.getAbilityProvideDubboCustomInputBO();
        if (abilityProvideDubboCustomInputBOList != null && abilityProvideDubboCustomInputBOList.size() > 0) {
            for (AbilityProvideDubboCustomInputBO abilityProvideDubboCustomInputBO : abilityProvideDubboCustomInputBOList) {
                AbilityDeployInfoExtendShareInputParams abilityDeployInfoExtendShareInputParams = new AbilityDeployInfoExtendShareInputParams();
                abilityDeployInfoExtendShareInputParams.setArgsName(abilityProvideDubboCustomInputBO.getArgsName());
                abilityDeployInfoExtendShareInputParams.setArgsPath(abilityProvideDubboCustomInputBO.getArgsPath());
                abilityDeployInfoExtendShareInputParams.setSort(abilityProvideDubboCustomInputBO.getSort());
                abilityDeployInfoExtendShareInputParamsList.add(abilityDeployInfoExtendShareInputParams);
            }
        } else {
            List<AbilityProvideDubboDefaultInputPO> abilityProvideDubboDefaultInputPOList = (List<AbilityProvideDubboDefaultInputPO>)abilityProvideDefaultInputPOMap.get(abilityProvideDeployBO.getAbilityAppBO().getAbilityAppId());
            if (abilityProvideDubboDefaultInputPOList == null) {
                AbilityProvideDubboDefaultInputPO abilityProvideDubboDefaultInputPO = new AbilityProvideDubboDefaultInputPO();
                AbilityAppBO abilityAppBO = abilityProvideDeployBO.getAbilityAppBO();
                abilityProvideDubboDefaultInputPO.setAbilityId(abilityPO.getAbilityId());
                abilityProvideDubboDefaultInputPOList = this.abilityProvideDubboDefaultInputMapper.queryByCond(abilityProvideDubboDefaultInputPO);
                abilityProvideDefaultInputPOMap.put(abilityAppBO.getAbilityAppId(), abilityProvideDubboDefaultInputPOList);
            }
            for (AbilityProvideDubboDefaultInputPO abilityProvideDubboDefaultInputPO : abilityProvideDubboDefaultInputPOList) {
                AbilityDeployInfoExtendShareInputParams abilityDeployInfoExtendShareInputParams = new AbilityDeployInfoExtendShareInputParams();
                abilityDeployInfoExtendShareInputParams.setArgsName(abilityProvideDubboDefaultInputPO.getArgsName());
                abilityDeployInfoExtendShareInputParams.setArgsPath(abilityProvideDubboDefaultInputPO.getArgsPath());
                abilityDeployInfoExtendShareInputParams.setSort(abilityProvideDubboDefaultInputPO.getSort());
                abilityDeployInfoExtendShareInputParamsList.add(abilityDeployInfoExtendShareInputParams);
            }
        }
        abilityDeployInfoExtendData.setType("dubbo-form-area-label");
    }

    private void getHsfDeployScope(AbilityPO abilityPO, Map abilityProvideDefaultPOMap, Map abilityProvideDefaultInputPOMap, AbilityProvideDeployBO abilityProvideDeployBO, AbilityDeployInfoExtendData abilityDeployInfoExtendData) {
        AbilityDeployInfoExtendShareData shareData = new AbilityDeployInfoExtendShareData();
        abilityDeployInfoExtendData.setShareData(shareData);
        AbilityDeployInfoExtendShareFormData abilityDeployInfoExtendShareFormData = new AbilityDeployInfoExtendShareFormData();
        shareData.setFormData(abilityDeployInfoExtendShareFormData);
        if (abilityProvideDeployBO.getAbilityProvideHsfCustomBO() != null) {
            abilityDeployInfoExtendShareFormData.setInterfaceName(abilityProvideDeployBO.getAbilityProvideHsfCustomBO().getInterfaceName());
            abilityDeployInfoExtendShareFormData.setMethodName(abilityProvideDeployBO.getAbilityProvideHsfCustomBO().getMethodName());
            abilityDeployInfoExtendShareFormData.setGroupName(abilityProvideDeployBO.getAbilityProvideHsfCustomBO().getGroupName());
            abilityDeployInfoExtendShareFormData.setVersion(abilityProvideDeployBO.getAbilityProvideHsfCustomBO().getVersion());
        } else {
            AbilityProvideHsfDefaultPO abilityProvideHsfDefaultPO = (AbilityProvideHsfDefaultPO)abilityProvideDefaultPOMap.get(abilityProvideDeployBO.getAbilityAppBO().getAbilityAppId());
            if (abilityProvideHsfDefaultPO == null) {
                abilityProvideHsfDefaultPO = new AbilityProvideHsfDefaultPO();
                AbilityAppBO abilityAppBO = abilityProvideDeployBO.getAbilityAppBO();
                abilityProvideHsfDefaultPO.setAbilityId(abilityPO.getAbilityId());
                abilityProvideHsfDefaultPO = this.abilityProvideHsfDefaultMapper.queryLimitOne(abilityProvideHsfDefaultPO);
                abilityProvideDefaultPOMap.put(abilityAppBO.getAbilityAppId(), abilityProvideHsfDefaultPO);
            }
            abilityDeployInfoExtendShareFormData.setInterfaceName(abilityProvideHsfDefaultPO.getInterfaceName());
            abilityDeployInfoExtendShareFormData.setMethodName(abilityProvideHsfDefaultPO.getMethodName());
            abilityDeployInfoExtendShareFormData.setGroupName(abilityProvideHsfDefaultPO.getGroupName());
            abilityDeployInfoExtendShareFormData.setVersion(abilityProvideHsfDefaultPO.getVersion());
        }
        ArrayList<AbilityDeployInfoExtendShareInputParams> abilityDeployInfoExtendShareInputParamsList = new ArrayList<AbilityDeployInfoExtendShareInputParams>();
        shareData.setInputParams(abilityDeployInfoExtendShareInputParamsList);
        List<AbilityProvideHsfCustomInputBO> abilityProvideHsfCustomInputBOList = abilityProvideDeployBO.getAbilityProvideHsfCustomInputBO();
        if (abilityProvideHsfCustomInputBOList != null && abilityProvideHsfCustomInputBOList.size() > 0) {
            for (AbilityProvideHsfCustomInputBO abilityProvideHsfCustomInputBO : abilityProvideHsfCustomInputBOList) {
                AbilityDeployInfoExtendShareInputParams abilityDeployInfoExtendShareInputParams = new AbilityDeployInfoExtendShareInputParams();
                abilityDeployInfoExtendShareInputParams.setArgsName(abilityProvideHsfCustomInputBO.getArgsName());
                abilityDeployInfoExtendShareInputParams.setArgsPath(abilityProvideHsfCustomInputBO.getArgsPath());
                abilityDeployInfoExtendShareInputParams.setSort(abilityProvideHsfCustomInputBO.getSort());
                abilityDeployInfoExtendShareInputParamsList.add(abilityDeployInfoExtendShareInputParams);
            }
        } else {
            List<AbilityProvideHsfDefaultInputPO> abilityProvideHsfDefaultInputPOList = (List<AbilityProvideHsfDefaultInputPO>)abilityProvideDefaultInputPOMap.get(abilityProvideDeployBO.getAbilityAppBO().getAbilityAppId());
            if (abilityProvideHsfDefaultInputPOList == null) {
                AbilityProvideHsfDefaultInputPO abilityProvideHsfDefaultInputPO = new AbilityProvideHsfDefaultInputPO();
                AbilityAppBO abilityAppBO = abilityProvideDeployBO.getAbilityAppBO();
                abilityProvideHsfDefaultInputPO.setAbilityId(abilityPO.getAbilityId());
                abilityProvideHsfDefaultInputPOList = this.abilityProvideHsfDefaultInputMapper.queryByCond(abilityProvideHsfDefaultInputPO);
                abilityProvideDefaultInputPOMap.put(abilityAppBO.getAbilityAppId(), abilityProvideHsfDefaultInputPOList);
            }
            for (AbilityProvideHsfDefaultInputPO abilityProvideHsfDefaultInputPO : abilityProvideHsfDefaultInputPOList) {
                AbilityDeployInfoExtendShareInputParams abilityDeployInfoExtendShareInputParams = new AbilityDeployInfoExtendShareInputParams();
                abilityDeployInfoExtendShareInputParams.setArgsName(abilityProvideHsfDefaultInputPO.getArgsName());
                abilityDeployInfoExtendShareInputParams.setArgsPath(abilityProvideHsfDefaultInputPO.getArgsPath());
                abilityDeployInfoExtendShareInputParams.setSort(abilityProvideHsfDefaultInputPO.getSort());
                abilityDeployInfoExtendShareInputParamsList.add(abilityDeployInfoExtendShareInputParams);
            }
        }
        abilityDeployInfoExtendData.setType("hsf-form-area-label");
    }

    private void deleteAbilityDeployCustom(String outputProtocal, Long provideDeployId) {
        switch (outputProtocal) {
            case "json": {
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(provideDeployId);
                break;
            }
            case "xml": {
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(provideDeployId);
                break;
            }
            case "dubbo": {
                this.abilityProvideDubboCustomMapper.deleteByProvideDeployId(provideDeployId);
                this.abilityProvideDubboCustomInputMapper.deleteByProvideDeployId(provideDeployId);
                break;
            }
            case "hsf": {
                this.abilityProvideHsfCustomMapper.deleteByProvideDeployId(provideDeployId);
                this.abilityProvideHsfCustomInputMapper.deleteByProvideDeployId(provideDeployId);
                break;
            }
            case "ws": {
                this.abilityProvideHttpCustomMapper.deleteByProvideDeployId(provideDeployId);
                break;
            }
            default: {
                throw new ZTBusinessException("\u534f\u8bae\u7c7b\u578b\u9519\u8bef");
            }
        }
    }

    private void checkForRpc(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getFormData().getInterfaceName())) {
            throw new ZTBusinessException("rpc\u534f\u8bae\u80fd\u529b\uff0c\u63a5\u53e3\u540d\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getFormData().getMethodName())) {
            throw new ZTBusinessException("rpc\u534f\u8bae\u80fd\u529b\uff0c\u65b9\u6cd5\u540d\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getFormData().getGroupName())) {
            throw new ZTBusinessException("rpc\u534f\u8bae\u80fd\u529b\uff0c\u5206\u7ec4\u540d\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((Object)saveAbilityDeployReqBO.getExtendData().getFormData().getVersion())) {
            throw new ZTBusinessException("rpc\u534f\u8bae\u80fd\u529b\uff0c\u63a5\u53e3\u7248\u672c\u5fc5\u586b");
        }
    }

    private void saveAbilityProvideHttpCustom(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        AbilityProvideHttpCustomPO abilityProvideHttpCustomPO = new AbilityProvideHttpCustomPO();
        abilityProvideHttpCustomPO.setProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        abilityProvideHttpCustomPO.setEprPath(saveAbilityDeployReqBO.getExtendData().getEprPath());
        this.abilityProvideHttpCustomMapper.insertSelective(abilityProvideHttpCustomPO);
    }

    private void saveAbilityProvideDubboCustom(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        AbilityProvideDubboCustomPO abilityProvideDubboCustomPO = new AbilityProvideDubboCustomPO();
        abilityProvideDubboCustomPO.setProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        abilityProvideDubboCustomPO.setInterfaceName(saveAbilityDeployReqBO.getExtendData().getFormData().getInterfaceName());
        abilityProvideDubboCustomPO.setMethodName(saveAbilityDeployReqBO.getExtendData().getFormData().getMethodName());
        abilityProvideDubboCustomPO.setGroupName(saveAbilityDeployReqBO.getExtendData().getFormData().getGroupName());
        abilityProvideDubboCustomPO.setVersion(saveAbilityDeployReqBO.getExtendData().getFormData().getVersion());
        this.abilityProvideDubboCustomMapper.insertSelective(abilityProvideDubboCustomPO);
        ArrayList<AbilityProvideDubboCustomInputPO> abilityProvideDubboCustomInputPOList = new ArrayList<AbilityProvideDubboCustomInputPO>();
        List<SaveAbilityDeployInputParams> saveAbilityDeployInputParamsList = saveAbilityDeployReqBO.getExtendData().getInputParams();
        if (saveAbilityDeployInputParamsList != null && saveAbilityDeployInputParamsList.size() > 0) {
            for (SaveAbilityDeployInputParams saveAbilityDeployInputParams : saveAbilityDeployInputParamsList) {
                AbilityProvideDubboCustomInputPO abilityProvideDubboCustomInputPO = (AbilityProvideDubboCustomInputPO)BeanMapper.map((Object)saveAbilityDeployInputParams, AbilityProvideDubboCustomInputPO.class);
                abilityProvideDubboCustomInputPO.setProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                abilityProvideDubboCustomInputPOList.add(abilityProvideDubboCustomInputPO);
            }
            this.abilityProvideDubboCustomInputMapper.insertRecords(abilityProvideDubboCustomInputPOList);
        }
    }

    private void saveAbilityProvidHsfCustom(SaveAbilityDeployReqBO saveAbilityDeployReqBO) {
        AbilityProvideHsfCustomPO abilityProvideHsfCustomPO = new AbilityProvideHsfCustomPO();
        abilityProvideHsfCustomPO.setProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
        abilityProvideHsfCustomPO.setInterfaceName(saveAbilityDeployReqBO.getExtendData().getFormData().getInterfaceName());
        abilityProvideHsfCustomPO.setMethodName(saveAbilityDeployReqBO.getExtendData().getFormData().getMethodName());
        abilityProvideHsfCustomPO.setGroupName(saveAbilityDeployReqBO.getExtendData().getFormData().getGroupName());
        abilityProvideHsfCustomPO.setVersion(saveAbilityDeployReqBO.getExtendData().getFormData().getVersion());
        this.abilityProvideHsfCustomMapper.insertSelective(abilityProvideHsfCustomPO);
        ArrayList<AbilityProvideHsfCustomInputPO> abilityProvideHsfCustomInputPOArrayList = new ArrayList<AbilityProvideHsfCustomInputPO>();
        List<SaveAbilityDeployInputParams> saveAbilityDeployInputParamsList = saveAbilityDeployReqBO.getExtendData().getInputParams();
        if (saveAbilityDeployInputParamsList != null && saveAbilityDeployInputParamsList.size() > 0) {
            for (SaveAbilityDeployInputParams saveAbilityDeployInputParams : saveAbilityDeployInputParamsList) {
                AbilityProvideHsfCustomInputPO abilityProvideHsfCustomInputPO = (AbilityProvideHsfCustomInputPO)BeanMapper.map((Object)saveAbilityDeployInputParams, AbilityProvideHsfCustomInputPO.class);
                abilityProvideHsfCustomInputPO.setProvideDeployId(saveAbilityDeployReqBO.getProvideDeployId());
                abilityProvideHsfCustomInputPOArrayList.add(abilityProvideHsfCustomInputPO);
            }
            this.abilityProvideHsfCustomInputMapper.insertRecords(abilityProvideHsfCustomInputPOArrayList);
        }
    }
}

