/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityListReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityListRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityListService;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityToVegaPo;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityListServiceImpl
implements AbilityListService {
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private AuthorityService authorityService;
    @Autowired
    private AbilityToVegaMapper abilityToVegaMapper;

    @Override
    public RspBO<List<QryAbilityListRspBO>> queryAbilityList(QryAbilityListReqBO qryAbilityListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        StringBuilder order = new StringBuilder();
        if (qryAbilityListReqBO.getSortName() != null) {
            order.append(qryAbilityListReqBO.getSortName());
            if (qryAbilityListReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(qryAbilityListReqBO.getSortOrder());
            }
        } else {
            order.append("a.").append("UPDATE_TIME").append(" DESC");
        }
        Page page = PageMethod.startPage((int)qryAbilityListReqBO.getPageNo(), (int)qryAbilityListReqBO.getPageSize(), (String)order.toString());
        qryAbilityListReqBO.setHirerId(tenantId);
        ArrayList<QryAbilityListRspBO> qryAbilityListRspBOList = new ArrayList<QryAbilityListRspBO>();
        List<AbilityPO> abilityPOIdList = this.abilityMapper.queryAbilityList(qryAbilityListReqBO);
        for (AbilityPO abilityPOId : abilityPOIdList) {
            AbilityPO abilityPO = this.abilityMapper.queryAbilityWithProvideDeployByAbilityId(abilityPOId.getAbilityId());
            QryAbilityListRspBO qryAbilityListRspBO = (QryAbilityListRspBO)BeanMapper.map((Object)abilityPO, QryAbilityListRspBO.class);
            AbilityToVegaPo abilityToVegaPo = this.abilityToVegaMapper.queryByAbilityId(abilityPO.getAbilityId());
            if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)abilityToVegaPo))) {
                qryAbilityListRspBO.setForwardStatus(abilityToVegaPo.getForwardStatus());
            } else {
                qryAbilityListRspBO.setForwardStatus(0);
            }
            qryAbilityListRspBO.setAllClusterName(this.getAllClusterName(abilityPO.getAbilityProvideDeployPOList()));
            qryAbilityListRspBOList.add(qryAbilityListRspBO);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(qryAbilityListReqBO.getPageSize()), Integer.valueOf(qryAbilityListReqBO.getPageNo()), qryAbilityListRspBOList, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        return rspBO;
    }

    private String getAllClusterName(List<AbilityProvideDeployPO> abilityProvideDeployPOList) {
        StringBuilder sb = new StringBuilder();
        List clusterPOS = abilityProvideDeployPOList.stream().map(po -> this.clusterMapper.queryByClusterId(po.getClusterId())).distinct().collect(Collectors.toList());
        for (int i = 0; i < clusterPOS.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            ClusterPO clusterPO = (ClusterPO)clusterPOS.get(i);
            sb.append(clusterPO.getClusterName());
        }
        return sb.toString();
    }
}

