/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityBindPluginBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginReqsBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryPluginRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityPluginService;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.PluginPO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginBindAbilityRspBO;
import com.ohaotian.abilityadmin.plugin.model.bo.PluginReqsBO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.QryClusterReqBo;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityPluginServiceImpl
implements AbilityPluginService {
    private static final Logger log = LogManager.getLogger(AbilityPluginServiceImpl.class);
    @Resource
    private PluginService pluginService;
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private AbilityPluginDeployMapper abilityPluginDeployMapper;
    @Resource
    private AbilityPluginMapper abilityPluginMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private AuthorityService authorityService;

    @Override
    public RspBO<RspPage<QryPluginRspBO>> qryUnBindPluginsListPageByCond(QryPluginReqBO qryPluginReqBO) throws ZTBusinessException {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        qryPluginReqBO.setHirerId(tenantId);
        log.debug("AbilityPluginServiceImpl.qryUnBindPluginsListPageByCond:{}", (Object)qryPluginReqBO);
        if (StringUtils.isEmpty((Object)qryPluginReqBO.getAbilityId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getPluginEname())) {
            qryPluginReqBO.setPluginEname("%" + qryPluginReqBO.getPluginEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getPluginName())) {
            qryPluginReqBO.setPluginName("%" + qryPluginReqBO.getPluginName() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryPluginReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryPluginReqBO.getSortOrder())) {
                order.append(" ").append(qryPluginReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = qryPluginReqBO.getPageNo();
        int pageSize = qryPluginReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryPluginRspBO> pluginPOList = this.pluginMapper.queryUnBindPluginsByAbilityId(qryPluginReqBO);
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), pluginPOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<RspPage<QryPluginRspBO>> qryBindPluginsListPageByCond(QryPluginReqBO qryPluginReqBO) throws ZTBusinessException {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        qryPluginReqBO.setHirerId(tenantId);
        log.debug("AbilityPluginServiceImpl.qryBindPluginsListPageByCond:{}", (Object)qryPluginReqBO);
        if (StringUtils.isEmpty((Object)qryPluginReqBO.getAbilityId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getPluginEname())) {
            qryPluginReqBO.setPluginEname("%" + qryPluginReqBO.getPluginEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getPluginName())) {
            qryPluginReqBO.setPluginName("%" + qryPluginReqBO.getPluginName() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryPluginReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryPluginReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryPluginReqBO.getSortOrder())) {
                order.append(" ").append(qryPluginReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = qryPluginReqBO.getPageNo();
        int pageSize = qryPluginReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryPluginRspBO> pluginPOList = this.pluginMapper.queryBindPluginsByAbilityId(qryPluginReqBO);
        pluginPOList.stream().map(bo -> {
            QryClusterReqBo qryClusterReqBo = new QryClusterReqBo();
            qryClusterReqBo.setClusterId(bo.getClusterId());
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId(bo.getClusterId());
            bo.setClusterName(clusterPO.getClusterName());
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), pluginPOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> deleteAbilityPlugin(QryPluginReqBO qryPluginReqBO) throws ZTBusinessException {
        log.debug("AbilityPluginServiceImpl.deleteAbilityPlugin:{}", (Object)qryPluginReqBO);
        ValidBatchUtils.isNotEmpty((Object)qryPluginReqBO, (String[])new String[]{"abilityPluginDeployId", "pluginId", "abilityPluginId"});
        try {
            PluginPO pluginPO = this.pluginMapper.queryByPluginId(qryPluginReqBO.getPluginId());
            String pluginType = pluginPO.getPluginType();
            Long abilityPluginDeployId = qryPluginReqBO.getAbilityPluginDeployId();
            this.pluginService.handleDelete((Object)abilityPluginDeployId, pluginType, ExtensionPointPositionEnum.ABILITY_POSITION.getCode());
            AbilityPluginDeployPO abilityPluginDeployPO = new AbilityPluginDeployPO();
            abilityPluginDeployPO.setAbilityPluginId(qryPluginReqBO.getAbilityPluginId());
            List<AbilityPluginDeployPO> abilityPluginDeployPOList = this.abilityPluginDeployMapper.queryByCond(abilityPluginDeployPO);
            this.abilityPluginDeployMapper.deleteAbilityPluginDeployByAbilityPluginDeployId(qryPluginReqBO.getAbilityPluginDeployId());
            if (!CollectionUtils.isEmpty(abilityPluginDeployPOList) && abilityPluginDeployPOList.size() == 1) {
                this.abilityPluginMapper.deleteAbilityPluginByAbilityPluginId(qryPluginReqBO.getAbilityPluginId());
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AbilityPluginServiceImpl.deleteAbilityPlugin:{}", (Object)CodeMsg.PLUGIN_UNBIND_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.PLUGIN_UNBIND_ERROR.getMessage());
        }
    }

    @Override
    @Transactional
    public RspBO<Boolean> bathDeleteAbilityPlugin(QryPluginReqBO qryPluginReqBO) throws ZTBusinessException {
        List<Long> abilityPluginDeployIds = qryPluginReqBO.getAbilityPluginDeployIds();
        for (Long abilityPluginDeployId : abilityPluginDeployIds) {
            AbilityPluginDeployPO abilityPluginDeployPo = new AbilityPluginDeployPO();
            abilityPluginDeployPo.setAbilityPluginDeployId(abilityPluginDeployId);
            abilityPluginDeployPo = this.abilityPluginDeployMapper.queryLimitOne(abilityPluginDeployPo);
            AbilityPluginPO abilityPluginPo = new AbilityPluginPO();
            abilityPluginPo.setAbilityPluginId(abilityPluginDeployPo.getAbilityPluginId());
            abilityPluginPo = this.abilityPluginMapper.queryLimitOne(abilityPluginPo);
            PluginPO pluginPO1 = new PluginPO();
            pluginPO1.setHirerId(abilityPluginPo.getHirerId());
            pluginPO1.setPluginEname(abilityPluginPo.getPluginEname());
            PluginPO pluginPo = this.pluginMapper.queryLimitOne(pluginPO1);
            if (pluginPo != null) {
                String pluginType = pluginPo.getPluginType();
                this.pluginService.handleDelete((Object)abilityPluginDeployId, pluginType, ExtensionPointPositionEnum.ABILITY_POSITION.getCode());
            }
            AbilityPluginDeployPO tempForQuery = new AbilityPluginDeployPO();
            tempForQuery.setAbilityPluginId(abilityPluginDeployPo.getAbilityPluginId());
            List<AbilityPluginDeployPO> abilityPluginDeployPoList = this.abilityPluginDeployMapper.queryByCond(tempForQuery);
            if (abilityPluginDeployPoList.size() <= 1) {
                this.abilityPluginMapper.deleteAbilityPluginByAbilityPluginId(abilityPluginDeployPo.getAbilityPluginId());
            }
            this.abilityPluginDeployMapper.deleteAbilityPluginDeployByAbilityPluginDeployId(abilityPluginDeployId);
        }
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO bathPluginUnBindAbility(List<QryPluginReqsBO> qryPluginReqBoList) throws ZTBusinessException {
        for (QryPluginReqsBO qryPluginReqBO : qryPluginReqBoList) {
            ArrayList<Long> abilityPluginDeployId = new ArrayList<Long>();
            Long abilityId = qryPluginReqBO.getAbilityId();
            PluginReqsBO pluginReqsBO = new PluginReqsBO();
            pluginReqsBO.setAbilityId(abilityId);
            pluginReqsBO.setPluginId(qryPluginReqBO.getPluginId());
            pluginReqsBO.setClusterId(qryPluginReqBO.getClusterId());
            List<PluginBindAbilityRspBO> pluginBindAbilityRspBos = this.abilityMapper.queryCluster(pluginReqsBO);
            for (PluginBindAbilityRspBO pluginBindAbilityRspBO : pluginBindAbilityRspBos) {
                abilityPluginDeployId.add(pluginBindAbilityRspBO.getAbilityPluginDeployId());
            }
            QryPluginReqBO qryPluginReqBo1 = new QryPluginReqBO();
            qryPluginReqBo1.setAbilityPluginDeployIds(abilityPluginDeployId);
            this.bathDeleteAbilityPlugin(qryPluginReqBo1);
        }
        return RspBO.success((Object)"\u89e3\u7ed1\u6210\u529f\uff01");
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO saveAbilityBindPlugin(AbilityBindPluginBO abilityBindPluginBO) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        log.debug("AbilityPluginServiceImpl.saveAbilityBindPlugin:{}", (Object)abilityBindPluginBO);
        ValidBatchUtils.isNotEmpty((Object)abilityBindPluginBO, (String[])new String[]{"pluginId", "abilityId", "pluginType", "pluginName", "abilityName"});
        if (CollectionUtils.isEmpty(abilityBindPluginBO.getClusterIds())) {
            throw new ZTBusinessException(CodeMsg.APP_ARG_ERROR.getMessage());
        }
        try {
            for (Long clusterId : abilityBindPluginBO.getClusterIds()) {
                QryPluginReqBO qryPluginReqBO = new QryPluginReqBO();
                qryPluginReqBO.setClusterId(clusterId);
                qryPluginReqBO.setHirerId(tenantId);
                qryPluginReqBO.setAbilityId(abilityBindPluginBO.getAbilityId());
                qryPluginReqBO.setPluginId(abilityBindPluginBO.getPluginId());
                RspBO<RspPage<QryPluginRspBO>> rspPageRspBO = this.qryBindPluginsListPageByCond(qryPluginReqBO);
                if (((RspPage)rspPageRspBO.getData()).getRecordsTotal() < 1L) continue;
                List qryPluginRspBos = ((RspPage)rspPageRspBO.getData()).getRows();
                qryPluginReqBO.setAbilityPluginDeployId(((QryPluginRspBO)qryPluginRspBos.get(0)).getAbilityPluginDeployId());
                qryPluginReqBO.setAbilityPluginId(((QryPluginRspBO)qryPluginRspBos.get(0)).getAbilityPluginId());
                qryPluginReqBO.setPluginId(abilityBindPluginBO.getPluginId());
                this.deleteAbilityPlugin(qryPluginReqBO);
            }
            AbilityPO abilityPo = this.abilityMapper.queryByAbilityId(abilityBindPluginBO.getAbilityId());
            PluginPO pluginPo = this.pluginMapper.queryByPluginId(abilityBindPluginBO.getPluginId());
            AbilityPluginPO abilityPluginPO = (AbilityPluginPO)BeanMapper.map((Object)abilityPo, AbilityPluginPO.class);
            abilityPluginPO.setPluginEname(pluginPo.getPluginEname());
            AbilityPluginPO abilityPluginPO1 = this.abilityPluginMapper.queryLimitOne(abilityPluginPO);
            if (abilityPluginPO1 != null) {
                abilityPluginPO = abilityPluginPO1;
            } else {
                abilityPluginPO.setCreateTime(new Date());
                abilityPluginPO.setCreateUserId(userId);
                this.abilityPluginMapper.insertSelective(abilityPluginPO);
            }
            ArrayList abilityPluginDeployIdList = Lists.newArrayList();
            for (Long clusterId : abilityBindPluginBO.getClusterIds()) {
                AbilityPluginDeployPO abilityPluginDeployPo = new AbilityPluginDeployPO();
                abilityPluginDeployPo.setAbilityPluginId(abilityPluginPO.getAbilityPluginId());
                abilityPluginDeployPo.setClusterId(clusterId);
                abilityPluginDeployPo.setDeployTime(new Date());
                abilityPluginDeployPo.setDeployUserId(userId);
                this.abilityPluginDeployMapper.insertSelective(abilityPluginDeployPo);
                Long abilityPluginDeployId = abilityPluginDeployPo.getAbilityPluginDeployId();
                abilityPluginDeployIdList.add(abilityPluginDeployId);
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("abilityPluginDeployId", abilityPluginDeployId);
                map.put("pluginId", abilityBindPluginBO.getPluginId());
                this.pluginService.handleAdd(map, abilityBindPluginBO.getPluginType(), ExtensionPointPositionEnum.ABILITY_POSITION.getCode());
            }
            AbilityPluginReqBO abilityPluginReqBO = (AbilityPluginReqBO)BeanMapper.map((Object)abilityBindPluginBO, AbilityPluginReqBO.class);
            abilityPluginReqBO.setAbilityPluginDeployIds((List)abilityPluginDeployIdList);
            abilityPluginReqBO.setNextStep(StepEnum.END.getCode());
            return this.pluginService.handleGetAbilityPlugin(abilityPluginReqBO, ExtensionPointPositionEnum.ABILITY_POSITION.getCode());
        }
        catch (Exception e) {
            log.error("AbilityPluginServiceImpl.saveAbilityBindPlugin:{}", (Object)CodeMsg.PLUGIN_BIND_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.PLUGIN_BIND_ERROR.getMessage());
        }
    }
}

