/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.cluster.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Maps;
import com.ohaotian.abilityadmin.cluster.model.AgentNodeReqBO;
import com.ohaotian.abilityadmin.cluster.model.AgentNodeRspBO;
import com.ohaotian.abilityadmin.cluster.model.ClusterReqBO;
import com.ohaotian.abilityadmin.cluster.model.NodeReqBO;
import com.ohaotian.abilityadmin.cluster.model.NodeRspBO;
import com.ohaotian.abilityadmin.cluster.service.ClusterService;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.AgentNodeDubboMapper;
import com.ohaotian.abilityadmin.mapper.AgentNodeHsfMapper;
import com.ohaotian.abilityadmin.mapper.AgentNodeMapper;
import com.ohaotian.abilityadmin.mapper.AgentProtocolMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppRegionMapper;
import com.ohaotian.abilityadmin.mapper.AppSecretMapper;
import com.ohaotian.abilityadmin.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.NodeMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.AgentNodeDubboPO;
import com.ohaotian.abilityadmin.model.po.AgentNodeHsfPO;
import com.ohaotian.abilityadmin.model.po.AgentNodePO;
import com.ohaotian.abilityadmin.model.po.AgentProtocolPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppRegionPO;
import com.ohaotian.abilityadmin.model.po.AppSecretPO;
import com.ohaotian.abilityadmin.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.NodePO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.ClusterRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.GetRandomPwd;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ClusterServiceImpl
implements ClusterService {
    private static final Logger log = LogManager.getLogger(ClusterServiceImpl.class);
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private NodeMapper nodeMapper;
    @Resource
    private AgentNodeMapper agentNodeMapper;
    @Resource
    private AgentProtocolMapper agentProtocolMapper;
    @Resource
    private AgentNodeHsfMapper agentNodeHsfMapper;
    @Resource
    private AgentNodeDubboMapper agentNodeDubboMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    private AppMapper appMapper;
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;
    @Resource
    private AbilityPluginDeployMapper abilityPluginDeployMapper;
    @Resource
    private AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private AppRegionMapper appRegionMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Autowired
    CacheClient cacheClient;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    @Override
    public RspBO<RspPage<ClusterRspBO>> qryClusterList(ClusterReqBO clusterReqBO) {
        log.debug("ClusterServiceImpl.qryClusterList:{}", (Object)clusterReqBO);
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        if (!StringUtils.isEmpty((Object)clusterReqBO.getClusterName())) {
            clusterReqBO.setClusterName("%" + clusterReqBO.getClusterName() + "%");
        }
        if (!StringUtils.isEmpty((Object)clusterReqBO.getClusterEname())) {
            clusterReqBO.setClusterEname("%" + clusterReqBO.getClusterEname() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)clusterReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)clusterReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)clusterReqBO.getSortOrder())) {
                order.append(" ").append(clusterReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = clusterReqBO.getPageNo();
        int pageSize = clusterReqBO.getPageSize();
        ClusterPO clusterPO = (ClusterPO)BeanMapper.map((Object)clusterReqBO, ClusterPO.class);
        clusterPO.setHirerId(tenantId);
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<ClusterRspBO> clusterListBOReq = this.clusterMapper.queryListByCond(clusterPO);
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), clusterListBOReq, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional
    public RspBO<Boolean> clusterAdd(ClusterReqBO clusterReqBO) {
        log.debug("ClusterServiceImpl.clusterAdd:{}", (Object)clusterReqBO);
        ValidBatchUtils.isNotEmpty((Object)clusterReqBO, (String[])new String[]{"clusterEname", "clusterName"});
        try {
            ClusterPO clusterPOForQuery = new ClusterPO();
            clusterPOForQuery.setClusterEname(clusterReqBO.getClusterEname());
            clusterPOForQuery = this.clusterMapper.queryLimitOne(clusterPOForQuery);
            if (clusterPOForQuery != null) {
                return RspBO.error((String)("\u7f16\u7801:" + clusterReqBO.getClusterEname() + "\u5df2\u5b58\u5728"));
            }
            Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
            ClusterPO clusterPO = (ClusterPO)BeanMapper.map((Object)clusterReqBO, ClusterPO.class);
            clusterPO.setHirerId(tenantId);
            clusterPO.setCreateUserId(Long.parseLong(UserHolder.getUserId()));
            clusterPO.setCreateTime(new Date());
            this.clusterMapper.insertSelective(clusterPO);
            AppPO appPO = new AppPO();
            appPO.setHirerId(tenantId);
            if (appPO == null) {
                throw new ZTBusinessException("\u6ce8\u518c\u96c6\u7fa4\u83b7\u53d6\u79df\u6237id\u5931\u8d25");
            }
            List<AppPO> appPOS = this.appMapper.queryByCondList(appPO);
            appPOS.stream().forEach(a -> {
                AppSecretPO appSecretPO = new AppSecretPO();
                appSecretPO.setAppSecret(GetRandomPwd.getRandomPwd((int)32));
                appSecretPO.setClusterId(clusterPO.getClusterId());
                appSecretPO.setAppId(a.getAppId());
                appSecretPO.setAppCode(a.getAppCode());
                this.appSecretMapper.insert(appSecretPO);
            });
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    @Override
    public RspBO<ClusterRspBO> qryClusterById(Long clusterId) {
        log.debug("ClusterServiceImpl.qryClusterById:{}", (Object)clusterId);
        if (StringUtils.isEmpty((Object)clusterId)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        ClusterPO clusterPO = this.clusterMapper.queryByClusterId(clusterId);
        ClusterRspBO clusterRspBO = (ClusterRspBO)BeanMapper.map((Object)clusterPO, ClusterRspBO.class);
        if (!StringUtils.isEmpty((Object)clusterRspBO.getCreateUserId())) {
            clusterRspBO.setCreateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(clusterRspBO.getCreateUserId())).getName());
        }
        if (!StringUtils.isEmpty((Object)clusterRspBO.getUpdateUserId())) {
            clusterRspBO.setUpdateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(clusterRspBO.getUpdateUserId())).getName());
        }
        return RspBO.success((Object)clusterRspBO);
    }

    @Override
    @Transactional
    public RspBO<Boolean> delClusterById(Long clusterId) {
        log.debug("ClusterServiceImpl.delClusterById:{}", (Object)clusterId);
        if (StringUtils.isEmpty((Object)clusterId)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        ClusterPO clusterPO = this.clusterMapper.queryByClusterId(clusterId);
        List<AbilityProvideDeployPO> abilityProvideDeployPOS = this.abilityProvideDeployMapper.queryByClusterId(clusterId);
        if (abilityProvideDeployPOS != null && abilityProvideDeployPOS.size() > 0) {
            String collect = abilityProvideDeployPOS.stream().map(a -> {
                AbilityAppPO abilityAppPO = this.abilityAppMapper.queryByAbilityAppId(a.getAbilityAppId());
                return "\u5e94\u7528" + abilityAppPO.getAppCode() + "\u90e8\u7f72\u80fd\u529b" + abilityAppPO.getAbilityEname() + "_" + abilityAppPO.getAbilityVersion();
            }).collect(Collectors.joining(","));
            throw new ZTBusinessException("\u96c6\u7fa4\u4e0d\u53ef\u5220\u9664\uff0c" + clusterPO.getClusterName() + "\u5b58\u5728\u80fd\u529b\u53d1\u5e03:" + collect + ",\u8bf7\u5148\u89e3\u9664\u53d1\u5e03\u5173\u7cfb\uff0c\u518d\u5220\u9664\u6b64\u96c6\u7fa4");
        }
        List<AppSubscribeDeployPO> appSubscribeDeployPOS = this.appSubscribeDeployMapper.queryByClusterId(clusterId);
        if (appSubscribeDeployPOS != null && appSubscribeDeployPOS.size() > 0) {
            String collect = appSubscribeDeployPOS.stream().map(a -> {
                AbilityAppPO abilityAppPO = this.abilityAppMapper.queryByAbilityAppId(a.getAbilityAppId());
                return "\u5e94\u7528" + abilityAppPO.getAppCode() + "\u8ba2\u8d2d\u80fd\u529b" + abilityAppPO.getAbilityEname() + "_" + abilityAppPO.getAbilityVersion();
            }).collect(Collectors.joining("\uff0c"));
            throw new ZTBusinessException("\u96c6\u7fa4\u4e0d\u53ef\u5220\u9664\uff0c" + clusterPO.getClusterName() + "\u5b58\u5728\u5e94\u7528\u8ba2\u8d2d\u80fd\u529b:" + collect + ",\u8bf7\u5148\u89e3\u9664\u8ba2\u8d2d\u5173\u7cfb\uff0c\u518d\u5220\u9664\u6b64\u96c6\u7fa4");
        }
        List<AppRegionPO> appRegionPOS = this.appRegionMapper.queryByClusterId(clusterId);
        if (appRegionPOS != null && appRegionPOS.size() > 0) {
            String collect = appRegionPOS.stream().map(a -> "\u5e94\u7528>" + a.getAppCode() + "\u5206\u533a>" + a.getRegionCode() + "").collect(Collectors.joining(","));
            throw new ZTBusinessException("\u96c6\u7fa4\u4e0d\u53ef\u5220\u9664\uff0c" + clusterPO.getClusterName() + "\u5b58\u5728\u5206\u533a\u3002" + collect + ",\u8bf7\u5148\u5220\u9664\u5206\u533a\uff0c\u518d\u5220\u9664\u6b64\u96c6\u7fa4");
        }
        NodePO nodePO = new NodePO();
        nodePO.setClusterId(clusterId);
        nodePO.setValidFlag(1);
        List<NodePO> nodePOList = this.nodeMapper.queryByCond(nodePO);
        AgentNodePO agentNodePO = new AgentNodePO();
        agentNodePO.setClusterId(clusterId);
        agentNodePO.setValidFlag(1);
        List<AgentNodePO> agentNodePOList = this.agentNodeMapper.queryByCond(agentNodePO);
        if (!CollectionUtils.isEmpty(nodePOList) || !CollectionUtils.isEmpty(agentNodePOList)) {
            throw new ZTBusinessException("\u96c6\u7fa4\u5b58\u5728\u6709\u6548\u7684\u6838\u5fc3\u8282\u70b9\u6216\u8005\u4ee3\u7406\u8282\u70b9\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        agentNodePO.setValidFlag(0);
        agentNodePOList = this.agentNodeMapper.queryByCond(agentNodePO);
        if (!CollectionUtils.isEmpty(agentNodePOList)) {
            List<Long> agentNodeIds = agentNodePOList.stream().map(po -> po.getAgentNodeId()).collect(Collectors.toList());
            this.agentProtocolMapper.deleteByAgentNodeIds(agentNodeIds);
        }
        this.agentNodeMapper.deleteByClusterId(clusterId);
        this.clusterMapper.deleteClusterByClusterId(clusterId);
        this.rateLimiterAbilityMapper.deleteRateLimiterAbilityByClusterId(clusterId);
        this.appSecretMapper.deleteByClusterId(clusterId);
        if (clusterPO != null) {
            this.pubSubMsgHandler.delRedisClusterNode(clusterPO);
        }
        this.nodeMapper.deleteByClusterId(clusterId);
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO<Boolean> updateCluster(ClusterReqBO clusterReqBO) {
        log.debug("ClusterServiceImpl.updateCluster:{}", (Object)clusterReqBO);
        ValidBatchUtils.isNotEmpty((Object)clusterReqBO, (String[])new String[]{"clusterId", "clusterEname", "clusterName"});
        try {
            ClusterPO clusterPO = (ClusterPO)BeanMapper.map((Object)clusterReqBO, ClusterPO.class);
            clusterPO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
            clusterPO.setUpdateTime(new Date());
            this.clusterMapper.updateClusterByClusterId(clusterPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Override
    public RspBO<RspPage<NodeRspBO>> qryCoreNodeList(NodeReqBO nodeReqBO) {
        log.debug("ClusterServiceImpl.qryCoreNodeList:{}", (Object)nodeReqBO);
        if (StringUtils.isEmpty((Object)nodeReqBO.getClusterId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        Map nodesInfo = (Map)GsonUtil.fromJson((String)this.cacheClient.get(this.constantBaseVersion.getWEB_NODES()).toString(), Map.class);
        List rspInfoList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)nodesInfo)) {
            Object o = nodesInfo.get(nodeReqBO.getClusterId() + "");
            if (!ObjectUtils.isEmpty(o)) {
                rspInfoList = GsonUtil.fromList((String)GsonUtil.toJson(o), Map[].class);
            } else {
                log.info("\u8be5\u96c6\u7fa4\u4e0b\u6ca1\u6709\u8282\u70b9\u6570\u636e\u4fe1\u606f\uff01");
            }
        } else {
            log.info("\u6ca1\u6709\u4efb\u4f55web\u8282\u70b9\u4fe1\u606f\uff01");
        }
        RspPage rspPage = new RspPage(Integer.valueOf(nodeReqBO.getPageSize()), Integer.valueOf(nodeReqBO.getPageNo()), rspInfoList, Long.valueOf(Long.parseLong(rspInfoList.size() + "")));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<Boolean> delInvalidNods(NodeReqBO nodeReqBO) {
        log.debug("ClusterServiceImpl.delInvalidNods:{}", (Object)nodeReqBO);
        Map nodes = (Map)GsonUtil.fromJson((String)this.cacheClient.get(this.constantBaseVersion.getWEB_NODES()).toString(), Map.class);
        Long clusterId = nodeReqBO.getClusterId();
        if (!ObjectUtils.isEmpty((Object)nodes)) {
            if (!ObjectUtils.isEmpty(nodes.get(clusterId.toString()))) {
                List nodesInfo = GsonUtil.fromList((String)GsonUtil.toJson(nodes.get(clusterId.toString())), Object[].class);
                ArrayList<Map> nodesNewInfo = new ArrayList<Map>();
                for (Object node : nodesInfo) {
                    Map nodeInfo = GsonUtil.toObjectMap((String)GsonUtil.toJson(node));
                    nodeInfo.put("invalidNodes", new ArrayList());
                    nodeInfo.put("invalidNodeCount", "0");
                    if (nodeInfo.get("efficientNodeCount").equals("0")) {
                        String nodeIp = nodeInfo.get("nodeIp").toString();
                        Integer port = Integer.parseInt(nodeInfo.get("port").toString());
                        int n = this.nodeMapper.deleteNodeByClusterIdAndNodeIpAndPort(clusterId, nodeIp, port);
                        continue;
                    }
                    nodesNewInfo.add(nodeInfo);
                }
                if (nodesNewInfo.size() != 0) {
                    nodes.put(nodeReqBO.getClusterId() + "", nodesNewInfo);
                } else {
                    nodes.remove(nodeReqBO.getClusterId() + "");
                }
            } else {
                log.info("\u66f4\u65b0\u8282\u70b9\uff1a\u8be5\u96c6\u7fa4\u4e0b\u6ca1\u6709web\u4fe1\u606f\uff01");
            }
        } else {
            log.info("\u66f4\u65b0\u8282\u70b9\uff1a\u6ca1\u6709\u4efb\u4f55\u8282\u70b9\u4fe1\u606f\uff01");
        }
        this.cacheClient.set(this.constantBaseVersion.getWEB_NODES(), (Object)GsonUtil.toJson((Object)nodes));
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO<RspPage<AgentNodeRspBO>> qryAgentNodeList(AgentNodeReqBO agentNodeReqBO) {
        log.debug("ClusterServiceImpl.qryAgentNodeList:{}", (Object)agentNodeReqBO);
        if (StringUtils.isEmpty((Object)agentNodeReqBO.getClusterId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)agentNodeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)agentNodeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)agentNodeReqBO.getSortOrder())) {
                order.append(" ").append(agentNodeReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = agentNodeReqBO.getPageNo();
        int pageSize = agentNodeReqBO.getPageSize();
        AgentNodePO agentNodePO = (AgentNodePO)BeanMapper.map((Object)agentNodeReqBO, AgentNodePO.class);
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<AgentNodePO> agentNodePOList = this.agentNodeMapper.queryByCond(agentNodePO);
        List agentNodeRspBOList = BeanMapper.mapList(agentNodePOList, AgentNodeRspBO.class);
        agentNodeRspBOList.stream().map(bo -> {
            SystemCodeValue validFlag = SystemCodeMap.getSystemCode((String)"1002", (String)(bo.getValidFlag() + ""));
            if (validFlag != null) {
                bo.setValidFlagName(validFlag.getDicValue());
            }
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), agentNodeRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<Map<String, Object>> qryAgentNodeById(Long agentNodeId) {
        log.debug("ClusterServiceImpl.qryAgentNodeById:{}", (Object)agentNodeId);
        HashMap map = Maps.newHashMap();
        HashMap shareData = Maps.newHashMap();
        HashMap formData = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)agentNodeId)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        AgentNodePO agentNodePO = this.agentNodeMapper.queryByAgentNodeId(agentNodeId);
        if (agentNodePO == null) {
            throw new ZTBusinessException(CodeMsg.AGENT_NODE_DETAIL_ERROR.getMessage());
        }
        formData.put("AgentNodeIp", agentNodePO.getAgentNodeIp());
        formData.put("port", agentNodePO.getPort());
        formData.put("protocol", agentNodePO.getProtocol());
        formData.put("remark", agentNodePO.getRemark());
        AgentProtocolPO agentProtocolPO = new AgentProtocolPO();
        agentProtocolPO.setAgentNodeId(agentNodePO.getAgentNodeId());
        agentProtocolPO.setProtocol(agentNodePO.getProtocol());
        agentProtocolPO = this.agentProtocolMapper.queryLimitOne(agentProtocolPO);
        if (agentProtocolPO == null) {
            throw new ZTBusinessException(CodeMsg.AGENT_NODE_DETAIL_ERROR.getMessage());
        }
        if (agentProtocolPO.getProtocol().equals("hsf")) {
            AgentNodeHsfPO agentNodeHsfPO = this.agentNodeHsfMapper.queryByAgnetHsfId(agentProtocolPO.getProtocolId());
            if (agentNodeHsfPO == null) {
                throw new ZTBusinessException(CodeMsg.AGENT_NODE_DETAIL_ERROR.getMessage());
            }
            formData.put("edasAddr", agentNodeHsfPO.getEdasAddr());
            formData.put("tenantId", agentNodeHsfPO.getTenantId());
            formData.put("ak", agentNodeHsfPO.getAk());
            formData.put("sk", agentNodeHsfPO.getSk());
            map.put("type", "proxy-node-detail-hsf");
        } else {
            AgentNodeDubboPO agentNodeDubboPO = this.agentNodeDubboMapper.queryByAgnetDubboId(agentProtocolPO.getProtocolId());
            if (agentNodeDubboPO == null) {
                throw new ZTBusinessException(CodeMsg.AGENT_NODE_DETAIL_ERROR.getMessage());
            }
            formData.put("zkAddr", agentNodeDubboPO.getZkAddr());
            formData.put("account", agentNodeDubboPO.getAccount());
            formData.put("dubboPwd", agentNodeDubboPO.getDubboPwd());
            map.put("type", "proxy-node-detail-dubbo");
        }
        shareData.put("formData", formData);
        map.put("shareData", shareData);
        return RspBO.success((Object)map);
    }
}

