/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ToolsJarUtil {
    private static Logger logger = LogManager.getLogger(ToolsJarUtil.class);

    public static void compile(String jarPath, String classPath, String workDir) throws Exception {
        CommandLine cmd = new CommandLine("jar");
        cmd.addArgument("-cf");
        cmd.addArgument(jarPath);
        cmd.addArgument(classPath);
        logger.info(cmd.toString());
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(new File(workDir));
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, (OutputStream)stderr, null));
        executor.execute(cmd);
        if (stderr.toString().length() > 0) {
            throw new RuntimeException("Sandbox Aborted." + stderr.toString());
        }
        logger.info("class to jar OK");
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "PATH_TRAVERSAL_IN"})
    public static Integer execCmdWithoutResult(String jarPath, String classPath, String workDir) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("jar -cf " + jarPath + " " + classPath, null, new File(workDir));
        return process.waitFor();
    }

    public static void main(String[] args) {
        try {
            ToolsJarUtil.compile("D:\\DATA\\jar\\yao_req.jar", "*", "D:\\DATA\\javac");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

