/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.ohaotian.abilityadmin.ability.model.bo.AbilitySubscribeDeployBO;
import com.ohaotian.abilityadmin.ability.service.RateLimiterSubscribeService;
import com.ohaotian.abilityadmin.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityadmin.model.po.RateLimiterSubscribePO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class RateLimiterSubscribeServiceImpl
implements RateLimiterSubscribeService {
    private static final Logger log = LogManager.getLogger(RateLimiterSubscribeServiceImpl.class);
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;

    @Override
    public RspBO<Boolean> updateRateLimiter(AbilitySubscribeDeployBO abilitySubscribeDeployBO) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        log.debug("RateLimiterSubscribeServiceImpl.updateRateLimiter:{}", (Object)abilitySubscribeDeployBO);
        ValidBatchUtils.isNotEmpty((Object)abilitySubscribeDeployBO, (String[])new String[]{"subscribeDeployId", "rate", "capacity", "dailyCapacity", "singleMaxRate", "singleMaxCount", "singleDailyMaxCount"});
        RateLimiterSubscribePO rateLimiterSubscribePO = (RateLimiterSubscribePO)BeanMapper.map((Object)abilitySubscribeDeployBO, RateLimiterSubscribePO.class);
        rateLimiterSubscribePO.setUpdateTime(new Date());
        rateLimiterSubscribePO.setUpdateUserId(userId);
        try {
            this.rateLimiterSubscribeMapper.updateRateLimiterSubscribeBySubscribeDeployId(rateLimiterSubscribePO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("RateLimiterSubscribeServiceImpl.updateRateLimiter:{}", (Object)e.getMessage(), (Object)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

