/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.system.controller;

import com.ohaotian.abilityadmin.ability.model.bo.AbilityBO;
import com.ohaotian.abilityadmin.ability.service.AbilityDeployService;
import com.ohaotian.abilityadmin.app.service.AppService;
import com.ohaotian.abilityadmin.system.model.bo.AppForSelectRspBO;
import com.ohaotian.abilityadmin.system.model.bo.AttendStatusForSelectRspBO;
import com.ohaotian.abilityadmin.system.model.bo.OptionRspBO;
import com.ohaotian.abilityadmin.system.model.bo.ReqSystemCodeBO;
import com.ohaotian.abilityadmin.system.model.bo.RspCodeReqBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncReqBO;
import com.ohaotian.abilityadmin.system.model.bo.SysReqBO;
import com.ohaotian.abilityadmin.system.service.SysService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
public class SysController {
    private static Logger logger = LogManager.getLogger(SysController.class);
    @Resource
    SysService sysService;
    @Resource
    AppService appService;
    @Resource
    private AbilityDeployService abilityDeployService;

    @RequestMapping(value={"/qryDomain"})
    @BusiResponseBody
    public RspBO qryDomain() {
        return this.sysService.qryDomain();
    }

    @RequestMapping(value={"/qryIndustry"})
    @BusiResponseBody
    public RspBO qryIndustry() {
        return this.sysService.qryIndustry();
    }

    @RequestMapping(value={"/qryAreaCode"})
    @BusiResponseBody
    public RspBO qryAreaCode() {
        return this.sysService.qryAreaCode();
    }

    @RequestMapping(value={"/qryInputProtocal"})
    @BusiResponseBody
    public RspBO qryInputProtocal() {
        return this.sysService.qryInputProtocal();
    }

    @RequestMapping(value={"/qryOutputProtocal"})
    @BusiResponseBody
    public RspBO qryOutputProtocal() {
        return this.sysService.qryOutputProtocal();
    }

    @RequestMapping(value={"/qryPluginType"})
    @BusiResponseBody
    public RspBO qryPluginType() {
        return this.sysService.qryPluginType();
    }

    @RequestMapping(value={"/appList"})
    @BusiResponseBody
    public RspBO appList() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        List<AppForSelectRspBO> optionRspBOList = this.appService.queryAllApp();
        RspBO rspBO = RspBO.success(optionRspBOList);
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{rspBO});
        return rspBO;
    }

    @RequestMapping(value={"/appProvideList"})
    @BusiResponseBody
    public RspBO appProvideList() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        List<OptionGenerRspBO<String, Long>> optionRspBOList = this.appService.queryAllProvideApp();
        RspBO rspBO = RspBO.success(optionRspBOList);
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{rspBO});
        return rspBO;
    }

    @RequestMapping(value={"/appProvideListWithCode"})
    @BusiResponseBody
    public RspBO appProvideListWithCode() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        List<OptionGenerRspBO<String, String>> optionRspBOList = this.appService.appProvideListWithCode();
        RspBO rspBO = RspBO.success(optionRspBOList);
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{rspBO});
        return rspBO;
    }

    @RequestMapping(value={"/qryAbilityAppCodeSourceType"})
    @BusiResponseBody
    public RspBO qryAbilityAppCodeSourceType() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        RspBO<List<OptionGenerRspBO>> listRspBO = this.sysService.qryAbilityAppCodeSourceType();
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{listRspBO});
        return listRspBO;
    }

    @RequestMapping(value={"/attendStatusList"})
    @BusiResponseBody
    public RspBO qryAttendStatusList() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        ArrayList<AttendStatusForSelectRspBO> attendStatusForSelectRspBOList = new ArrayList<AttendStatusForSelectRspBO>();
        AttendStatusForSelectRspBO attendStatus1 = new AttendStatusForSelectRspBO();
        attendStatus1.setLabel("\u7b7e\u9000");
        attendStatus1.setValue(Constants.AttendStatus.SIGN_OUT);
        AttendStatusForSelectRspBO attendStatus2 = new AttendStatusForSelectRspBO();
        attendStatus2.setLabel("\u7b7e\u5230");
        attendStatus2.setValue(Constants.AttendStatus.SIGN_IN);
        attendStatusForSelectRspBOList.add(attendStatus1);
        attendStatusForSelectRspBOList.add(attendStatus2);
        RspBO rspBO = RspBO.success(attendStatusForSelectRspBOList);
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{rspBO});
        return rspBO;
    }

    @RequestMapping(value={"/qrySubAbilityList"})
    @BusiResponseBody
    public RspBO qrySubAbilityList() {
        LogUtil.debug((Logger)logger, (String)"\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}:\u65b9\u6cd5\u65e0\u5165\u53c2", (Object[])new Object[0]);
        RspBO<List<OptionRspBO>> listRspBO = this.sysService.qrySubAbilityInfo();
        LogUtil.debug((Logger)logger, (String)"\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object[])new Object[]{listRspBO});
        return listRspBO;
    }

    @RequestMapping(value={"/qryAbilityType"})
    @BusiResponseBody
    public RspBO qryAbilityType() {
        return this.sysService.qryAbilityType();
    }

    @RequestMapping(value={"/qryPriority"})
    @BusiResponseBody
    public RspBO qryPriority() {
        return this.sysService.qryPriority();
    }

    @RequestMapping(value={"/queryRegionByAbilityAndCluster"})
    @BusiResponseBody
    public RspBO queryRegionByAbilityAndCluster(@RequestBody SysReqBO sysReqBO) {
        if (StringUtils.isEmpty((Object)sysReqBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u80fd\u529b");
        }
        if (StringUtils.isEmpty((Object)sysReqBO.getClusterId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u96c6\u7fa4");
        }
        return this.sysService.queryRegionByAbilityAndCluster(sysReqBO);
    }

    @RequestMapping(value={"/qryHaddrPolicy"})
    @BusiResponseBody
    public RspBO qryHaddrPolicy() {
        return this.sysService.qryHaddrPolicy();
    }

    @RequestMapping(value={"/qryRegionType"})
    @BusiResponseBody
    public RspBO qryRegionType() {
        return this.sysService.qryRegionType();
    }

    @RequestMapping(value={"/qryClusterInfo"})
    @BusiResponseBody
    public RspBO qryClusterInfo() {
        return this.sysService.qryClusterInfo();
    }

    @RequestMapping(value={"/queryClustersByAbilityId"})
    @BusiResponseBody
    public RspBO queryClustersByAbilityId(@RequestBody AbilityBO abilityBO) {
        return this.abilityDeployService.queryClustersByAbilityId(abilityBO.getAbilityId());
    }

    @RequestMapping(value={"/qrySystemCode"})
    @BusiResponseBody
    public RspBO qrySystemCode(@RequestBody ReqSystemCodeBO reqSystemCodeBO) {
        return this.sysService.qrySystemCode(reqSystemCodeBO);
    }

    @RequestMapping(value={"/sync"})
    @BusiResponseBody
    public RspBO syncH2(@RequestBody SyncReqBO syncReqBO) {
        return this.sysService.syncH2(syncReqBO);
    }

    @RequestMapping(value={"/qrySystemCodeByCodeId"})
    @BusiResponseBody
    public RspBO qrySystemCodeByCodeId(@RequestBody ReqSystemCodeBO reqSystemCodeBO) {
        return this.sysService.qrySystemCodeByCodeId(reqSystemCodeBO);
    }

    @RequestMapping(value={"/modSystemCode"})
    @BusiResponseBody
    public RspBO modSystemCode(@RequestBody ReqSystemCodeBO reqSystemCodeBO) {
        return this.sysService.modSystemCode(reqSystemCodeBO);
    }

    @RequestMapping(value={"/rspCodeList"})
    @BusiResponseBody
    public RspBO rspCodeList(@RequestBody RspCodeReqBO rspCodeReqBO) {
        return this.sysService.rspCodeList(rspCodeReqBO);
    }

    @RequestMapping(value={"/delSystemCodeByCodeId"})
    @BusiResponseBody
    public RspBO delSystemCodeByCodeId(@RequestBody ReqSystemCodeBO reqSystemCodeBO) {
        return this.sysService.delSystemCodeByCodeId(reqSystemCodeBO);
    }

    @RequestMapping(value={"/xml2json"})
    @BusiResponseBody
    public RspBO xml2json(@RequestBody String xml) {
        return this.sysService.xml2json(xml);
    }

    @RequestMapping(value={"/refreshSystemCodeMap"})
    @BusiResponseBody
    public RspBO refreshSystemCodeMap() {
        return this.sysService.refreshSystemCodeMap();
    }

    @RequestMapping(value={"/qrySystemCodeByCode"})
    @BusiResponseBody
    public RspBO qrySystemCodeByCode(@RequestBody ReqSystemCodeBO reqSystemCodeBO) {
        return this.sysService.qrySystemCodeByCode(reqSystemCodeBO);
    }
}

